/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceTimeOfDayAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.eclipselink.core.resource.java.TimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceCacheAnnotation
extends SourceAnnotation<Type>
implements CacheAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Cache");
    private static final DeclarationAnnotationElementAdapter<String> TYPE_ADAPTER = SourceCacheAnnotation.buildTypeAdapter();
    private final AnnotationElementAdapter<String> typeAdapter;
    private CacheType type;
    private static final DeclarationAnnotationElementAdapter<Integer> SIZE_ADAPTER = SourceCacheAnnotation.buildSizeAdapter();
    private final AnnotationElementAdapter<Integer> sizeAdapter;
    private Integer size;
    private static final DeclarationAnnotationElementAdapter<Boolean> SHARED_ADAPTER = SourceCacheAnnotation.buildSharedAdapter();
    private final AnnotationElementAdapter<Boolean> sharedAdapter;
    private Boolean shared;
    private static final DeclarationAnnotationElementAdapter<Integer> EXPIRY_ADAPTER = SourceCacheAnnotation.buildExpiryAdapter();
    private final AnnotationElementAdapter<Integer> expiryAdapter;
    private Integer expiry;
    private static final DeclarationAnnotationElementAdapter<Boolean> ALWAYS_REFRESH_ADAPTER = SourceCacheAnnotation.buildAlwaysRefreshAdapter();
    private final AnnotationElementAdapter<Boolean> alwaysRefreshAdapter;
    private TimeOfDayAnnotation expiryTimeOfDay;
    private static final DeclarationAnnotationElementAdapter<Boolean> REFRESH_ONLY_IF_NEWER_ADAPTER = SourceCacheAnnotation.buildRefreshOnlyIfNewerAdapter();
    private final AnnotationElementAdapter<Boolean> refreshOnlyIfNewerAdapter;
    private Boolean alwaysRefresh;
    private static final DeclarationAnnotationElementAdapter<Boolean> DISABLE_HITS_ADAPTER = SourceCacheAnnotation.buildDisableHitsAdapter();
    private final AnnotationElementAdapter<Boolean> disableHitsAdapter;
    private Boolean refreshOnlyIfNewer;
    private static final DeclarationAnnotationElementAdapter<String> COORDINATION_TYPE_ADAPTER = SourceCacheAnnotation.buildCoordinationTypeAdapter();
    private final AnnotationElementAdapter<String> coordinationTypeAdapter;
    private Boolean disableHits;
    private static final NestedDeclarationAnnotationAdapter EXPIRY_TIME_OF_DAY_ADAPTER = SourceCacheAnnotation.buildExpiryTimeOfDayAdapter();
    private final MemberAnnotationAdapter expiryTimeOfDayAdapter;
    private CacheCoordinationType coordinationType;

    public SourceCacheAnnotation(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.typeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, TYPE_ADAPTER);
        this.sizeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, SIZE_ADAPTER);
        this.sharedAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, SHARED_ADAPTER);
        this.expiryAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, EXPIRY_ADAPTER);
        this.alwaysRefreshAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, ALWAYS_REFRESH_ADAPTER);
        this.refreshOnlyIfNewerAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, REFRESH_ONLY_IF_NEWER_ADAPTER);
        this.disableHitsAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, DISABLE_HITS_ADAPTER);
        this.coordinationTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, COORDINATION_TYPE_ADAPTER);
        this.expiryTimeOfDayAdapter = new MemberAnnotationAdapter((Member)type, (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    public void initialize(CompilationUnit astRoot) {
        this.type = this.buildType(astRoot);
        this.size = this.buildSize(astRoot);
        this.shared = this.buildShared(astRoot);
        this.expiry = this.buildExpiry(astRoot);
        this.initializeExpiryTimeOfDay(astRoot);
        this.alwaysRefresh = this.buildAlwaysRefresh(astRoot);
        this.refreshOnlyIfNewer = this.buildRefreshOnlyIfNewer(astRoot);
        this.disableHits = this.buildDisableHits(astRoot);
        this.coordinationType = this.buildCoordinationType(astRoot);
    }

    private void initializeExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) != null) {
            this.expiryTimeOfDay = this.buildExpiryTimeOfDay();
            this.expiryTimeOfDay.initialize(astRoot);
        }
    }

    public void update(CompilationUnit astRoot) {
        this.setType(this.buildType(astRoot));
        this.setSize(this.buildSize(astRoot));
        this.setShared(this.buildShared(astRoot));
        this.setExpiry(this.buildExpiry(astRoot));
        this.updateExpiryTimeOfDay(astRoot);
        this.setAlwaysRefresh(this.buildAlwaysRefresh(astRoot));
        this.setRefreshOnlyIfNewer(this.buildRefreshOnlyIfNewer(astRoot));
        this.setDisableHits(this.buildDisableHits(astRoot));
        this.setCoordinationType(this.buildCoordinationType(astRoot));
    }

    private void updateExpiryTimeOfDay(CompilationUnit astRoot) {
        if (this.expiryTimeOfDayAdapter.getAnnotation(astRoot) == null) {
            this.setExpiryTimeOfDay(null);
        } else if (this.getExpiryTimeOfDay() == null) {
            TimeOfDayAnnotation etod = this.buildExpiryTimeOfDay();
            etod.initialize(astRoot);
            this.setExpiryTimeOfDay(etod);
        } else {
            this.getExpiryTimeOfDay().update(astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.type);
    }

    @Override
    public CacheType getType() {
        return this.type;
    }

    @Override
    public void setType(CacheType type) {
        if (this.attributeValueHasNotChanged((Object)this.type, (Object)type)) {
            return;
        }
        CacheType old = this.type;
        this.type = type;
        this.typeAdapter.setValue((Object)CacheType.toJavaAnnotationValue(type));
        this.firePropertyChanged("type", (Object)old, (Object)type);
    }

    private CacheType buildType(CompilationUnit astRoot) {
        return CacheType.fromJavaAnnotationValue(this.typeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TYPE_ADAPTER, astRoot);
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public void setSize(Integer size) {
        if (this.attributeValueHasNotChanged(this.size, size)) {
            return;
        }
        Integer old = this.size;
        this.size = size;
        this.sizeAdapter.setValue((Object)size);
        this.firePropertyChanged("size", old, size);
    }

    private Integer buildSize(CompilationUnit astRoot) {
        return (Integer)this.sizeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SIZE_ADAPTER, astRoot);
    }

    @Override
    public Boolean getShared() {
        return this.shared;
    }

    @Override
    public void setShared(Boolean shared) {
        if (this.attributeValueHasNotChanged(this.shared, shared)) {
            return;
        }
        Boolean old = this.shared;
        this.shared = shared;
        this.sharedAdapter.setValue((Object)shared);
        this.firePropertyChanged("shared", old, shared);
    }

    private Boolean buildShared(CompilationUnit astRoot) {
        return (Boolean)this.sharedAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSharedTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SHARED_ADAPTER, astRoot);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer expiry) {
        if (this.attributeValueHasNotChanged(this.expiry, expiry)) {
            return;
        }
        Integer old = this.expiry;
        this.expiry = expiry;
        this.expiryAdapter.setValue((Object)expiry);
        this.firePropertyChanged("expiry", old, expiry);
    }

    private Integer buildExpiry(CompilationUnit astRoot) {
        return (Integer)this.expiryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getExpiryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(EXPIRY_ADAPTER, astRoot);
    }

    @Override
    public TimeOfDayAnnotation getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public TimeOfDayAnnotation addExpiryTimeOfDay() {
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("'expiryTimeOfDay' element already exists");
        }
        this.expiryTimeOfDay = this.buildExpiryTimeOfDay();
        this.expiryTimeOfDayAdapter.newMarkerAnnotation();
        this.firePropertyChanged("expiryTimeOfDay", null, this.expiryTimeOfDay);
        return this.expiryTimeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("No expiryTimeOfDay element exists");
        }
        this.expiryTimeOfDay = null;
        this.expiryTimeOfDayAdapter.removeAnnotation();
        this.firePropertyChanged("expiryTimeOfDay", this.expiryTimeOfDay, null);
    }

    private void setExpiryTimeOfDay(TimeOfDayAnnotation expiryTimeOfDay) {
        TimeOfDayAnnotation old = this.expiryTimeOfDay;
        this.expiryTimeOfDay = expiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", old, expiryTimeOfDay);
    }

    private TimeOfDayAnnotation buildExpiryTimeOfDay() {
        return new SourceTimeOfDayAnnotation((JavaResourceNode)this, (Type)this.member, (DeclarationAnnotationAdapter)EXPIRY_TIME_OF_DAY_ADAPTER);
    }

    @Override
    public TextRange getExpiryTimeOfDayTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public Boolean getAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    @Override
    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        if (this.attributeValueHasNotChanged(this.alwaysRefresh, alwaysRefresh)) {
            return;
        }
        Boolean old = this.alwaysRefresh;
        this.alwaysRefresh = alwaysRefresh;
        this.alwaysRefreshAdapter.setValue((Object)alwaysRefresh);
        this.firePropertyChanged("alwaysRefresh", old, alwaysRefresh);
    }

    private Boolean buildAlwaysRefresh(CompilationUnit astRoot) {
        return (Boolean)this.alwaysRefreshAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getAlwaysRefreshTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ALWAYS_REFRESH_ADAPTER, astRoot);
    }

    @Override
    public Boolean getRefreshOnlyIfNewer() {
        return this.refreshOnlyIfNewer;
    }

    @Override
    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        if (this.attributeValueHasNotChanged(this.refreshOnlyIfNewer, refreshOnlyIfNewer)) {
            return;
        }
        Boolean old = this.refreshOnlyIfNewer;
        this.refreshOnlyIfNewer = refreshOnlyIfNewer;
        this.refreshOnlyIfNewerAdapter.setValue((Object)refreshOnlyIfNewer);
        this.firePropertyChanged("refreshOnlyIfNewer", old, refreshOnlyIfNewer);
    }

    private Boolean buildRefreshOnlyIfNewer(CompilationUnit astRoot) {
        return (Boolean)this.refreshOnlyIfNewerAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getRefreshOnlyIfNewerTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(REFRESH_ONLY_IF_NEWER_ADAPTER, astRoot);
    }

    @Override
    public Boolean getDisableHits() {
        return this.disableHits;
    }

    @Override
    public void setDisableHits(Boolean disableHits) {
        if (this.attributeValueHasNotChanged(this.disableHits, disableHits)) {
            return;
        }
        Boolean old = this.disableHits;
        this.disableHits = disableHits;
        this.disableHitsAdapter.setValue((Object)disableHits);
        this.firePropertyChanged("disableHits", old, disableHits);
    }

    private Boolean buildDisableHits(CompilationUnit astRoot) {
        return (Boolean)this.disableHitsAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDisablesHitsTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DISABLE_HITS_ADAPTER, astRoot);
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.coordinationType;
    }

    @Override
    public void setCoordinationType(CacheCoordinationType coordinationType) {
        if (this.attributeValueHasNotChanged((Object)this.coordinationType, (Object)coordinationType)) {
            return;
        }
        CacheCoordinationType old = this.coordinationType;
        this.coordinationType = coordinationType;
        this.coordinationTypeAdapter.setValue((Object)CacheCoordinationType.toJavaAnnotationValue(coordinationType));
        this.firePropertyChanged("type", (Object)old, (Object)coordinationType);
    }

    private CacheCoordinationType buildCoordinationType(CompilationUnit astRoot) {
        return CacheCoordinationType.fromJavaAnnotationValue(this.coordinationTypeAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getCoordinationTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(COORDINATION_TYPE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "type");
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSizeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "size", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildSharedAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "shared", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildExpiryAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiry", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildAlwaysRefreshAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "alwaysRefresh", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildRefreshOnlyIfNewerAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "refreshOnlyIfNewer", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildDisableHitsAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "disableHits", BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildCoordinationTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "coordinationType");
    }

    private static NestedDeclarationAnnotationAdapter buildExpiryTimeOfDayAdapter() {
        return new NestedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, "expiryTimeOfDay", "org.eclipse.persistence.annotations.TimeOfDay");
    }
}

