/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.binary;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.binary.BinaryBaseTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.binary.BinaryConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryObjectTypeConverterAnnotation
extends BinaryBaseTypeConverterAnnotation
implements ObjectTypeConverterAnnotation {
    private String defaultObjectValue = this.buildDefaultObjectValue();
    private final Vector<ConversionValueAnnotation> conversionValues = this.buildConversionValues();

    public BinaryObjectTypeConverterAnnotation(JavaResourcePersistentMember parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultObjectValue_(this.buildDefaultObjectValue());
        this.updateConversionValues();
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getDataTypeElementName() {
        return "dataType";
    }

    @Override
    String getObjectTypeElementName() {
        return "objectType";
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String defaultObjectValue) {
        throw new UnsupportedOperationException();
    }

    private void setDefaultObjectValue_(String defaultObjectValue) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = defaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", old, defaultObjectValue);
    }

    private String buildDefaultObjectValue() {
        return (String)this.getJdtMemberValue("defaultObjectValue");
    }

    @Override
    public TextRange getDefaultObjectValueTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<ConversionValueAnnotation> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public ConversionValueAnnotation conversionValueAt(int index) {
        return this.conversionValues.get(index);
    }

    @Override
    public int indexOfConversionValue(ConversionValueAnnotation conversionValue) {
        return this.conversionValues.indexOf(conversionValue);
    }

    @Override
    public ConversionValueAnnotation addConversionValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeConversionValue(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<ConversionValueAnnotation> buildConversionValues() {
        Object[] jdtConversionValues = this.getJdtMemberValues("conversionValues");
        Vector<ConversionValueAnnotation> result = new Vector<ConversionValueAnnotation>(jdtConversionValues.length);
        Object[] objectArray = jdtConversionValues;
        int n = jdtConversionValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtConversionValue = objectArray[n2];
            result.add(new BinaryConversionValueAnnotation((JavaResourceNode)this, (IAnnotation)jdtConversionValue));
            ++n2;
        }
        return result;
    }

    private void updateConversionValues() {
        throw new UnsupportedOperationException();
    }
}

