/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.BatchWriting;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConnection
extends EclipseLinkPersistenceUnitProperties
implements Connection {
    private BatchWriting batchWriting;
    private Boolean nativeSql;
    private Boolean cacheStatements;
    private Integer cacheStatementsSize;
    private String driver;
    private String url;
    private String user;
    private String password;
    private Boolean bindParameters;
    private Boolean readConnectionsShared;
    private Integer readConnectionsMin;
    private Integer readConnectionsMax;
    private Integer writeConnectionsMin;
    private Integer writeConnectionsMax;

    public EclipseLinkConnection(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.batchWriting = (BatchWriting)this.getEnumValue("eclipselink.jdbc.batch-writing", BatchWriting.values());
        this.nativeSql = this.getBooleanValue("eclipselink.jdbc.native-sql");
        this.cacheStatements = this.getBooleanValue("eclipselink.jdbc.cache-statements");
        this.cacheStatementsSize = this.getIntegerValue("eclipselink.jdbc.cache-statements.size");
        this.driver = this.getStringValue("eclipselink.jdbc.driver");
        this.url = this.getStringValue("eclipselink.jdbc.url");
        this.user = this.getStringValue("eclipselink.jdbc.user");
        this.password = this.getStringValue("eclipselink.jdbc.password");
        this.bindParameters = this.getBooleanValue("eclipselink.jdbc.bind-parameters");
        this.readConnectionsShared = this.getBooleanValue("eclipselink.jdbc.read-connections.shared");
        this.readConnectionsMin = this.getIntegerValue("eclipselink.jdbc.read-connections.min");
        this.readConnectionsMax = this.getIntegerValue("eclipselink.jdbc.read-connections.max");
        this.writeConnectionsMin = this.getIntegerValue("eclipselink.jdbc.write-connections.min");
        this.writeConnectionsMax = this.getIntegerValue("eclipselink.jdbc.write-connections.max");
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.jdbc.native-sql")) {
            this.nativeSqlChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.batch-writing")) {
            this.batchWritingChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.cache-statements")) {
            this.cacheStatementsChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.driver")) {
            this.driverChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.url")) {
            this.urlChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.user")) {
            this.userChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.password")) {
            this.passwordChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.bind-parameters")) {
            this.bindParametersChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.shared")) {
            this.readConnectionsSharedChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.cache-statements.size")) {
            this.cacheStatementsSizeChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.min")) {
            this.readConnectionsMinChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.max")) {
            this.readConnectionsMaxChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.write-connections.min")) {
            this.writeConnectionsMinChanged(newValue);
        } else if (propertyName.equals("eclipselink.jdbc.write-connections.max")) {
            this.writeConnectionsMaxChanged(newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.jdbc.native-sql")) {
            this.nativeSqlChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.batch-writing")) {
            this.batchWritingChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.cache-statements")) {
            this.cacheStatementsChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.driver")) {
            this.driverChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.url")) {
            this.urlChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.user")) {
            this.userChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.password")) {
            this.passwordChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.bind-parameters")) {
            this.bindParametersChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.shared")) {
            this.readConnectionsSharedChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.cache-statements.size")) {
            this.cacheStatementsSizeChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.min")) {
            this.readConnectionsMinChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.read-connections.max")) {
            this.readConnectionsMaxChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.write-connections.min")) {
            this.writeConnectionsMinChanged(null);
        } else if (propertyName.equals("eclipselink.jdbc.write-connections.max")) {
            this.writeConnectionsMaxChanged(null);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.jdbc.native-sql", "nativeSql");
        propertyNames.put("eclipselink.jdbc.batch-writing", "batchWriting");
        propertyNames.put("eclipselink.jdbc.cache-statements", "cacheStatements");
        propertyNames.put("eclipselink.jdbc.cache-statements.size", "cacheStatementsSize");
        propertyNames.put("eclipselink.jdbc.driver", "driver");
        propertyNames.put("eclipselink.jdbc.url", "url");
        propertyNames.put("eclipselink.jdbc.user", "user");
        propertyNames.put("eclipselink.jdbc.password", "password");
        propertyNames.put("eclipselink.jdbc.bind-parameters", "bindParameters");
        propertyNames.put("eclipselink.jdbc.read-connections.shared", "readConnectionsShared");
        propertyNames.put("eclipselink.jdbc.read-connections.min", "readConnectionsMin");
        propertyNames.put("eclipselink.jdbc.read-connections.max", "readConnectionsMax");
        propertyNames.put("eclipselink.jdbc.write-connections.min", "writeConnectionsMin");
        propertyNames.put("eclipselink.jdbc.write-connections.max", "writeConnectionsMax");
    }

    @Override
    public Boolean getNativeSql() {
        return this.nativeSql;
    }

    @Override
    public void setNativeSql(Boolean newNativeSql) {
        Boolean old = this.nativeSql;
        this.nativeSql = newNativeSql;
        this.putProperty("nativeSql", newNativeSql);
        this.firePropertyChanged("nativeSql", old, newNativeSql);
    }

    private void nativeSqlChanged(String stringValue) {
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.nativeSql;
        this.nativeSql = newValue;
        this.firePropertyChanged("nativeSql", old, newValue);
    }

    @Override
    public Boolean getDefaultNativeSql() {
        return DEFAULT_NATIVE_SQL;
    }

    @Override
    public BatchWriting getBatchWriting() {
        return this.batchWriting;
    }

    @Override
    public void setBatchWriting(BatchWriting newBatchWriting) {
        BatchWriting old = this.batchWriting;
        this.batchWriting = newBatchWriting;
        this.putProperty("batchWriting", (Object)newBatchWriting);
        this.firePropertyChanged("batchWriting", (Object)old, (Object)newBatchWriting);
    }

    private void batchWritingChanged(String stringValue) {
        BatchWriting newValue = (BatchWriting)EclipseLinkConnection.getEnumValueOf((String)stringValue, (Enum[])BatchWriting.values());
        BatchWriting old = this.batchWriting;
        this.batchWriting = newValue;
        this.firePropertyChanged("batchWriting", (Object)old, (Object)newValue);
    }

    @Override
    public BatchWriting getDefaultBatchWriting() {
        return DEFAULT_BATCH_WRITING;
    }

    @Override
    public Boolean getCacheStatements() {
        return this.cacheStatements;
    }

    @Override
    public void setCacheStatements(Boolean newCacheStatements) {
        Boolean old = this.cacheStatements;
        this.cacheStatements = newCacheStatements;
        this.putProperty("cacheStatements", newCacheStatements);
        this.firePropertyChanged("cacheStatements", old, newCacheStatements);
    }

    private void cacheStatementsChanged(String stringValue) {
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.cacheStatements;
        this.cacheStatements = newValue;
        this.firePropertyChanged("cacheStatements", old, newValue);
    }

    @Override
    public Boolean getDefaultCacheStatements() {
        return DEFAULT_CACHE_STATEMENTS;
    }

    @Override
    public Integer getCacheStatementsSize() {
        return this.cacheStatementsSize;
    }

    @Override
    public void setCacheStatementsSize(Integer newCacheStatementsSize) {
        Integer old = this.cacheStatementsSize;
        this.cacheStatementsSize = newCacheStatementsSize;
        this.putProperty("cacheStatementsSize", newCacheStatementsSize);
        this.firePropertyChanged("cacheStatementsSize", old, newCacheStatementsSize);
    }

    private void cacheStatementsSizeChanged(String stringValue) {
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.cacheStatementsSize;
        this.cacheStatementsSize = newValue;
        this.firePropertyChanged("cacheStatementsSize", old, newValue);
    }

    @Override
    public Integer getDefaultCacheStatementsSize() {
        return DEFAULT_CACHE_STATEMENTS_SIZE;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(String newDriver) {
        String old = this.driver;
        this.driver = newDriver;
        this.putProperty("driver", newDriver);
        this.firePropertyChanged("driver", old, newDriver);
    }

    private void driverChanged(String newValue) {
        String old = this.driver;
        this.driver = newValue;
        this.firePropertyChanged("driver", old, newValue);
    }

    @Override
    public String getDefaultDriver() {
        return "";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        String old = this.url;
        this.url = newUrl;
        this.putProperty("url", newUrl);
        this.firePropertyChanged("url", old, newUrl);
    }

    private void urlChanged(String newValue) {
        String old = this.url;
        this.url = newValue;
        this.firePropertyChanged("url", old, newValue);
    }

    @Override
    public String getDefaultUrl() {
        return "";
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String newUser) {
        String old = this.user;
        this.user = newUser;
        this.putProperty("user", newUser);
        this.firePropertyChanged("user", old, newUser);
    }

    private void userChanged(String newValue) {
        String old = this.user;
        this.user = newValue;
        this.firePropertyChanged("user", old, newValue);
    }

    @Override
    public String getDefaultUser() {
        return "";
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        String old = this.password;
        this.password = newPassword;
        this.putProperty("password", newPassword);
        this.firePropertyChanged("password", old, newPassword);
    }

    private void passwordChanged(String newValue) {
        String old = this.password;
        this.password = newValue;
        this.firePropertyChanged("password", old, newValue);
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public Boolean getBindParameters() {
        return this.bindParameters;
    }

    @Override
    public void setBindParameters(Boolean newBindParameters) {
        Boolean old = this.bindParameters;
        this.bindParameters = newBindParameters;
        this.putProperty("bindParameters", newBindParameters);
        this.firePropertyChanged("bindParameters", old, newBindParameters);
    }

    private void bindParametersChanged(String stringValue) {
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.bindParameters;
        this.bindParameters = newValue;
        this.firePropertyChanged("bindParameters", old, newValue);
    }

    @Override
    public Boolean getDefaultBindParameters() {
        return DEFAULT_BIND_PARAMETERS;
    }

    @Override
    public Boolean getReadConnectionsShared() {
        return this.readConnectionsShared;
    }

    @Override
    public void setReadConnectionsShared(Boolean newReadConnectionsShared) {
        Boolean old = this.readConnectionsShared;
        this.readConnectionsShared = newReadConnectionsShared;
        this.putProperty("readConnectionsShared", newReadConnectionsShared);
        this.firePropertyChanged("readConnectionsShared", old, newReadConnectionsShared);
    }

    private void readConnectionsSharedChanged(String stringValue) {
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.readConnectionsShared;
        this.readConnectionsShared = newValue;
        this.firePropertyChanged("readConnectionsShared", old, newValue);
    }

    @Override
    public Boolean getDefaultReadConnectionsShared() {
        return DEFAULT_READ_CONNECTIONS_SHARED;
    }

    @Override
    public Integer getReadConnectionsMin() {
        return this.readConnectionsMin;
    }

    @Override
    public void setReadConnectionsMin(Integer newReadConnectionsMin) {
        Integer old = this.readConnectionsMin;
        this.readConnectionsMin = newReadConnectionsMin;
        this.putProperty("readConnectionsMin", newReadConnectionsMin);
        this.firePropertyChanged("readConnectionsMin", old, newReadConnectionsMin);
    }

    private void readConnectionsMinChanged(String stringValue) {
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.readConnectionsMin;
        this.readConnectionsMin = newValue;
        this.firePropertyChanged("readConnectionsMin", old, newValue);
    }

    @Override
    public Integer getDefaultReadConnectionsMin() {
        return DEFAULT_READ_CONNECTIONS_MIN;
    }

    @Override
    public Integer getReadConnectionsMax() {
        return this.readConnectionsMax;
    }

    @Override
    public void setReadConnectionsMax(Integer newReadConnectionsMax) {
        Integer old = this.readConnectionsMax;
        this.readConnectionsMax = newReadConnectionsMax;
        this.putProperty("readConnectionsMax", newReadConnectionsMax);
        this.firePropertyChanged("readConnectionsMax", old, newReadConnectionsMax);
    }

    private void readConnectionsMaxChanged(String stringValue) {
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.readConnectionsMax;
        this.readConnectionsMax = newValue;
        this.firePropertyChanged("readConnectionsMax", old, newValue);
    }

    @Override
    public Integer getDefaultReadConnectionsMax() {
        return DEFAULT_READ_CONNECTIONS_MAX;
    }

    @Override
    public Integer getWriteConnectionsMin() {
        return this.writeConnectionsMin;
    }

    @Override
    public void setWriteConnectionsMin(Integer newWriteConnectionsMin) {
        Integer old = this.writeConnectionsMin;
        this.writeConnectionsMin = newWriteConnectionsMin;
        this.putProperty("writeConnectionsMin", newWriteConnectionsMin);
        this.firePropertyChanged("writeConnectionsMin", old, newWriteConnectionsMin);
    }

    private void writeConnectionsMinChanged(String stringValue) {
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.writeConnectionsMin;
        this.writeConnectionsMin = newValue;
        this.firePropertyChanged("writeConnectionsMin", old, newValue);
    }

    @Override
    public Integer getDefaultWriteConnectionsMin() {
        return DEFAULT_WRITE_CONNECTIONS_MIN;
    }

    @Override
    public Integer getWriteConnectionsMax() {
        return this.writeConnectionsMax;
    }

    @Override
    public void setWriteConnectionsMax(Integer newWriteConnectionsMax) {
        Integer old = this.writeConnectionsMax;
        this.writeConnectionsMax = newWriteConnectionsMax;
        this.putProperty("writeConnectionsMax", newWriteConnectionsMax);
        this.firePropertyChanged("writeConnectionsMax", old, newWriteConnectionsMax);
    }

    private void writeConnectionsMaxChanged(String stringValue) {
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.writeConnectionsMax;
        this.writeConnectionsMax = newValue;
        this.firePropertyChanged("writeConnectionsMax", old, newValue);
    }

    @Override
    public Integer getDefaultWriteConnectionsMax() {
        return DEFAULT_WRITE_CONNECTIONS_MAX;
    }
}

