/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.WriteTransformerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class WriteTransformerAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public WriteTransformerAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestWriteTransformer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.WriteTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@WriteTransformer");
            }
        });
    }

    private ICompilationUnit createTestWriteTransformerWithTransformerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.WriteTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@WriteTransformer(transformerClass = Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestWriteTransformerWithMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.WriteTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@WriteTransformer(method = \"transformerMethod\")");
            }
        });
    }

    private ICompilationUnit createTestWriteTransformerWithColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.WriteTransformer", "javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@WriteTransformer(column = @Column(name = \"FOO\"))");
            }
        });
    }

    public void testWriteTransformerAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer"));
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer"));
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer"));
    }

    public void testGetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"Foo", (String)writeTransformer.getTransformerClass());
    }

    public void testSetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"Foo", (String)writeTransformer.getTransformerClass());
        writeTransformer.setTransformerClass("Bar");
        WriteTransformerAnnotationTests.assertEquals((String)"Bar", (String)writeTransformer.getTransformerClass());
        this.assertSourceContains("@WriteTransformer(transformerClass = Bar.class)", cu);
    }

    public void testSetTransformerClassNull() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithTransformerClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"Foo", (String)writeTransformer.getTransformerClass());
        writeTransformer.setTransformerClass(null);
        WriteTransformerAnnotationTests.assertNull((Object)writeTransformer.getTransformerClass());
        this.assertSourceContains("@WriteTransformer", cu);
        this.assertSourceDoesNotContain("transformerClass", cu);
    }

    public void testGetMethod() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)writeTransformer.getMethod());
    }

    public void testSetMethod() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)writeTransformer.getMethod());
        writeTransformer.setMethod("foo");
        WriteTransformerAnnotationTests.assertEquals((String)"foo", (String)writeTransformer.getMethod());
        this.assertSourceContains("@WriteTransformer(method = \"foo\")", cu);
    }

    public void testSetMethodNull() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)writeTransformer.getMethod());
        writeTransformer.setMethod(null);
        WriteTransformerAnnotationTests.assertNull((Object)writeTransformer.getMethod());
        this.assertSourceContains("@WriteTransformer", cu);
        this.assertSourceDoesNotContain("method", cu);
    }

    public void testGetColumn() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertNotNull((Object)writeTransformer.getColumn());
        WriteTransformerAnnotationTests.assertEquals((String)"FOO", (String)writeTransformer.getColumn().getName());
    }

    public void testAddColumn() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithMethod();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertNull((Object)writeTransformer.getColumn());
        writeTransformer.addColumn();
        WriteTransformerAnnotationTests.assertNotNull((Object)writeTransformer.getColumn());
        this.assertSourceContains("@WriteTransformer(method = \"transformerMethod\", column = @Column)", cu);
        writeTransformer.getColumn().setName("BAR");
        this.assertSourceContains("@WriteTransformer(method = \"transformerMethod\", column = @Column(name = \"BAR\"))", cu);
    }

    public void testRemoveColumn() throws Exception {
        ICompilationUnit cu = this.createTestWriteTransformerWithColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        WriteTransformerAnnotation writeTransformer = (WriteTransformerAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.WriteTransformer");
        WriteTransformerAnnotationTests.assertNotNull((Object)writeTransformer.getColumn());
        WriteTransformerAnnotationTests.assertEquals((String)"FOO", (String)writeTransformer.getColumn().getName());
        writeTransformer.removeColumn();
        WriteTransformerAnnotationTests.assertNull((Object)writeTransformer.getColumn());
        this.assertSourceContains("@WriteTransformer", cu);
        this.assertSourceDoesNotContain("column", cu);
    }

    public void getNonNullColumn() throws Exception {
    }
}

