/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmStructConverterTests
extends EclipseLinkOrmContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @StructConverter");
            }
        });
    }

    public EclipseLinkOrmStructConverterTests(String name) {
        super(name);
    }

    public void testUpdateConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("structConverter");
        StructConverter ormConverter = (StructConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        converterResource.setConverter("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getConverter());
        converterResource.setConverter(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (StructConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        StructConverter javaConverter = (StructConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setConverterClass("bar");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
    }

    public void testModifyConverter() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("structConverter");
        StructConverter ormConverter = (StructConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        ormConverter.setConverterClass("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getConverter());
        ormConverter.setConverterClass(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("structConverter");
        EclipseLinkOrmStructConverter ormConverter = (EclipseLinkOrmStructConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (EclipseLinkOrmStructConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        StructConverter javaConverter = (StructConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("structConverter");
        EclipseLinkOrmStructConverter ormConverter = (EclipseLinkOrmStructConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

