/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.context.java.EclipseLinkJavaEmbeddable;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.ConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmEmbeddable;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmEmbeddableTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmEmbeddableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEmbeddableForCustomizer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForCustomConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForObjectTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForStructConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    public void testUpdateCustomizerClass() throws Exception {
        this.createTestEmbeddableForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkJavaEmbeddable javaContextEmbeddable = (EclipseLinkJavaEmbeddable)ormPersistentType.getJavaPersistentType().getMapping();
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.setCustomizer(EclipseLinkOrmFactory.eINSTANCE.createXmlCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.getCustomizer().setCustomizerClassName("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.getCustomizer().setCustomizerClassName(null);
        javaContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass("bar");
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.setSpecifiedMetadataComplete(null);
        resourceEmbeddable.getCustomizer().setCustomizerClassName("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        javaContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass(null);
        resourceEmbeddable.setCustomizer(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testModifyCustomizerClass() throws Exception {
        this.createTestEmbeddableForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getCustomizerClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testUpdateChangeTracking() throws Exception {
        this.createTestEmbeddableForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkJavaEmbeddable javaContextEmbeddable = (EclipseLinkJavaEmbeddable)ormPersistentType.getJavaPersistentType().getMapping();
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.DEFERRED);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.AUTO);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.setChangeTracking(null);
        javaContextEmbeddable.getChangeTracking().setSpecifiedType(ChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.setSpecifiedMetadataComplete(null);
        resourceEmbeddable.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
    }

    public void testModifyChangeTracking() throws Exception {
        this.createTestEmbeddableForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(ChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(ChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(ChangeTrackingType.DEFERRED);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(ChangeTrackingType.AUTO);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
    }

    public void testUpdateCustomConverters() throws Exception {
        this.createTestEmbeddableForCustomConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverterImpl resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        resourceEmbeddable.getConverters().add((Object)resourceConverter);
        resourceConverter.setClassName("Foo");
        resourceConverter.setName("myConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        CustomConverter ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverterImpl resourceConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        resourceEmbeddable.getConverters().add(0, (Object)resourceConverter2);
        resourceConverter2.setClassName("Foo2");
        resourceConverter2.setName("myConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getConverters().remove((Object)resourceConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyCustomConverters() throws Exception {
        this.createTestEmbeddableForCustomConverters();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        CustomConverter contextConverter = ormContextConverterHolder.addCustomConverter(0);
        contextConverter.setConverterClass("Foo");
        contextConverter.setName("myConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        CustomConverter ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        CustomConverter contextConverter2 = ormContextConverterHolder.addCustomConverter(0);
        contextConverter2.setConverterClass("Foo2");
        contextConverter2.setName("myConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverterHolder.moveCustomConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverterHolder.removeCustomConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (CustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverterHolder.removeCustomConverter(contextConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
    }

    public void testUpdateTypeConverters() throws Exception {
        this.createTestEmbeddableForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverterImpl resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        resourceEmbeddable.getTypeConverters().add((Object)resourceTypeConverter);
        resourceTypeConverter.setDataType("Foo");
        resourceTypeConverter.setName("myTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        TypeConverter ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverterImpl resourceTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        resourceEmbeddable.getTypeConverters().add(0, (Object)resourceTypeConverter2);
        resourceTypeConverter2.setDataType("Foo2");
        resourceTypeConverter2.setName("myTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getTypeConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getTypeConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getTypeConverters().remove((Object)resourceTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyTypeConverters() throws Exception {
        this.createTestEmbeddableForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        TypeConverter contextTypeConverter = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter.setDataType("Foo");
        contextTypeConverter.setName("myTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        TypeConverter ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        TypeConverter contextTypeConverter2 = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter2.setDataType("Foo2");
        contextTypeConverter2.setName("myTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveTypeConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (TypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(contextTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateObjectTypeConverters() throws Exception {
        this.createTestEmbeddableForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverterImpl resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        resourceEmbeddable.getObjectTypeConverters().add((Object)resourceObjectTypeConverter);
        resourceObjectTypeConverter.setDataType("Foo");
        resourceObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ObjectTypeConverter ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverterImpl resourceObjectTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        resourceEmbeddable.getObjectTypeConverters().add(0, (Object)resourceObjectTypeConverter2);
        resourceObjectTypeConverter2.setDataType("Foo2");
        resourceObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getObjectTypeConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getObjectTypeConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getObjectTypeConverters().remove((Object)resourceObjectTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyObjectTypeConverters() throws Exception {
        this.createTestEmbeddableForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ObjectTypeConverter contextObjectTypeConverter = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter.setDataType("Foo");
        contextObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ObjectTypeConverter ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ObjectTypeConverter contextObjectTypeConverter2 = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter2.setDataType("Foo2");
        contextObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveObjectTypeConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (ObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(contextObjectTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateStructConverters() throws Exception {
        this.createTestEmbeddableForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverterImpl resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        resourceEmbeddable.getStructConverters().add((Object)resourceStructConverter);
        resourceStructConverter.setConverter("Foo");
        resourceStructConverter.setName("myStructConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        StructConverter ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverterImpl resourceStructConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        resourceEmbeddable.getStructConverters().add(0, (Object)resourceStructConverter2);
        resourceStructConverter2.setConverter("Foo2");
        resourceStructConverter2.setName("myStructConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getStructConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getStructConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEmbeddable.getStructConverters().remove((Object)resourceStructConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyStructConverters() throws Exception {
        this.createTestEmbeddableForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        ConverterHolder ormContextConverterHolder = ormContextEmbeddable.getConverterHolder();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        StructConverter contextStructConverter = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter.setConverterClass("Foo");
        contextStructConverter.setName("myStructConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        StructConverter ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        StructConverter contextStructConverter2 = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter2.setConverterClass("Foo2");
        contextStructConverter2.setName("myStructConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveStructConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (StructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(contextStructConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }
}

