/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceOneToOneAnnotation
extends SourceRelationshipMappingAnnotation
implements OneToOneAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToOne");
    static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceOneToOneAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceOneToOneAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceOneToOneAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceOneToOneAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private Boolean optional;
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceOneToOneAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;

    public SourceOneToOneAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.mappedBy = this.buildMappedBy(astRoot);
        this.optional = this.buildOptional(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setMappedBy(this.buildMappedBy(astRoot));
        this.setOptional(this.buildOptional(astRoot));
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (this.attributeValueHasNotChanged(this.mappedBy, mappedBy)) {
            return;
        }
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        this.mappedByAdapter.setValue(mappedBy);
        this.firePropertyChanged("mappedBy", old, mappedBy);
    }

    private String buildMappedBy(CompilationUnit astRoot) {
        return this.mappedByAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astRoot);
    }

    @Override
    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(MAPPED_BY_ADAPTER, pos, astRoot);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasNotChanged(this.optional, optional)) {
            return;
        }
        Boolean old = this.optional;
        this.optional = optional;
        this.optionalAdapter.setValue(optional);
        this.firePropertyChanged("optional", old, optional);
    }

    private Boolean buildOptional(CompilationUnit astRoot) {
        return this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceOneToOneAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "mappedBy", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceOneToOneAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return SourceOneToOneAnnotation.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, elementName, false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceOneToOneAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }
}

