/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.core.resource.java.CascadeType;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;

abstract class BinaryRelationshipMappingAnnotation
extends BinaryAnnotation
implements RelationshipMappingAnnotation {
    String targetEntity = this.buildTargetEntity();
    FetchType fetch = this.buildFetch();
    boolean cascadeAll;
    boolean cascadeMerge;
    boolean cascadePersist;
    boolean cascadeRefresh;
    boolean cascadeRemove;

    BinaryRelationshipMappingAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
        CascadeType[] cascadeTypes = this.buildCascadeTypes();
        this.cascadeAll = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL));
        this.cascadeMerge = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE));
        this.cascadePersist = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST));
        this.cascadeRefresh = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH));
        this.cascadeRemove = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE));
    }

    public void update() {
        super.update();
        this.setTargetEntity_(this.buildTargetEntity());
        this.setFetch_(this.buildFetch());
        CascadeType[] cascadeTypes = this.buildCascadeTypes();
        this.setCascadeAll_(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL)));
        this.setCascadeMerge_(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE)));
        this.setCascadePersist_(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST)));
        this.setCascadeRefresh_(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH)));
        this.setCascadeRemove_(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE)));
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(String targetEntity) {
        throw new UnsupportedOperationException();
    }

    private void setTargetEntity_(String targetEntity) {
        String old = this.targetEntity;
        this.targetEntity = targetEntity;
        this.firePropertyChanged("targetEntity", old, targetEntity);
        this.firePropertyChanged("fullyQualifiedTargetEntityClassName", old, targetEntity);
    }

    private String buildTargetEntity() {
        return (String)this.getJdtMemberValue(this.getTargetEntityElementName());
    }

    abstract String getTargetEntityElementName();

    public TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    public String getFullyQualifiedTargetEntityClassName() {
        return this.targetEntity;
    }

    public FetchType getFetch() {
        return this.fetch;
    }

    public void setFetch(FetchType fetch) {
        throw new UnsupportedOperationException();
    }

    private void setFetch_(FetchType fetch) {
        FetchType old = this.fetch;
        this.fetch = fetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)fetch);
    }

    private FetchType buildFetch() {
        return FetchType.fromJavaAnnotationValue(this.getJdtMemberValue(this.getFetchElementName()));
    }

    abstract String getFetchElementName();

    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    private CascadeType[] buildCascadeTypes() {
        return CascadeType.fromJavaAnnotationValues(this.getJdtMemberValues(this.getCascadeElementName()));
    }

    abstract String getCascadeElementName();

    public TextRange getCascadeTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    public boolean isCascadeAll() {
        return this.cascadeAll;
    }

    public void setCascadeAll(boolean cascadeAll) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeAll_(boolean cascadeAll) {
        boolean old = this.cascadeAll;
        this.cascadeAll = cascadeAll;
        this.firePropertyChanged("cascadeAll", old, cascadeAll);
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public void setCascadeMerge(boolean cascadeMerge) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeMerge_(boolean cascadeMerge) {
        boolean old = this.cascadeMerge;
        this.cascadeMerge = cascadeMerge;
        this.firePropertyChanged("cascadeMerge", old, cascadeMerge);
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public void setCascadePersist(boolean cascadePersist) {
        throw new UnsupportedOperationException();
    }

    private void setCascadePersist_(boolean cascadePersist) {
        boolean old = this.cascadePersist;
        this.cascadePersist = cascadePersist;
        this.firePropertyChanged("cascadePersist", old, cascadePersist);
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public void setCascadeRefresh(boolean cascadeRefresh) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeRefresh_(boolean cascadeRefresh) {
        boolean old = this.cascadeRefresh;
        this.cascadeRefresh = cascadeRefresh;
        this.firePropertyChanged("cascadeRefresh", old, cascadeRefresh);
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    public void setCascadeRemove(boolean cascadeRemove) {
        throw new UnsupportedOperationException();
    }

    private void setCascadeRemove_(boolean cascadeRemove) {
        boolean old = this.cascadeRemove;
        this.cascadeRemove = cascadeRemove;
        this.firePropertyChanged("cascadeRemove", old, cascadeRemove);
    }
}

