/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassRef
extends AbstractXmlContextNode
implements ClassRef {
    protected XmlJavaClassRef xmlJavaClassRef;
    protected String className;
    protected JavaPersistentType javaPersistentType;

    public GenericClassRef(PersistenceUnit parent, XmlJavaClassRef classRef) {
        this(parent, classRef, classRef.getJavaClass());
    }

    public GenericClassRef(PersistenceUnit parent, String className) {
        this(parent, null, className);
    }

    protected GenericClassRef(PersistenceUnit parent, XmlJavaClassRef classRef, String className) {
        super(parent);
        this.initialize(classRef, className);
    }

    protected void initialize(XmlJavaClassRef classRef, String typeName) {
        this.xmlJavaClassRef = classRef;
        this.className = typeName;
        this.javaPersistentType = this.buildJavaPersistentType();
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.classRef";
    }

    @Override
    public IContentType getContentType() {
        return this.getParent().getContentType();
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public boolean isFor(String typeName) {
        return this.className != null && this.className.equals(typeName);
    }

    @Override
    public boolean isVirtual() {
        return this.xmlJavaClassRef == null;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.isNotVirtual() && this.xmlJavaClassRef.containsOffset(textOffset);
    }

    protected boolean isNotVirtual() {
        return !this.isVirtual();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        String old = this.className;
        this.className = className;
        this.xmlJavaClassRef.setJavaClass(className);
        this.firePropertyChanged("className", old, className);
    }

    protected void setClassName_(String newClassName) {
        String old = this.className;
        this.className = newClassName;
        this.firePropertyChanged("className", old, newClassName);
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected JavaPersistentType buildJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        return jrpt == null ? null : this.buildJavaPersistentType(jrpt);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        if (jrpt == null) {
            if (this.javaPersistentType != null) {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(null);
            }
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        } else {
            this.javaPersistentType.update(jrpt);
        }
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        return this.className == null ? null : this.getJpaProject().getJavaResourcePersistentType(this.className.replace('$', '.'));
    }

    @Override
    public void update(XmlJavaClassRef classRef) {
        this.update(classRef, classRef.getJavaClass());
    }

    @Override
    public void update(String typeName) {
        this.update(null, typeName);
    }

    protected void update(XmlJavaClassRef classRef, String typeName) {
        this.xmlJavaClassRef = classRef;
        this.setClassName_(typeName);
        this.updateJavaPersistentType();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.javaPersistentType != null) {
            this.javaPersistentType.postUpdate();
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.className)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS", this, this.getValidationTextRange()));
            return;
        }
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_CLASS", new String[]{this.className}, this, this.getValidationTextRange()));
            return;
        }
        boolean validateJavaPersistentType = true;
        Iterator<MappingFileRef> stream = this.getPersistenceUnit().mappingFileRefsContaining(this.className);
        while (stream.hasNext()) {
            validateJavaPersistentType = false;
            MappingFileRef mappingFileRef = stream.next();
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "PERSISTENCE_UNIT_REDUNDANT_CLASS", new String[]{this.className, mappingFileRef.getFileName()}, this, this.getValidationTextRange()));
        }
        if (validateJavaPersistentType) {
            this.validateJavaPersistentType(messages, reporter);
        }
    }

    protected void validateJavaPersistentType(List<IMessage> messages, IReporter reporter) {
        try {
            this.javaPersistentType.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.className);
    }
}

