/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlMultiRelationshipMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmMultiRelationshipMapping<T extends XmlMultiRelationshipMapping>
extends AbstractOrmRelationshipMapping<T>
implements OrmMultiRelationshipMapping {
    protected String mapKey = this.getResourceMapKeyName();
    protected String orderBy = this.getResourceOrderBy();
    protected boolean isNoOrdering;
    protected boolean isPkOrdering;
    protected boolean isCustomOrdering;

    protected AbstractOrmMultiRelationshipMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        if (this.orderBy == null) {
            this.isNoOrdering = true;
        } else {
            this.isCustomOrdering = true;
        }
    }

    @Override
    public FetchType getDefaultFetch() {
        return MultiRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (oldMapKey != newMapKey) {
            if (this.getResourceMapKey() != null) {
                this.getResourceMapKey().setName(newMapKey);
                if (this.getResourceMapKey().isUnset()) {
                    this.removeResourceMapKey();
                }
            } else if (newMapKey != null) {
                this.addResourceMapKey();
                this.getResourceMapKey().setName(newMapKey);
            }
        }
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    protected void setMapKey_(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        this.firePropertyChanged("mapKey", oldMapKey, newMapKey);
    }

    protected MapKey getResourceMapKey() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey();
    }

    protected void removeResourceMapKey() {
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setMapKey(null);
    }

    protected void addResourceMapKey() {
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setMapKey(OrmFactory.eINSTANCE.createMapKeyImpl());
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy(newOrderBy);
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    protected void setOrderBy_(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        this.firePropertyChanged("orderBy", oldOrderBy, newOrderBy);
    }

    @Override
    public boolean isNoOrdering() {
        return this.isNoOrdering;
    }

    @Override
    public void setNoOrdering(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        if (newNoOrdering) {
            ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy(null);
        }
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    protected void setNoOrdering_(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        this.firePropertyChanged("noOrdering", oldNoOrdering, newNoOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.isPkOrdering;
    }

    @Override
    public void setPkOrdering(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        if (newPkOrdering) {
            ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).setOrderBy("");
        }
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    protected void setPkOrdering_(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        this.firePropertyChanged("pkOrdering", oldPkOrdering, newPkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.isCustomOrdering;
    }

    @Override
    public void setCustomOrdering(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        if (newCustomOrdering) {
            this.setOrderBy("");
        }
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    protected void setCustomOrdering_(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        this.firePropertyChanged("customOrdering", oldCustomOrdering, newCustomOrdering);
    }

    @Override
    public void update() {
        super.update();
        this.setMapKey_(this.getResourceMapKeyName());
        this.setOrderBy_(this.getResourceOrderBy());
        if (this.getOrderBy() == null) {
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
        } else {
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
        }
    }

    protected String getResourceMapKeyName() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey() == null ? null : ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getMapKey().getName();
    }

    protected String getResourceOrderBy() {
        return ((XmlMultiRelationshipMapping)this.resourceAttributeMapping).getOrderBy();
    }

    @Override
    protected String getResourceDefaultTargetEntity() {
        return this.getJavaPersistentAttribute().getMultiReferenceEntityTypeName();
    }
}

