/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumnJoiningStrategy
extends AbstractJavaJpaContextNode
implements JavaPrimaryKeyJoinColumnJoiningStrategy {
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;
    protected final List<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();

    public GenericJavaPrimaryKeyJoinColumnJoiningStrategy(JavaPrimaryKeyJoinColumnEnabledRelationshipReference parent) {
        super(parent);
    }

    @Override
    public JavaPrimaryKeyJoinColumnEnabledRelationshipReference getParent() {
        return (JavaPrimaryKeyJoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JavaPrimaryKeyJoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public JavaRelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public JavaPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        this.primaryKeyJoinColumns.add(index, pkJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnAnnotation = this.addAnnotation(index);
        pkJoinColumn.initialize(pkJoinColumnAnnotation);
        this.fireItemAdded("primaryKeyJoinColumns", index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumns");
    }

    protected void addPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn joinColumn) {
        this.addPrimaryKeyJoinColumn(this.primaryKeyJoinColumns.size(), joinColumn);
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        this.removeAnnotation(index);
        this.fireItemRemoved("primaryKeyJoinColumns", index, pkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumns");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.moveAnnotation(targetIndex, sourceIndex);
        this.fireItemMoved("primaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    protected PrimaryKeyJoinColumnAnnotation addAnnotation(int index) {
        return (PrimaryKeyJoinColumnAnnotation)this.resourcePersistentAttribute.addSupportingAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
    }

    protected void removeAnnotation(int index) {
        this.resourcePersistentAttribute.removeSupportingAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
    }

    protected void moveAnnotation(int targetIndex, int sourceIndex) {
        this.resourcePersistentAttribute.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
    }

    @Override
    public void addStrategy() {
        if (this.primaryKeyJoinColumnsSize() == 0) {
            this.addPrimaryKeyJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (PrimaryKeyJoinColumn each : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            this.removePrimaryKeyJoinColumn(each);
        }
    }

    @Override
    public void initialize() {
        this.resourcePersistentAttribute = this.getRelationshipReference().getRelationshipMapping().getPersistentAttribute().getResourcePersistentAttribute();
        this.initializePrimaryKeyJoinColumns();
    }

    protected void initializePrimaryKeyJoinColumns() {
        ListIterator<NestableAnnotation> annotations = this.resourcePersistentAttribute.supportingAnnotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (annotations.hasNext()) {
            this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)annotations.next())));
        }
    }

    @Override
    public void update() {
        this.resourcePersistentAttribute = this.getRelationshipReference().getRelationshipMapping().getPersistentAttribute().getResourcePersistentAttribute();
        this.updatePrimaryKeyJoinColumns();
    }

    protected void updatePrimaryKeyJoinColumns() {
        ListIterator<JavaPrimaryKeyJoinColumn> joinColumns = this.primaryKeyJoinColumns();
        ListIterator<NestableAnnotation> annotations = this.resourcePersistentAttribute.supportingAnnotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (joinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn joinColumn = joinColumns.next();
            if (annotations.hasNext()) {
                joinColumn.update((PrimaryKeyJoinColumnAnnotation)((Object)annotations.next()));
                continue;
            }
            this.removePrimaryKeyJoinColumn_(joinColumn);
        }
        while (annotations.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)annotations.next())));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation annotation) {
        JavaPrimaryKeyJoinColumn joinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initialize(annotation);
        return joinColumn;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaPrimaryKeyJoinColumn column : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getRelationshipReference().getValidationTextRange(astRoot);
    }

    public class JoinColumnOwner
    implements JavaJoinColumn.Owner {
        public String getDefaultTableName() {
            return this.getRelationshipMapping().getTypeMapping().getPrimaryTableName();
        }

        public Entity getTargetEntity() {
            return this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return this.getRelationshipMapping().getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericJavaPrimaryKeyJoinColumnJoiningStrategy.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return false;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaPrimaryKeyJoinColumnJoiningStrategy.this.getValidationTextRange(astRoot);
        }

        public int joinColumnsSize() {
            return GenericJavaPrimaryKeyJoinColumnJoiningStrategy.this.primaryKeyJoinColumnsSize();
        }
    }
}

