/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaValidation;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.CallbackChangeSupport;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaNode
extends AbstractModel
implements JpaNode {
    private final JpaNode parent;
    private static final HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> nonUpdateAspectNameSets = new HashMap();

    protected AbstractJpaNode(JpaNode parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    protected void checkParent(JpaNode p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected ChangeSupport buildChangeSupport() {
        return new CallbackChangeSupport((Model)this, this.buildChangeSupportListener());
    }

    protected CallbackChangeSupport.Listener buildChangeSupportListener() {
        return new CallbackChangeSupport.Listener(){

            public void aspectChanged(String aspectName) {
                AbstractJpaNode.this.aspectChanged(aspectName);
            }
        };
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public JpaNode getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.parent.getJpaProject();
    }

    protected JpaPlatform getJpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    protected JpaFactory getJpaFactory() {
        return this.getJpaPlatform().getJpaFactory();
    }

    protected JpaValidation getJpaValidation() {
        return this.getJpaPlatform().getJpaValidation();
    }

    protected JpaFile getJpaFile(IFile file) {
        return this.getJpaProject().getJpaFile(file);
    }

    protected JpaDataSource getDataSource() {
        return this.getJpaProject().getDataSource();
    }

    protected Database getDatabase() {
        return this.getDataSource().getDatabase();
    }

    protected boolean connectionProfileIsActive() {
        return this.getDataSource().connectionProfileIsActive();
    }

    protected Catalog getDbCatalog(String catalog) {
        Database database = this.getDatabase();
        return database == null ? null : database.getCatalogForIdentifier(catalog);
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectTriggersUpdate(aspectName)) {
            this.getJpaProject().update();
        }
    }

    private boolean aspectTriggersUpdate(String aspectName) {
        return !this.aspectDoesNotTriggerUpdate(aspectName);
    }

    private boolean aspectDoesNotTriggerUpdate(String aspectName) {
        return this.nonUpdateAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonUpdateAspectNames() {
        HashMap<Class<? extends AbstractJpaNode>, HashSet<String>> hashMap = nonUpdateAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> nonUpdateAspectNames = nonUpdateAspectNameSets.get(this.getClass());
            if (nonUpdateAspectNames == null) {
                nonUpdateAspectNames = new HashSet();
                this.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
                nonUpdateAspectNameSets.put(this.getClass(), nonUpdateAspectNames);
            }
            return nonUpdateAspectNames;
        }
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
    }
}

