/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.platform;

import java.util.Iterator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformExtensionTests
extends ContextModelTestCase {
    public static final String TEST_PLATFORM_ID = "core.testJpaPlatform";
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    protected TestJpaProject testProject;

    public JpaPlatformExtensionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return super.buildJpaProject("AnnotationTestProject", autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetDataModelProvider configFactory = new JpaFacetDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)TEST_PLATFORM_ID);
        return config;
    }

    public static void verifyExtensionTestProjectExists() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jpt.core", "jpaPlatform");
        IExtension[] extensions = extensionPoint.getExtensions();
        boolean extensionFound = false;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getContributor().getName().equals("org.eclipse.jpt.core.tests.extension.resource")) {
                extensionFound = true;
            }
            ++n2;
        }
        if (!extensionFound) {
            throw new RuntimeException("Missing Extension core.testJpaPlatform. The ExtensionTestProject plugin must be in your testing workspace.");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAllJpaPlatformIds() {
        JpaPlatformExtensionTests.assertTrue((CollectionTools.size((Iterator)JpaPlatformRegistry.instance().jpaPlatformIds()) >= 2 ? 1 : 0) != 0);
    }

    public void testJpaPlatformLabel() {
        JpaPlatformExtensionTests.assertEquals((String)TEST_PLATFORM_LABEL, (String)JpaPlatformRegistry.instance().getJpaPlatformLabel(TEST_PLATFORM_ID));
    }

    public void testJpaPlatform() {
        JpaPlatformExtensionTests.assertNotNull((Object)JpaPlatformRegistry.instance().getJpaPlatform(this.testProject.getProject()));
    }
}

