/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmManyToManyMappingTests
extends ContextModelTestCase {
    public OrmManyToManyMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)manyToMany.getName());
        manyToMany.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        manyToMany.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)manyToMany.getName());
        ormManyToManyMapping.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        ormManyToManyMapping.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormManyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormManyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        manyToMany.setMapKey((MapKey)OrmFactory.eINSTANCE.createMapKeyImpl());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNotNull((Object)manyToMany.getMapKey());
        manyToMany.getMapKey().setName("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName("myMapKey");
        manyToMany.setMapKey(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        ormManyToManyMapping.setMapKey("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        ormManyToManyMapping.setMapKey(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        manyToMany.setOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        manyToMany.setOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testModifyOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        ormManyToManyMapping.setOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        ormManyToManyMapping.setOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testIsNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isNoOrdering());
        ormManyToManyMapping.setOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isNoOrdering());
        ormManyToManyMapping.setOrderBy(null);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isNoOrdering());
    }

    public void testSetNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isNoOrdering());
        ormManyToManyMapping.setOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isNoOrdering());
        ormManyToManyMapping.setNoOrdering(true);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isNoOrdering());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderBy());
    }

    public void testIsCustomOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isCustomOrdering());
        ormManyToManyMapping.setOrderBy("foo");
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isCustomOrdering());
        ormManyToManyMapping.setOrderBy(null);
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isCustomOrdering());
    }

    public void testManyToManyMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToOneToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToOneToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        JoinTable joinTable = ((OneToManyMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        OrmManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmManyToManyMappingTests.assertEquals((String)"name", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"referenceName", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedReferencedColumnName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedReferencedColumnName());
    }

    public void testManyToManyMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.setOrderBy("customOrder");
        manyToManyMapping.setMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }
}

