/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.FindReadReferencesAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindReadReferencesInProjectAction
extends FindReadReferencesAction {
    public FindReadReferencesInProjectAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReadReferencesInProjectAction(JavaEditor editor) {
        super(editor);
    }

    void init() {
        this.setText(SearchMessages.Search_FindReadReferencesInProjectAction_label);
        this.setToolTipText(SearchMessages.Search_FindReadReferencesInProjectAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_read_references_in_project_action");
    }

    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException {
        String description;
        IJavaScriptSearchScope scope;
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        JavaEditor editor = this.getEditor();
        boolean isInsideJRE = factory.isInsideJRE(element);
        if (editor != null) {
            scope = factory.createJavaProjectSearchScope(editor.getEditorInput(), isInsideJRE);
            description = factory.getProjectScopeDescription(editor.getEditorInput(), isInsideJRE);
        } else {
            scope = factory.createJavaProjectSearchScope(element.getJavaScriptProject(), isInsideJRE);
            description = factory.getProjectScopeDescription(element.getJavaScriptProject(), isInsideJRE);
        }
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

