/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class ProblemTreeViewer
extends TreeViewer
implements ResourceToItemsMapper.IContentViewerAccessor {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTreeViewer(Composite parent) {
        super(parent);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    public void doUpdateItem(Widget item) {
        this.doUpdateItem(item, item.getData(), true);
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper(this);
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    public void addFilter(ViewerFilter filter) {
        if (filter instanceof JavaViewerFilter) {
            ((JavaViewerFilter)filter).filteringStart();
        }
        super.addFilter(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        super.removeFilter(filter);
        if (filter instanceof JavaViewerFilter) {
            ((JavaViewerFilter)filter).filteringEnd();
        }
    }

    public void setFilters(ViewerFilter[] filters) {
        ViewerFilter[] oldFilters = this.getFilters();
        int i = 0;
        while (i < filters.length) {
            ViewerFilter curr = filters[i];
            if (curr instanceof JavaViewerFilter && !this.findAndRemove(oldFilters, curr)) {
                ((JavaViewerFilter)curr).filteringStart();
            }
            ++i;
        }
        this.endFilterSessions(oldFilters);
        super.setFilters(filters);
    }

    public void resetFilters() {
        this.endFilterSessions(this.getFilters());
        super.resetFilters();
    }

    private boolean findAndRemove(ViewerFilter[] filters, ViewerFilter filter) {
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == filter) {
                filters[i] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void endFilterSessions(ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter curr = filters[i];
            if (curr instanceof JavaViewerFilter) {
                ((JavaViewerFilter)curr).filteringEnd();
            }
            ++i;
        }
    }

    protected void handleDispose(DisposeEvent event) {
        this.endFilterSessions(this.getFilters());
        super.handleDispose(event);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        Object[] changed = this.addAditionalProblemParents(event.getElements());
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        } else if (event.getElements() != changed) {
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), changed);
        }
        super.handleLabelProviderChanged(event);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        IContentProvider contentProvider = this.getContentProvider();
        return contentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)contentProvider).providesWorkingCopies();
    }

    protected boolean evaluateExpandableWithFilters(Object parent) {
        return parent instanceof IMember;
    }

    public boolean isExpandable(Object parent) {
        if (this.hasFilters() && this.evaluateExpandableWithFilters(parent)) {
            return this.hasFilteredChildren(parent);
        }
        return super.isExpandable(parent);
    }

    protected final boolean hasFilteredChildren(Object parent) {
        Object[] rawChildren = this.getRawChildren(parent);
        return this.containsNonFiltered(rawChildren, parent);
    }

    protected final Object[] getFilteredChildren(Object parent) {
        return this.filter(this.getRawChildren(parent), parent);
    }

    private Object[] filter(Object[] elements, Object parent) {
        if (!this.hasFilters() || elements.length == 0) {
            return elements;
        }
        ArrayList<Object> list = new ArrayList<Object>(elements.length);
        ViewerFilter[] filters = this.getFilters();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (!this.isFiltered(object, parent, filters)) {
                list.add(object);
            }
            ++i;
        }
        return list.toArray();
    }

    private boolean containsNonFiltered(Object[] elements, Object parent) {
        if (elements.length == 0) {
            return false;
        }
        if (!this.hasFilters()) {
            return true;
        }
        ViewerFilter[] filters = this.getFilters();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (!this.isFiltered(object, parent, filters)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (!filter.select((Viewer)this, parent, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final Object[] filter(Object[] elements) {
        return this.filter(elements, this.getRoot());
    }

    protected Object[] addAditionalProblemParents(Object[] elements) {
        return elements;
    }

    public boolean isFiltered(Object object, Object parent) {
        return this.isFiltered(object, parent, this.getFilters());
    }
}

