/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.DeleteAction_3);
        this.setDescription(ReorgMessages.DeleteAction_4);
        ISharedImages workbenchImages = JavaScriptPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.delete_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        try {
            this.setEnabled(RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray()));
        }
        catch (CoreException e) {
            if (JavaModelUtil.isExceptionToBeLogged(e)) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private IAction createWorkbenchAction(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            RefactoringExecutionStarter.startDeleteRefactoring(selection.toArray(), this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

