/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;

class SearchScopeHierarchyAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeHierarchyAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_hierarchy_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_hierarchy_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IJavaScriptSearchScope getSearchScope() {
        try {
            IFunction method = this.fGroup.getView().getMethod();
            if (method != null) {
                return SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
            }
            return null;
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
    }

    public int getSearchScopeType() {
        return 3;
    }

    public String getFullDescription() {
        IFunction method = this.fGroup.getView().getMethod();
        return JavaSearchScopeFactory.getInstance().getHierarchyScopeDescription(method.getDeclaringType());
    }
}

