/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public final class AddUnimplementedConstructorsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private String[] fCreatedImports;
    private final List fCreatedMethods = new ArrayList();
    private final boolean fImports;
    private final int fInsertPos;
    private final IFunctionBinding[] fConstructorsToImplement;
    private boolean fOmitSuper;
    private final boolean fSave;
    private boolean fCreateComments;
    private final ITypeBinding fType;
    private final JavaScriptUnit fASTRoot;
    private int fVisibility;

    public AddUnimplementedConstructorsOperation(JavaScriptUnit astRoot, ITypeBinding type, IFunctionBinding[] constructorsToImplement, int insertPos, boolean imports, boolean apply, boolean save) {
        if (astRoot == null || !(astRoot.getJavaElement() instanceof IJavaScriptUnit)) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a IJavaScriptUnit");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        ASTNode node = astRoot.findDeclaringNode((IBinding)type);
        if (!(node instanceof AnonymousClassDeclaration) && !(node instanceof AbstractTypeDeclaration)) {
            throw new IllegalArgumentException("type has to map to a type declaration in the AST");
        }
        this.fType = type;
        this.fInsertPos = insertPos;
        this.fASTRoot = astRoot;
        this.fConstructorsToImplement = constructorsToImplement;
        this.fSave = save;
        this.fApply = apply;
        this.fImports = imports;
        this.fCreateComments = StubUtility.doAddComments(astRoot.getJavaElement().getJavaScriptProject());
        this.fVisibility = 1;
        this.fOmitSuper = false;
    }

    public String[] getCreatedConstructors() {
        String[] keys = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(keys);
        return keys;
    }

    public String[] getCreatedImports() {
        return this.fCreatedImports;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean isOmitSuper() {
        return this.fOmitSuper;
    }

    public void setCreateComments(boolean comments) {
        this.fCreateComments = comments;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName(CodeGenerationMessages.AddUnimplementedMethodsOperation_description);
            this.fCreatedMethods.clear();
            IJavaScriptUnit cu = (IJavaScriptUnit)this.fASTRoot.getJavaElement();
            AST ast = this.fASTRoot.getAST();
            ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding currTypeBinding = this.fType;
            ListRewrite memberRewriter = null;
            ASTNode node = this.fASTRoot.findDeclaringNode((IBinding)currTypeBinding);
            if (node instanceof AnonymousClassDeclaration) {
                memberRewriter = astRewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else {
                if (!(node instanceof AbstractTypeDeclaration)) throw new IllegalArgumentException();
                ChildListPropertyDescriptor property = ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
                memberRewriter = astRewrite.getListRewrite(node, property);
            }
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaScriptProject());
            settings.createComments = this.fCreateComments;
            ASTNode insertion = this.getNodeToInsertBefore(memberRewriter);
            IFunctionBinding[] toImplement = this.fConstructorsToImplement;
            if (toImplement == null) {
                toImplement = StubUtility2.getVisibleConstructors(currTypeBinding, true, true);
            }
            int deprecationCount = 0;
            int i = 0;
            while (true) {
                block15: {
                    if (i < toImplement.length) break block15;
                }
                if (toImplement[i].isDeprecated()) {
                    ++deprecationCount;
                }
                ++i;
            }
            boolean createDeprecated = deprecationCount == toImplement.length;
            int i2 = 0;
            while (true) {
                FunctionDeclaration stub;
                block16: {
                    if (i2 < toImplement.length) break block16;
                    MultiTextEdit edit = new MultiTextEdit();
                    TextEdit importEdits = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fCreatedImports = importRewrite.getCreatedImports();
                    if (this.fImports) {
                        edit.addChild(importEdits);
                    }
                    edit.addChild(astRewrite.rewriteAST());
                    if (this.fApply) {
                        JavaModelUtil.applyEdit(cu, (TextEdit)edit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    break;
                }
                IFunctionBinding curr = toImplement[i2];
                if ((!curr.isDeprecated() || createDeprecated) && (stub = StubUtility2.createConstructorStub(cu, astRewrite, importRewrite, curr, currTypeBinding.getName(), this.fVisibility, this.fOmitSuper, true, settings)) != null) {
                    this.fCreatedMethods.add(curr.getKey());
                    if (insertion != null) {
                        memberRewriter.insertBefore((ASTNode)stub, insertion, null);
                    } else {
                        memberRewriter.insertLast((ASTNode)stub, null);
                    }
                }
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        monitor.done();
    }

    public void setOmitSuper(boolean omit) {
        this.fOmitSuper = omit;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    private ASTNode getNodeToInsertBefore(ListRewrite rewriter) {
        if (this.fInsertPos != -1) {
            List members = rewriter.getOriginalList();
            int i = 0;
            while (i < members.size()) {
                ASTNode curr = (ASTNode)members.get(i);
                if (curr.getStartPosition() >= this.fInsertPos) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }
}

