/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.structureddocument.internal.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.jsf.context.structureddocument.AbstractStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.jsf.context.structureddocument.internal.impl.DefaultStructuredDocumentContext;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructuredDocumentContextFactory
extends AbstractStructuredDocumentContextFactory
implements IStructuredDocumentContextFactory,
IStructuredDocumentContextFactory2 {
    private static StructuredDocumentContextFactory INSTANCE;

    public StructuredDocumentContextFactory(Class[] supportedDelegateTypes) {
        super(supportedDelegateTypes);
    }

    public static synchronized StructuredDocumentContextFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StructuredDocumentContextFactory();
        }
        return INSTANCE;
    }

    protected StructuredDocumentContextFactory() {
        super(new Class[]{IStructuredDocumentContextFactory.class});
    }

    public final IStructuredDocumentContext getContext(ITextViewer textViewer, int documentPosition) {
        IStructuredDocumentContext context = this.internalGetContext(textViewer, documentPosition);
        if (context == null) {
            context = this.delegateGetContext(textViewer, documentPosition);
        }
        return context;
    }

    private IStructuredDocumentContext internalGetContext(ITextViewer textViewer, int documentPosition) {
        if (textViewer instanceof StructuredTextViewer) {
            IDocument document = ((StructuredTextViewer)textViewer).getDocument();
            return this.internalGetContext(document, documentPosition);
        }
        return null;
    }

    private IStructuredDocumentContext internalGetContext(IDocument document, int documentPosition) {
        if (document instanceof IStructuredDocument) {
            return new DefaultStructuredDocumentContext((IStructuredDocument)document, documentPosition);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredDocumentContext delegateGetContext(ITextViewer textViewer, int documentPosition) {
        List list = this._delegates;
        synchronized (list) {
            Iterator it = this._delegates.iterator();
            while (it.hasNext()) {
                IStructuredDocumentContextFactory delegateFactory = (IStructuredDocumentContextFactory)((IAdaptable)it.next()).getAdapter(IStructuredDocumentContextFactory.class);
                IStructuredDocumentContext context = delegateFactory.getContext(textViewer, documentPosition);
                if (context == null) continue;
                return context;
            }
            return null;
        }
    }

    public IStructuredDocumentContext getContext(IDocument document, int documentPosition) {
        IStructuredDocumentContext context = this.internalGetContext(document, documentPosition);
        if (context == null) {
            context = this.delegateGetContext(document, documentPosition);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredDocumentContext delegateGetContext(IDocument document, int documentPosition) {
        List list = this._delegates;
        synchronized (list) {
            Iterator it = this._delegates.iterator();
            while (it.hasNext()) {
                IStructuredDocumentContextFactory delegateFactory = (IStructuredDocumentContextFactory)((IAdaptable)it.next()).getAdapter(IStructuredDocumentContextFactory.class);
                IStructuredDocumentContext context = delegateFactory.getContext(document, documentPosition);
                if (context == null) continue;
                return context;
            }
            return null;
        }
    }

    public IStructuredDocumentContext getContext(IDocument document, Node node) {
        IStructuredDocumentContext context = this.internalGetContext(document, node);
        if (context == null) {
            context = this.delegateGetContext(document, node);
        }
        return context;
    }

    private IStructuredDocumentContext internalGetContext(IDocument document, Node node) {
        if (document instanceof IStructuredDocument) {
            IStructuredDocument sDoc = (IStructuredDocument)document;
            if (node instanceof IndexedRegion) {
                int position = ((IndexedRegion)node).getStartOffset();
                return new DefaultStructuredDocumentContext(sDoc, position);
            }
            if (node instanceof IDOMAttr) {
                IDOMAttr attr = (IDOMAttr)node;
                int position = attr.getValueRegionStartOffset();
                return new DefaultStructuredDocumentContext(sDoc, position);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredDocumentContext delegateGetContext(IDocument document, Node node) {
        List list = this._delegates;
        synchronized (list) {
            Iterator it = this._delegates.iterator();
            while (it.hasNext()) {
                IStructuredDocumentContextFactory delegateFactory = (IStructuredDocumentContextFactory)((IAdaptable)it.next()).getAdapter(IStructuredDocumentContextFactory.class);
                IStructuredDocumentContext context = delegateFactory.getContext(document, node);
                if (context == null) continue;
                return context;
            }
            return null;
        }
    }

    public IStructuredDocumentContext getContext(Element element) {
        IStructuredDocumentContext context = this.internalGetContext(element);
        if (context == null) {
            context = this.delegateGetContext(element);
        }
        return context;
    }

    private IStructuredDocumentContext internalGetContext(Element element) {
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            IStructuredDocument sDoc = node.getStructuredDocument();
            int position = node.getStartOffset();
            return new DefaultStructuredDocumentContext(sDoc, position);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredDocumentContext delegateGetContext(Element element) {
        List list = this._delegates;
        synchronized (list) {
            Iterator it = this._delegates.iterator();
            while (it.hasNext()) {
                IStructuredDocumentContext context;
                IStructuredDocumentContextFactory2 delegateFactory = (IStructuredDocumentContextFactory2)((IAdaptable)it.next()).getAdapter(IStructuredDocumentContextFactory2.class);
                if (delegateFactory == null || (context = delegateFactory.getContext(element)) == null) continue;
                return context;
            }
            return null;
        }
    }
}

