/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.adapter;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class AdapterCCombo
extends AdapterImpl
implements SelectionListener {
    private EObject eObject_ = null;
    private EStructuralFeature feature_;
    private EStructuralFeature displayFeature_;
    private CCombo combo_;
    private String defaultDisplayString_;

    public AdapterCCombo(EStructuralFeature feature, EStructuralFeature displayFeature, CCombo combo, String defaultDisplayString) {
        this.feature_ = feature;
        this.displayFeature_ = displayFeature;
        this.combo_ = combo;
        this.combo_.addSelectionListener((SelectionListener)this);
        this.defaultDisplayString_ = defaultDisplayString != null ? defaultDisplayString : "";
    }

    public AdapterCCombo(EStructuralFeature feature, EStructuralFeature displayFeature, CCombo combo) {
        this(feature, displayFeature, combo, null);
    }

    public AdapterCCombo(EObject eObject, EStructuralFeature feature, EStructuralFeature displayFeature, CCombo combo) {
        this(eObject, feature, displayFeature, combo, null);
    }

    public AdapterCCombo(EObject eObject, EStructuralFeature feature, EStructuralFeature displayFeature, CCombo combo, String defaultDisplayString) {
        this(feature, displayFeature, combo, defaultDisplayString);
        this.adapt(eObject);
    }

    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (notifier == this.eObject_) {
            int type = msg.getEventType();
            if (type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 6) {
                this.populateCombo();
            }
        } else if (msg.getFeature() == this.displayFeature_) {
            this.populateCombo();
        }
    }

    private void populateCombo() {
        Object object;
        if (this.eObject_ != null && (object = this.eObject_.eGet(this.feature_)) != null) {
            if (this.combo_.isDisposed()) {
                return;
            }
            int selectionIndex = this.combo_.getSelectionIndex();
            String text = this.combo_.getText();
            this.combo_.removeAll();
            if (object instanceof EList) {
                EList eList = (EList)object;
                Iterator it = eList.iterator();
                while (it.hasNext()) {
                    this.combo_.add(this.toDisplayString(((EObject)it.next()).eGet(this.displayFeature_)));
                }
            } else {
                this.combo_.add(this.toDisplayString(((EObject)object).eGet(this.displayFeature_)));
            }
            int newIndex = this.combo_.indexOf(text);
            if (selectionIndex != -1 && newIndex != -1) {
                this.combo_.select(newIndex);
            } else {
                this.combo_.select(0);
            }
        }
    }

    private String toDisplayString(Object object) {
        String s;
        if (object != null && (s = object.toString()) != null && s.length() > 0) {
            return s;
        }
        return this.defaultDisplayString_;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void adapt(EObject eObject) {
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().remove((Object)this);
            this.combo_.removeAll();
        }
        this.eObject_ = eObject;
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().add((Object)this);
            Object object = this.eObject_.eGet(this.feature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof EObject)) continue;
                    ((EObject)item).eAdapters().add((Object)this);
                }
            } else if (object instanceof EObject) {
                ((EObject)object).eAdapters().add((Object)this);
            }
            this.populateCombo();
        }
    }

    public void dispose() {
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().remove((Object)this);
        }
        if (this.combo_ != null && !this.combo_.isDisposed()) {
            this.combo_.removeSelectionListener((SelectionListener)this);
        }
    }
}

