/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.thingworx;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Objects;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ThingWorxCodeGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel model, InvocationContext invocationContext) {
        String _serviceKey = this.getServiceKey();
        GenerationResultZip zipOutput = new GenerationResultZip(model, _serviceKey);
        JSONGeneratorTask _jSONGeneratorTask = new JSONGeneratorTask();
        _jSONGeneratorTask.generate(model, invocationContext, (IGeneratedWriter)zipOutput);
        return zipOutput;
    }

    public String getServiceKey() {
        return "thingworx";
    }

    public static class JSONGeneratorTask
    implements ICodeGeneratorTask<InformationModel> {
        public void generate(InformationModel model, InvocationContext invocationContext, IGeneratedWriter writer) {
            String _name = model.getName();
            String _plus = String.valueOf(_name) + ".json";
            String _content = this.getContent(model);
            Generated _generated = new Generated(_plus, null, _content);
            writer.write(_generated);
        }

        public String getContent(InformationModel model) {
            JsonFactory f = new JsonFactory();
            String json = "";
            try {
                String _string;
                StringWriter writer = new StringWriter();
                JsonGenerator g = f.createGenerator((Writer)writer);
                g.writeStartObject();
                this.generateThingTemplate(g, model);
                g.writeEndObject();
                g.flush();
                json = _string = writer.toString();
                g.close();
                writer.close();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    return e.getMessage();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return json;
        }

        public void generateThingTemplate(JsonGenerator g, InformationModel model) {
            try {
                g.writeObjectFieldStart("thingTemplate");
                String _displayname = model.getDisplayname();
                g.writeStringField("name", _displayname);
                g.writeStringField("baseThingTemplate", "RemoteThing");
                String _description = model.getDescription();
                g.writeStringField("description", _description);
                g.writeStringField("tags", "Applications:Vorto_CodeGen");
                g.writeArrayFieldStart("propertyDefinitions");
                g.writeEndArray();
                g.writeArrayFieldStart("serviceDefinitions");
                g.writeEndArray();
                g.writeArrayFieldStart("eventDefinitions");
                g.writeEndArray();
                g.writeObjectFieldStart("alertConfigurations");
                g.writeEndObject();
                this.enumerateImplementedShapes(g, model);
                g.writeEndObject();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        protected void enumerateImplementedShapes(JsonGenerator g, InformationModel model) {
            try {
                g.writeArrayFieldStart("implementedShapes");
                EList _properties = model.getProperties();
                for (FunctionblockProperty functionBlock : _properties) {
                    FunctionBlock _functionblock_1;
                    Configuration _configuration;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    FunctionblockModel fbModel = functionBlock.getType();
                    g.writeStartObject();
                    String _displayname = fbModel.getDisplayname();
                    g.writeStringField("name", _displayname);
                    g.writeStringField("type", "ThingShape");
                    String _description = this.getDescription(fbModel);
                    g.writeStringField("description", _description);
                    g.writeStringField("tags", "Applications:Vorto_CodeGen");
                    g.writeArrayFieldStart("propertyDefinitions");
                    FunctionBlock _functionblock = fbModel.getFunctionblock();
                    Status _status = _functionblock.getStatus();
                    boolean bl = _notEquals = !Objects.equal((Object)_status, null);
                    if (_notEquals) {
                        this.enumerateProperties(fbModel, g, VortoPropertyType.STATUS);
                    }
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_configuration = (_functionblock_1 = fbModel.getFunctionblock()).getConfiguration()), null);
                    if (_notEquals_1) {
                        this.enumerateProperties(fbModel, g, VortoPropertyType.CONFIGURATION);
                    }
                    g.writeEndArray();
                    g.writeArrayFieldStart("serviceDefinitions");
                    this.enumerateServices(fbModel, g);
                    g.writeEndArray();
                    g.writeArrayFieldStart("eventDefinitions");
                    g.writeEndArray();
                    g.writeObjectFieldStart("alertConfigurations");
                    g.writeArrayFieldStart("alertDefinitions");
                    g.writeEndArray();
                    g.writeEndObject();
                    g.writeEndObject();
                }
                g.writeEndArray();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        protected void enumerateProperties(FunctionblockModel fbModel, JsonGenerator g, VortoPropertyType propType) {
            try {
                boolean readOnly = false;
                EList properties = null;
                boolean _equals = Objects.equal((Object)((Object)propType), (Object)((Object)VortoPropertyType.STATUS));
                if (_equals) {
                    EList _properties;
                    readOnly = true;
                    FunctionBlock _functionblock = fbModel.getFunctionblock();
                    Status _status = _functionblock.getStatus();
                    properties = _properties = _status.getProperties();
                } else {
                    boolean _equals_1 = Objects.equal((Object)((Object)propType), (Object)((Object)VortoPropertyType.CONFIGURATION));
                    if (_equals_1) {
                        EList _properties_1;
                        FunctionBlock _functionblock_1 = fbModel.getFunctionblock();
                        Configuration _configuration = _functionblock_1.getConfiguration();
                        properties = _properties_1 = _configuration.getProperties();
                        readOnly = false;
                    }
                }
                for (Property currentStatusProperty : properties) {
                    PropertyType _type = currentStatusProperty.getType();
                    if (!(_type instanceof PrimitivePropertyType)) continue;
                    String currentType = this.getPrimitivePropertyType(currentStatusProperty);
                    g.writeStartObject();
                    String _name = currentStatusProperty.getName();
                    g.writeStringField("name", _name);
                    String _thingWorxDataType = this.getThingWorxDataType(currentType);
                    g.writeStringField("baseType", _thingWorxDataType);
                    String _description = this.getDescription(currentStatusProperty);
                    g.writeStringField("description", _description);
                    g.writeBooleanField("isLocalOnly", false);
                    g.writeObjectFieldStart("aspects");
                    g.writeNumberField("cacheTime", 0.0);
                    g.writeStringField("dataChangeType", "VALUE");
                    g.writeBooleanField("isLogged", false);
                    g.writeBooleanField("isPersistent", true);
                    g.writeBooleanField("isReadOnly", readOnly);
                    g.writeEndObject();
                    g.writeEndObject();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        protected void enumerateServices(FunctionblockModel fbModel, JsonGenerator g) {
            try {
                FunctionBlock _functionblock = fbModel.getFunctionblock();
                EList services = _functionblock.getOperations();
                for (Operation currentService : services) {
                    g.writeStartObject();
                    String _name = currentService.getName();
                    g.writeStringField("name", _name);
                    String _description = this.getDescription(currentService);
                    g.writeStringField("description", _description);
                    g.writeObjectFieldStart("resultType");
                    g.writeStringField("name", "result");
                    String _resultBaseType = this.getResultBaseType(currentService);
                    g.writeStringField("baseType", _resultBaseType);
                    String _description_1 = currentService.getDescription();
                    g.writeStringField("description", _description_1);
                    g.writeEndObject();
                    g.writeArrayFieldStart("parameterDefinitions");
                    EList _params = currentService.getParams();
                    for (Param currentParam : _params) {
                        if (!(currentParam instanceof PrimitiveParam)) continue;
                        g.writeStartObject();
                        String _name_1 = ((PrimitiveParam)currentParam).getName();
                        g.writeStringField("name", _name_1);
                        PrimitiveType _type = ((PrimitiveParam)currentParam).getType();
                        String paramType = _type.getLiteral();
                        String _thingWorxDataType = this.getThingWorxDataType(paramType);
                        g.writeStringField("baseType", _thingWorxDataType);
                        g.writeStringField("description", "");
                        g.writeEndObject();
                    }
                    g.writeEndArray();
                    g.writeEndObject();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        protected String getDescription(Property property) {
            boolean _notEquals;
            String _description = property.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                return property.getDescription();
            }
            return "";
        }

        protected String getDescription(Operation operation) {
            boolean _notEquals;
            String _description = operation.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                return operation.getDescription();
            }
            return "";
        }

        protected String getDescription(FunctionblockModel fbModel) {
            boolean _notEquals;
            String _description = fbModel.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                return fbModel.getDescription();
            }
            return "";
        }

        protected String getPrimitivePropertyType(Property property) {
            PropertyType _type = property.getType();
            if (_type instanceof PrimitivePropertyType) {
                PropertyType _type_1 = property.getType();
                PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
                return _type_2.toString();
            }
            return "UNDEFINED";
        }

        protected String getResultBaseType(Operation operation) {
            boolean _notEquals;
            boolean _and = false;
            ReturnType _returnType = operation.getReturnType();
            boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
            if (!_notEquals) {
                _and = false;
            } else {
                ReturnType _returnType_1 = operation.getReturnType();
                _and = _returnType_1 instanceof ReturnPrimitiveType;
            }
            if (_and) {
                boolean _equals;
                ReturnType _returnType_2 = operation.getReturnType();
                boolean _isMultiplicity = _returnType_2.isMultiplicity();
                boolean bl2 = _equals = !_isMultiplicity;
                if (_equals) {
                    ReturnType primitiveType = operation.getReturnType();
                    PrimitiveType _returnType_3 = ((ReturnPrimitiveType)primitiveType).getReturnType();
                    String typeName = _returnType_3.getLiteral();
                    return this.getThingWorxDataType(typeName);
                }
                return "COMPLEX_TYPE";
            }
            return "NOTHING";
        }

        public String getThingWorxDataType(String vortoType) {
            String dataType = "";
            Pair _mappedTo = Pair.of((Object)"base64Binary", (Object)"BLOB");
            Pair _mappedTo_1 = Pair.of((Object)"boolean", (Object)"BOOLEAN");
            Pair _mappedTo_2 = Pair.of((Object)"dateTime", (Object)"DATETIME");
            Pair _mappedTo_3 = Pair.of((Object)"int", (Object)"INTEGER");
            Pair _mappedTo_4 = Pair.of((Object)"short", (Object)"INTEGER");
            Pair _mappedTo_5 = Pair.of((Object)"long", (Object)"INTEGER");
            Pair _mappedTo_6 = Pair.of((Object)"byte", (Object)"INTEGER");
            Pair _mappedTo_7 = Pair.of((Object)"double", (Object)"NUMBER");
            Pair _mappedTo_8 = Pair.of((Object)"float", (Object)"NUMBER");
            Pair _mappedTo_9 = Pair.of((Object)"string", (Object)"STRING");
            HashMap typeMap = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4, _mappedTo_5, _mappedTo_6, _mappedTo_7, _mappedTo_8, _mappedTo_9});
            String _get = (String)typeMap.get(vortoType);
            dataType = _get;
            boolean _equals = Objects.equal((Object)dataType, null);
            if (_equals) {
                dataType = "UNDEFINED";
            }
            return dataType;
        }
    }

    private static enum VortoPropertyType {
        STATUS,
        CONFIGURATION;

    }
}

