/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.eclipse.virgo.web.enterprise.services.accessor.WebAppBundleClassLoaderDelegateHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppBundleTrackerCustomizer
implements BundleTrackerCustomizer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAppBundleTrackerCustomizer.class);
    static final String API_BUNDLES = "api.bundles";
    static final String IMPL_BUNDLES = "impl.bundles";
    static final String POST_API_BUNDLES = "post.api.bundles";
    static final String POST_API_PACKAGES = "post.api.packages";
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String VERSION_SEPARATOR = "=";
    static final String HEADER_EXPOSED_CONTENT_TYPE = "Exposed-ContentType";
    static final String HEADER_EXPOSED_CONTENT_TYPE_API_VALUE = "API";
    static final String HEADER_EXPOSED_CONTENT_TYPE_IMPL_VALUE = "Implementation";
    static final String HEADER_EXPOSE_ADDITIONAL_API = "Expose-AdditionalAPI";
    private static final char INCLUSIVE_UPPER = ']';
    private static final char EXCLUSIVE_UPPER = ')';
    private final WebAppBundleClassLoaderDelegateHook wabClassLoaderDelegateHook;
    private final Map<String, VersionRange> exposeAdditionalApiBundles = new HashMap<String, VersionRange>();
    private Map<String, List<Bundle>> bundlesWithSameBSNMap;
    private boolean initialized = false;
    private final List<String> bundleNamesForJarScanner;
    private final Set<Bundle> bundlesForJarScanner = new HashSet<Bundle>();
    @Deprecated
    private final Map<String, VersionRange> apiBundles;
    @Deprecated
    private final Map<String, VersionRange> implBundles;
    @Deprecated
    private final Map<String, VersionRange> postApiBundles;

    public WebAppBundleTrackerCustomizer(WebAppBundleClassLoaderDelegateHook wabClassLoaderDelegateHook) {
        String bundlesForJarScanner = System.getProperty("org.eclipse.virgo.jarscanner.bundles");
        this.bundleNamesForJarScanner = bundlesForJarScanner != null ? Arrays.asList(bundlesForJarScanner.split(COMMA_SEPARATOR)) : new ArrayList<String>();
        this.wabClassLoaderDelegateHook = wabClassLoaderDelegateHook;
        this.apiBundles = Collections.unmodifiableMap(WebAppBundleTrackerCustomizer.getBundles(System.getProperty(API_BUNDLES)));
        this.implBundles = Collections.unmodifiableMap(WebAppBundleTrackerCustomizer.getBundles(System.getProperty(IMPL_BUNDLES)));
        this.postApiBundles = Collections.unmodifiableMap(WebAppBundleTrackerCustomizer.getBundles(System.getProperty(POST_API_BUNDLES)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Predefined api bundles added to the tracker " + this.apiBundles);
            LOGGER.debug("Predefined impl bundles added to the tracker " + this.implBundles);
        }
    }

    public String addingBundle(Bundle bundle, BundleEvent event) {
        if (this.bundleNamesForJarScanner.contains(bundle.getSymbolicName())) {
            this.bundlesForJarScanner.add(bundle);
        }
        if (this.isApiBundle(bundle)) {
            this.wabClassLoaderDelegateHook.addApiBundle(bundle);
        }
        if (this.isImplBundle(bundle)) {
            this.wabClassLoaderDelegateHook.addImplBundle(bundle);
        }
        if (this.postApiBundles.containsKey(bundle.getSymbolicName())) {
            this.wabClassLoaderDelegateHook.addPostApiBundle(bundle);
        }
        this.processExposeAdditionalAPIHeader(bundle);
        return bundle.getSymbolicName();
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, String symbolicName) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, String symbolicName) {
        this.wabClassLoaderDelegateHook.removeApiBundle(bundle);
        this.wabClassLoaderDelegateHook.removeImplBundle(bundle);
        this.wabClassLoaderDelegateHook.removeWebAppBundle(bundle);
        this.bundlesForJarScanner.remove(bundle);
    }

    synchronized void processAdditionalAPIBundles(Bundle[] allBundles) {
        if (allBundles == null || allBundles.length == 0 || this.exposeAdditionalApiBundles == null || this.exposeAdditionalApiBundles.size() == 0) {
            return;
        }
        if (!this.initialized) {
            this.bundlesWithSameBSNMap = this.getBundleMap(allBundles);
            Set<String> keys = this.exposeAdditionalApiBundles.keySet();
            for (String key : keys) {
                List<Bundle> bundlesWithSameBSN = this.bundlesWithSameBSNMap.get(key);
                if (bundlesWithSameBSN == null || bundlesWithSameBSN.size() == 0) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("Bundle with symbolic name [" + key + "] is marked as additional API." + "Such bundle is not installed on the system and cannot be added to the application classloader." + "This may cause a severe problem during runtime.");
                    continue;
                }
                Bundle apiBundle = null;
                int i = 0;
                while (i < bundlesWithSameBSN.size()) {
                    Bundle bundle;
                    VersionRange range = this.exposeAdditionalApiBundles.get(key);
                    if (range.includes((bundle = bundlesWithSameBSN.get(i)).getVersion()) && (apiBundle == null || apiBundle.getVersion().compareTo(bundle.getVersion()) < 0)) {
                        apiBundle = bundle;
                    }
                    ++i;
                }
                if (apiBundle == null) continue;
                this.wabClassLoaderDelegateHook.addApiBundle(apiBundle);
            }
            this.initialized = true;
        }
    }

    Map<String, List<Bundle>> getBundlesWithSameBSNMap() {
        return this.bundlesWithSameBSNMap;
    }

    Map<String, VersionRange> getExposeAdditionalApiBundles() {
        return this.exposeAdditionalApiBundles;
    }

    private Map<String, List<Bundle>> getBundleMap(Bundle[] allBundles) {
        HashMap<String, List<Bundle>> result = new HashMap<String, List<Bundle>>();
        Bundle[] bundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String bsn = bundle.getSymbolicName();
            ArrayList<Bundle> bundlesWithSameBSN = (ArrayList<Bundle>)result.get(bsn);
            if (bundlesWithSameBSN == null) {
                bundlesWithSameBSN = new ArrayList<Bundle>();
            }
            bundlesWithSameBSN.add(bundle);
            result.put(bsn, bundlesWithSameBSN);
            ++n2;
        }
        return result;
    }

    private boolean isApiBundle(Bundle bundle) {
        String headerValue = this.getHeaderValue(bundle, HEADER_EXPOSED_CONTENT_TYPE);
        if (HEADER_EXPOSED_CONTENT_TYPE_API_VALUE.equals(headerValue)) {
            return true;
        }
        VersionRange versionRange = this.apiBundles.get(bundle.getSymbolicName());
        if (versionRange != null && versionRange.includes(bundle.getVersion())) {
            return true;
        }
        versionRange = this.exposeAdditionalApiBundles.get(bundle.getSymbolicName());
        return versionRange != null && versionRange.includes(bundle.getVersion());
    }

    private boolean isImplBundle(Bundle bundle) {
        String headerValue = this.getHeaderValue(bundle, HEADER_EXPOSED_CONTENT_TYPE);
        if (HEADER_EXPOSED_CONTENT_TYPE_IMPL_VALUE.equals(headerValue)) {
            return true;
        }
        VersionRange versionRange = this.implBundles.get(bundle.getSymbolicName());
        return versionRange != null && versionRange.includes(bundle.getVersion());
    }

    private synchronized void processExposeAdditionalAPIHeader(Bundle bundle) {
        LinkedHashMap<String, VersionRange> additionalApiBundles;
        String headerValue = this.getHeaderValue(bundle, HEADER_EXPOSE_ADDITIONAL_API);
        if (headerValue != null && !headerValue.equals("") && (additionalApiBundles = WebAppBundleTrackerCustomizer.getBundles(headerValue)) != null) {
            Set keys = additionalApiBundles.keySet();
            for (String key : keys) {
                VersionRange oldVersionRange = this.exposeAdditionalApiBundles.get(key);
                VersionRange newVersionRange = (VersionRange)additionalApiBundles.get(key);
                if (oldVersionRange != null) {
                    this.exposeAdditionalApiBundles.put(key, VersionRange.intersection((VersionRange)oldVersionRange, (VersionRange)newVersionRange));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Expose additional API bundle with BSN [" + key + "] and merge old version [" + oldVersionRange + "] with the new one [" + newVersionRange + "]");
                    continue;
                }
                this.exposeAdditionalApiBundles.put(key, (VersionRange)additionalApiBundles.get(key));
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Expose additional API bundle with BSN [" + key + "] and version [" + newVersionRange + "].");
            }
        }
    }

    static LinkedHashMap<String, VersionRange> getBundles(String property) {
        List<String> bundleNames;
        LinkedHashMap<String, VersionRange> bundles = new LinkedHashMap<String, VersionRange>();
        if (property != null && (bundleNames = WebAppBundleTrackerCustomizer.parse(property)).size() > 0) {
            for (String bundleName : bundleNames) {
                String[] parts = bundleName.split(SEMICOLON_SEPARATOR);
                if (parts == null || parts.length != 2) continue;
                String symbolicName = parts[0];
                String[] versionParts = parts[1].split(VERSION_SEPARATOR);
                if (versionParts == null || versionParts.length != 2) continue;
                VersionRange bundleVersion = new VersionRange(versionParts[1]);
                bundles.put(symbolicName, bundleVersion);
            }
        }
        return bundles;
    }

    private static List<String> parse(String property) {
        ArrayList<String> result = new ArrayList<String>();
        int ind = property.indexOf(COMMA_SEPARATOR);
        if (ind >= 0) {
            int nextComma = property.indexOf(COMMA_SEPARATOR, ind + 1);
            if (nextComma >= 0) {
                char prevChar = property.charAt(nextComma - 1);
                if (prevChar == ')' || prevChar == ']') {
                    result.add(property.substring(0, nextComma).trim());
                    result.addAll(WebAppBundleTrackerCustomizer.parse(property.substring(nextComma + 1)));
                } else {
                    result.add(property.substring(0, ind).trim());
                    result.addAll(WebAppBundleTrackerCustomizer.parse(property.substring(ind + 1)));
                }
            } else {
                char lastIndex = property.charAt(property.length() - 1);
                if (lastIndex == ')' || lastIndex == ']') {
                    result.add(property.trim());
                } else {
                    result.add(property.substring(0, ind).trim());
                    result.add(property.substring(ind + 1).trim());
                }
            }
        } else {
            result.add(property);
        }
        return result;
    }

    private String getHeaderValue(Bundle bundle, String headerName) {
        return (String)bundle.getHeaders().get(headerName);
    }

    Set<Bundle> getBundlesForJarScanner() {
        return this.bundlesForJarScanner;
    }
}

