/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;

public class DeploymentsResolver
implements DeploymentFilterable {
    private static final String EXCLUDE_INCLUDE_ORDER = SystemInstance.get().getOptions().get("openejb.exclude-include.order", "include-exclude");
    private static final String[] ignoreDirs = SystemInstance.get().getProperty("openejb.ignore.directories", ".svn,_svn,cvs,.git,.hg").split(",");
    private static final Logger logger = DeploymentLoader.logger;
    private static File lib = null;

    protected static boolean isValidDirectory(File file) {
        if (file.isDirectory() && !file.isHidden() && !file.equals(lib)) {
            String fn = file.getName();
            for (String dir : ignoreDirs) {
                if (!fn.equalsIgnoreCase(dir)) continue;
                return false;
            }
            String[] files = file.list();
            return null != files && files.length > 0;
        }
        return false;
    }

    public static void loadFrom(Deployments dep, FileUtils path, List<File> jarList) {
        if (dep.getDir() != null) {
            try {
                DeploymentsResolver.loadFromDir(dep, path, jarList);
            }
            catch (Files.FileDoesNotExistException e) {
                logger.warning("<Deployments dir=\"" + dep.getFile() + "\"> - " + e.getMessage());
            }
            catch (RuntimeException e) {
                String message = "<Deployments dir=\"" + dep.getFile() + "\"> - " + e.getMessage();
                logger.error(message);
                throw new DeploymentsConfigurationException(message);
            }
        } else if (dep.getFile() != null) {
            try {
                DeploymentsResolver.loadFromFile(dep, path, jarList);
            }
            catch (RuntimeException e) {
                String message = "<Deployments file=\"" + dep.getFile() + "\"> - " + e.getMessage();
                logger.error(message);
                throw new DeploymentsConfigurationException(message);
            }
        }
    }

    private static void loadFromFile(Deployments dep, FileUtils path, List<File> jarList) {
        File file = Files.path((File)path.getDirectory(), (String[])new String[]{dep.getFile()});
        Files.exists((File)file);
        Files.readable((File)file);
        Files.file((File)file);
        if (!jarList.contains(file)) {
            jarList.add(file);
        }
    }

    private static void loadFromDir(Deployments dep, FileUtils path, List<File> jarList) {
        File dir = Files.path((File)path.getDirectory(), (String[])new String[]{dep.getDir()});
        Files.exists((File)dir);
        Files.readable((File)dir);
        Files.dir((File)dir);
        Files.notHidden((File)dir);
        LinkedHashMap<String, File> files = new LinkedHashMap<String, File>();
        File[] list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return DeploymentsResolver.isValidDirectory(f);
                }
                return true;
            }
        });
        if (list != null) {
            for (File file : list) {
                files.put(file.getAbsolutePath(), file);
            }
            for (File file : list) {
                if (!DeploymentsResolver.isArchive(file)) continue;
                String archive = file.getAbsolutePath();
                files.remove(archive.substring(0, archive.length() - 4));
            }
        }
        for (File file : files.values()) {
            if (jarList.contains(file)) continue;
            jarList.add(file);
        }
    }

    private static boolean isArchive(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (!file.getName().toLowerCase().endsWith("ar")) {
            return false;
        }
        String name = file.getName();
        char c = name.charAt(name.length() - 4);
        return c == '.';
    }

    public static void loadFromClasspath(FileUtils base, List<URL> jarList, ClassLoader classLoader) {
        Options options = SystemInstance.get().getOptions();
        String include = options.get("openejb.deployments.classpath.include", ".*");
        String exclude = options.get("openejb.deployments.classpath.exclude", "");
        Set requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", (Enum[])new RequireDescriptors[]{RequireDescriptors.CLIENT});
        boolean filterDescriptors = options.get("openejb.deployments.classpath.filter.descriptors", false);
        boolean filterSystemApps = options.get("openejb.deployments.classpath.filter.systemapps", true);
        try {
            UrlSet urlSet = new UrlSet(classLoader);
            UrlSet prefiltered = urlSet = URLs.cullSystemJars(urlSet);
            Filter includeFilter = Filters.patterns((String[])new String[]{include});
            if (!".*".equals(include) || !"".equals(exclude)) {
                Object filter = EXCLUDE_INCLUDE_ORDER.startsWith("include") ? new IncludeExcludeFilter(includeFilter, Filters.patterns((String[])new String[]{exclude})) : new ExcludeIncludeFilter(includeFilter, Filters.patterns((String[])new String[]{exclude}));
                urlSet = urlSet.filter((Filter)filter);
            } else {
                includeFilter = null;
            }
            if (prefiltered.size() == urlSet.size()) {
                urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet, includeFilter);
                if (filterSystemApps) {
                    urlSet = urlSet.exclude(".*/openejb-[^/]+(.(jar|ear|war)(!/)?|/target/(test-)?classes/?)");
                }
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            boolean isWindows = System.getProperty("os.name", "unknown").toLowerCase().startsWith("windows");
            for (URL url : urlSet.getUrls()) {
                String ef = isWindows ? url.toExternalForm().toLowerCase() : url.toExternalForm();
                URL u = new URL(ef);
                if (urls.contains(u)) continue;
                urls.add(u);
            }
            int size = urls.size();
            if (size == 0 && include.length() > 0) {
                logger.warning("No classpath URLs matched.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                return;
            }
            if (size == 0 && !filterDescriptors && prefiltered.getUrls().size() == 0) {
                return;
            }
            if (size < 20) {
                logger.debug("Inspecting classpath for applications: " + urls.size() + " urls.");
            } else {
                boolean willScrape;
                boolean bl = willScrape = requireDescriptors.size() < RequireDescriptors.values().length;
                if (size < 50 && willScrape) {
                    logger.info("Inspecting classpath for applications: " + urls.size() + " urls. Consider adjusting your exclude/include.  Current settings: " + "openejb.deployments.classpath.exclude" + "='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                } else if (willScrape) {
                    logger.warning("Inspecting classpath for applications: " + urls.size() + " urls.");
                    logger.warning("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                }
            }
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls(urls, classLoader, requireDescriptors, base, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            UrlSet unchecked = new UrlSet(new URL[0]);
            if (!filterDescriptors) {
                unchecked = NewLoaderLogic.applyBuiltinExcludes(prefiltered.exclude(urlSet));
                if (filterSystemApps) {
                    unchecked = unchecked.exclude(".*/openejb-[^/]+(.(jar|ear|war)(./)?|/target/classes/?)");
                }
                DeploymentsResolver.processUrls(unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            }
            if (logger.isDebugEnabled()) {
                int urlCount = urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("URLs after filtering: " + urlCount);
                for (URL uRL : urlSet.getUrls()) {
                    logger.debug("Annotations path: " + uRL);
                }
                for (URL uRL : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + uRL);
                }
            }
            if (urls.size() == 0) {
                return;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 4000L || urls.size() < 3) {
                logger.info("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='" + exclude + "', include='" + include + "'");
            } else {
                logger.fatal("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
        }
    }

    public static void processUrls(List<URL> urls, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptors, FileUtils base, List<URL> jarList) {
        for (URL url : urls) {
            boolean isValidURL;
            String urlProtocol = url.getProtocol();
            boolean bl = isValidURL = urlProtocol.equals("jar") || urlProtocol.equals("file");
            if (!isValidURL) {
                logger.warning("Unknown protocol " + urlProtocol);
                continue;
            }
            try {
                URL archive;
                DeploymentLoader deploymentLoader = new DeploymentLoader();
                Class<? extends DeploymentModule> moduleType = deploymentLoader.discoverModuleType(url, classLoader, requireDescriptors);
                if (!AppModule.class.isAssignableFrom(moduleType) && !EjbModule.class.isAssignableFrom(moduleType) && !PersistenceModule.class.isAssignableFrom(moduleType) && !ConnectorModule.class.isAssignableFrom(moduleType) && !ClientModule.class.isAssignableFrom(moduleType) || jarList.contains(archive = URLs.toFileUrl(url))) continue;
                jarList.add(archive);
                File file = URLs.toFile(archive);
                logger.info("Found " + moduleType.getSimpleName() + " in classpath: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warning("Unable to determine the module type of " + url.toExternalForm() + ": Exception: " + e.getMessage(), e);
            }
            catch (UnknownModuleTypeException ignore) {}
        }
    }

    static {
        try {
            lib = SystemInstance.get().getHome().getDirectory("lib", false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class DeploymentsConfigurationException
    extends RuntimeException {
        public DeploymentsConfigurationException(String message) {
            super(message);
        }
    }
}

