/**
 * Copyright (c) 2010-2015, Grill Balázs, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.testing.core;

import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.testing.core.api.MatchRecordEquivalence;
import org.eclipse.viatra.query.testing.core.internal.DefaultMatchRecordEquivalence;
import org.eclipse.viatra.query.testing.snapshot.MatchRecord;
import org.eclipse.viatra.query.testing.snapshot.MatchSetRecord;

/**
 * Difference descriptor for {@link MatchSetRecord} elements.
 */
@SuppressWarnings("all")
public class MatchSetRecordDiff {
  public MatchSetRecordDiff(final Set<MatchRecord> additions, final Set<MatchRecord> removals) {
    this.additions = additions;
    this.removals = removals;
  }

  private final Set<MatchRecord> additions;

  private final Set<MatchRecord> removals;

  public Set<MatchRecord> getAdditions() {
    return this.additions;
  }

  public Set<MatchRecord> getRemovals() {
    return this.removals;
  }

  public boolean isEmpty() {
    return (this.additions.isEmpty() && this.removals.isEmpty());
  }

  public static MatchSetRecordDiff compute(final MatchSetRecord expected, final MatchSetRecord actual) {
    DefaultMatchRecordEquivalence _defaultMatchRecordEquivalence = new DefaultMatchRecordEquivalence();
    return MatchSetRecordDiff.compute(expected, actual, _defaultMatchRecordEquivalence);
  }

  public static MatchSetRecordDiff compute(final MatchSetRecord expected, final MatchSetRecord actual, final MatchRecordEquivalence equivalence) {
    MatchSetRecordDiff _xblockexpression = null;
    {
      final HashSet<Equivalence.Wrapper<MatchRecord>> expectedSet = equivalence.wrap(expected.getMatches());
      final HashSet<Equivalence.Wrapper<MatchRecord>> actualSet = equivalence.wrap(actual.getMatches());
      final Sets.SetView<Equivalence.Wrapper<MatchRecord>> unexpected = Sets.<Equivalence.Wrapper<MatchRecord>>difference(actualSet, expectedSet);
      final Sets.SetView<Equivalence.Wrapper<MatchRecord>> missing = Sets.<Equivalence.Wrapper<MatchRecord>>difference(expectedSet, actualSet);
      HashSet<MatchRecord> _unwrap = equivalence.unwrap(unexpected);
      HashSet<MatchRecord> _unwrap_1 = equivalence.unwrap(missing);
      _xblockexpression = new MatchSetRecordDiff(_unwrap, _unwrap_1);
    }
    return _xblockexpression;
  }
}
