/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IDeltaBag;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FaithfulTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;

public class FaithfulParallelTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends FaithfulTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult, CumulativeAggregate<Domain, Accumulator>, FoldingState<Domain>>
implements ResumableNode {
    public FaithfulParallelTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
    }

    public FaithfulParallelTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, int aggregatedColumn) {
        this(reteContainer, operator, groupMask, TupleMask.selectSingle((int)aggregatedColumn, (int)groupMask.sourceWidth));
    }

    @Override
    protected Map<AggregateResult, Diff<Timestamp>> doFoldingStep(Tuple group, FoldingState<Domain> state, Timestamp timestamp) {
        Object aggregate = this.getAggregate(group, timestamp);
        if (state.delta.isEmpty()) {
            this.gcAggregates((CumulativeAggregate<Domain, Accumulator>)aggregate, group, timestamp);
            return Collections.emptyMap();
        }
        Map diffMap = CollectionsFactory.createMap();
        Timestamp nextTimestamp = ((TreeMap)this.aggregates.get(group)).higherKey(timestamp);
        Object currentOldResult = this.operator.getAggregate(((CumulativeAggregate)aggregate).accumulator);
        for (Map.Entry entry : state.delta.entriesWithMultiplicities()) {
            boolean isInsertion = (Integer)entry.getValue() > 0;
            Object aggregand = entry.getKey();
            int i = 0;
            while (i < Math.abs((Integer)entry.getValue())) {
                ((CumulativeAggregate)aggregate).accumulator = this.operator.update(((CumulativeAggregate)aggregate).accumulator, aggregand, isInsertion);
                ++i;
            }
        }
        Object currentNewResult = this.operator.getAggregate(((CumulativeAggregate)aggregate).accumulator);
        if (!Objects.equals(currentOldResult, currentNewResult)) {
            FaithfulParallelTimelyColumnAggregatorNode.appendDiff(currentOldResult, (Signed<Timestamp>)new Signed(Direction.DELETE, (Comparable)timestamp), diffMap);
            if (nextTimestamp != null) {
                FaithfulParallelTimelyColumnAggregatorNode.appendDiff(currentOldResult, (Signed<Timestamp>)new Signed(Direction.INSERT, (Comparable)nextTimestamp), diffMap);
            }
            FaithfulParallelTimelyColumnAggregatorNode.appendDiff(currentNewResult, (Signed<Timestamp>)new Signed(Direction.INSERT, (Comparable)timestamp), diffMap);
            if (nextTimestamp != null) {
                FaithfulParallelTimelyColumnAggregatorNode.appendDiff(currentNewResult, (Signed<Timestamp>)new Signed(Direction.DELETE, (Comparable)nextTimestamp), diffMap);
            }
        }
        this.gcAggregates((CumulativeAggregate<Domain, Accumulator>)aggregate, group, timestamp);
        this.updateTimeline(group, diffMap);
        if (nextTimestamp != null) {
            FoldingState newState = new FoldingState();
            newState.delta = state.delta;
            this.addFoldingState(group, newState, nextTimestamp);
        }
        return diffMap;
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregand = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Object aggregate = this.getAggregate(group, timestamp);
        FoldingState state = new FoldingState();
        if (isInsertion) {
            ((CumulativeAggregate)aggregate).aggregands.addOne(aggregand);
            state.delta.addOne(aggregand);
        } else {
            ((CumulativeAggregate)aggregate).aggregands.removeOne(aggregand);
            state.delta.removeOne(aggregand);
        }
        this.addFoldingState(group, state, timestamp);
    }

    @Override
    protected void gcAggregates(CumulativeAggregate<Domain, Accumulator> aggregate, Tuple group, Timestamp timestamp) {
        if (aggregate.aggregands.isEmpty()) {
            TreeMap groupAggregates = (TreeMap)this.aggregates.get(group);
            groupAggregates.remove(timestamp);
            if (groupAggregates.isEmpty()) {
                this.aggregates.remove(group);
            }
        }
    }

    @Override
    protected CumulativeAggregate<Domain, Accumulator> getAggregate(Tuple group, Timestamp timestamp) {
        TreeMap groupAggregates = this.aggregates.computeIfAbsent(group, k -> CollectionsFactory.createTreeMap());
        return groupAggregates.computeIfAbsent(timestamp, k -> {
            CumulativeAggregate aggregate = new CumulativeAggregate();
            Map.Entry lowerEntry = groupAggregates.lowerEntry(timestamp);
            aggregate.accumulator = lowerEntry == null ? this.operator.createNeutral() : this.operator.clone(((CumulativeAggregate)lowerEntry.getValue()).accumulator);
            return aggregate;
        });
    }

    @Override
    public AggregateResult getAggregateResult(Tuple group) {
        TreeMap groupAggregates = (TreeMap)this.aggregates.get(group);
        if (groupAggregates != null) {
            Map.Entry lastEntry = groupAggregates.lastEntry();
            return (AggregateResult)this.operator.getAggregate(((CumulativeAggregate)lastEntry.getValue()).accumulator);
        }
        return (AggregateResult)this.NEUTRAL;
    }

    protected static class CumulativeAggregate<Domain, Accumulator> {
        protected Accumulator accumulator;
        protected IDeltaBag<Domain> aggregands = CollectionsFactory.createDeltaBag();

        protected CumulativeAggregate() {
        }

        public String toString() {
            return "accumulator=" + String.valueOf(this.accumulator) + " aggregands=" + String.valueOf(this.aggregands);
        }
    }

    protected static class FoldingState<Domain>
    implements FaithfulTimelyColumnAggregatorNode.MergeableFoldingState<FoldingState<Domain>> {
        protected IDeltaBag<Domain> delta = CollectionsFactory.createDeltaBag();

        protected FoldingState() {
        }

        public String toString() {
            return "delta=" + String.valueOf(this.delta);
        }

        @Override
        public FoldingState<Domain> merge(FoldingState<Domain> that) {
            Preconditions.checkArgument((that != null ? 1 : 0) != 0);
            FoldingState<Domain> result = new FoldingState<Domain>();
            this.delta.forEachEntryWithMultiplicities((d, m) -> {
                boolean bl = foldingState.delta.addSigned(d, m.intValue());
            });
            that.delta.forEachEntryWithMultiplicities((d, m) -> {
                boolean bl = foldingState.delta.addSigned(d, m.intValue());
            });
            return result;
        }
    }
}

