/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class IterateOverEStructuralFeatureInstances
implements IIteratingSearchOperation {
    private final EStructuralFeature feature;
    private final int sourcePosition;
    private final int targetPosition;
    private final EStructuralFeatureInstancesKey type;
    private static final TupleMask indexerMask = TupleMask.empty((int)2);

    public IterateOverEStructuralFeatureInstances(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.type = new EStructuralFeatureInstancesKey(feature);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + variableMapping.apply(this.sourcePosition) + ", -" + variableMapping.apply(this.targetPosition) + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    private class Executor
    implements ISearchOperation.ISearchOperationExecutor {
        private Iterator<Tuple> it;

        private Executor() {
        }

        @Override
        public void onBacktrack(MatchingFrame frame, ISearchContext context) {
            frame.setValue(IterateOverEStructuralFeatureInstances.this.sourcePosition, null);
            frame.setValue(IterateOverEStructuralFeatureInstances.this.targetPosition, null);
            this.it = null;
        }

        @Override
        public void onInitialize(MatchingFrame frame, ISearchContext context) {
            Iterable tuples = context.getRuntimeContext().enumerateTuples((IInputKey)IterateOverEStructuralFeatureInstances.this.type, indexerMask, (ITuple)Tuples.staticArityFlatTupleOf());
            this.it = tuples.iterator();
        }

        @Override
        public boolean execute(MatchingFrame frame, ISearchContext context) {
            if (this.it.hasNext()) {
                Tuple next = this.it.next();
                frame.setValue(IterateOverEStructuralFeatureInstances.this.sourcePosition, next.get(0));
                frame.setValue(IterateOverEStructuralFeatureInstances.this.targetPosition, next.get(1));
                return true;
            }
            return false;
        }

        @Override
        public ISearchOperation getOperation() {
            return IterateOverEStructuralFeatureInstances.this;
        }
    }
}

