/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;

public class ExpressionCheck
implements ISearchOperation {
    IExpressionEvaluator evaluator;
    Map<String, Integer> nameMap;

    public ExpressionCheck(IExpressionEvaluator evaluator, Map<String, Integer> nameMap) {
        this.evaluator = evaluator;
        this.nameMap = nameMap;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return new ArrayList<Integer>(this.nameMap.values());
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     expression " + this.evaluator.getShortDescription();
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            try {
                boolean result = (Boolean)ExpressionCheck.this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, ExpressionCheck.this.nameMap));
                return result;
            }
            catch (Exception e) {
                context.getLogger().warn((Object)"Error while evaluating expression", (Throwable)e);
                return false;
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return ExpressionCheck.this;
        }
    }
}

