/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;

public class PParameter {
    private final String name;
    private final String typeName;
    private final IInputKey declaredUnaryType;
    private final PParameterDirection direction;

    public PParameter(String name) {
        this(name, null);
    }

    public PParameter(String name, String typeName) {
        this(name, typeName, null);
    }

    public PParameter(String name, String typeName, IInputKey declaredUnaryType) {
        this(name, typeName, declaredUnaryType, PParameterDirection.INOUT);
    }

    public PParameter(String name, String typeName, IInputKey declaredUnaryType, PParameterDirection direction) {
        this.name = name;
        this.typeName = typeName;
        this.declaredUnaryType = declaredUnaryType;
        this.direction = direction;
        if (declaredUnaryType != null && declaredUnaryType.getArity() != 1) {
            throw new IllegalArgumentException("PParameter declared type must be unary instead of " + declaredUnaryType.getPrettyPrintableName());
        }
    }

    public PParameterDirection getDirection() {
        return this.direction;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public IInputKey getDeclaredUnaryType() {
        return this.declaredUnaryType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PParameter) {
            return Objects.equals(this.name, ((PParameter)obj).name) && Objects.equals(this.typeName, ((PParameter)obj).typeName) && Objects.equals(this.declaredUnaryType, ((PParameter)obj).declaredUnaryType) && Objects.equals((Object)this.direction, (Object)((PParameter)obj).direction);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeName, this.declaredUnaryType);
    }
}

