/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.breakpoint.RuleBreakpoint;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.util.ViatraDebuggerUtil;

public class AddRuleBreakpointHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof TransformationState) {
                TransformationState state = (TransformationState)((IStructuredSelection)selection).getFirstElement();
                TransformationThread thread = ViatraDebuggerUtil.getThread((TransformationState)state);
                InputDialog dialog = new InputDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), "Create Rule Breakpoint", "Set Transformation Rule Id", "", null);
                dialog.open();
                String ruleId = dialog.getValue();
                if (thread != null && dialog.getReturnCode() == 0) {
                    RuleBreakpoint breakpoint = new RuleBreakpoint(ruleId);
                    breakpoint.setMarker(thread.getTransformationType().getResource().createMarker(breakpoint.getMarkerIdentifier()));
                    breakpoint.setEnabled(true);
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
                }
            }
        }
        catch (CoreException e) {
            throw new ExecutionException("Error while adding rule breakpoint", (Throwable)e);
        }
        return null;
    }
}

