/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import com.google.common.collect.LinkedHashMultimap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveTraceFromExperimentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Shell shell = window.getShell();
        MessageDialog dialog = new MessageDialog(shell, Messages.RemoveDialog_Title, null, Messages.RemoveTraceFromExperimentHandler_Message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        if (dialog.open() != 0) {
            return null;
        }
        IRunnableWithProgress operation = monitor -> {
            LinkedHashMultimap tracesToRemove = LinkedHashMultimap.create();
            LinkedHashSet<TmfExperimentElement> experiments = new LinkedHashSet<TmfExperimentElement>();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof TmfTraceElement)) continue;
                TmfTraceElement traceElement = (TmfTraceElement)element;
                tracesToRemove.put((Object)traceElement.getProject(), (Object)traceElement);
                if (!(traceElement.getParent() instanceof TmfExperimentElement)) continue;
                experiments.add((TmfExperimentElement)traceElement.getParent());
            }
            monitor.setTaskName(Messages.CloseTraces_TaskName);
            experiments.forEach(experiment -> Display.getDefault().syncExec(experiment::closeEditors));
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)tracesToRemove.size());
            subMon.setTaskName(Messages.RemoveTraceFromExperimentHandler_TaskName);
            for (Map.Entry entry : tracesToRemove.asMap().entrySet()) {
                IProject project = ((TmfProjectElement)entry.getKey()).getResource();
                try {
                    ResourcesPlugin.getWorkspace().run(mon -> {
                        for (TmfTraceElement traceElement : (Collection)entry.getValue()) {
                            traceElement.delete((IProgressMonitor)subMon.split(1), false, false);
                        }
                        subMon.subTask("");
                    }, (ISchedulingRule)project, 1, null);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(Messages.RemoveTraceFromExperimentHandler_Error, e.getTargetException().toString(), e.getTargetException());
        }
        return null;
    }
}

