/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.eclipse.urischeme.internal.registration.IWinRegistry;
import org.eclipse.urischeme.internal.registration.WinRegistryException;

public class WinRegistry
implements IWinRegistry {
    @Override
    public void setValueForKey(String key, String attribute, String value) throws WinRegistryException {
        try {
            Advapi32Util.registryCreateKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key);
        }
        catch (LastErrorException e) {
            throw new WinRegistryException("Unable to create registry key. Key=" + key);
        }
        try {
            Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)attribute, (String)value);
        }
        catch (LastErrorException e) {
            throw new WinRegistryException("Unable to set registry value. Key=" + key + ", name=" + attribute + ", value=" + value, e);
        }
    }

    @Override
    public String getValueForKey(String key, String attribute) throws WinRegistryException {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)attribute);
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() == 2 || e.getErrorCode() == 3) {
                return null;
            }
            throw new WinRegistryException("Unable to read registry value. Key=" + key + ", name=" + attribute, e);
        }
    }

    @Override
    public void deleteKey(String key) throws WinRegistryException {
        try {
            Advapi32Util.registryDeleteKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key);
        }
        catch (LastErrorException e) {
            throw new WinRegistryException("Unable to delete registry key. Key=" + key, e);
        }
    }
}

