/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.ui.markers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context.ContextDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

public class ContextMarkers
implements IMarkerEventSource {
    private static final RGBA ONE_TRUE_COLOUR = new RGBA(44, 33, 88, 93);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull String> getMarkerCategories() {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activeTrace == null) {
            return Collections.emptyList();
        }
        ContextDataProvider dataProvider = (ContextDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(activeTrace, "org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context.dataprovider", ContextDataProvider.class);
        if (dataProvider == null) {
            return Collections.emptyList();
        }
        @NonNull @NonNull TmfModelResponse tree = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(Collections.emptyList())), (IProgressMonitor)new NullProgressMonitor());
        @NonNull TmfTreeModel model = (TmfTreeModel)tree.getModel();
        if (model == null) {
            return Collections.emptyList();
        }
        HashSet<String> data = new HashSet<String>();
        for (TmfTreeDataModel elem : model.getEntries()) {
            data.add(elem.getName());
        }
        ArrayList dataList = Lists.newArrayList(data);
        dataList.sort(null);
        return dataList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull IMarkerEvent> getMarkerList(@NonNull String category, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activeTrace == null) {
            return Collections.emptyList();
        }
        ContextDataProvider dataProvider = (ContextDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(activeTrace, "org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context.dataprovider", ContextDataProvider.class);
        if (dataProvider == null) {
            return Collections.emptyList();
        }
        @NonNull @NonNull TmfModelResponse tree = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(Collections.emptyList())), monitor);
        @NonNull TmfTreeModel treeModels = (TmfTreeModel)tree.getModel();
        if (treeModels == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TmfTreeDataModel treeModel : treeModels.getEntries()) {
            if (!treeModel.getName().startsWith(category)) continue;
            ids.add(treeModel.getId());
        }
        @NonNull TmfModelResponse res = dataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(startTime, endTime, (int)Math.max(2.0, ((double)endTime - (double)startTime) / (double)resolution), ids)), monitor);
        TimeGraphModel rowModels = (TimeGraphModel)res.getModel();
        if (rowModels == null || rowModels.getRows().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IMarkerEvent> events = new ArrayList<IMarkerEvent>();
        for (ITimeGraphRowModel rowModel : rowModels.getRows()) {
            for (ITimeGraphState model : rowModel.getStates()) {
                if (!(model instanceof ContextDataProvider.MarkerModel)) continue;
                events.add((IMarkerEvent)new MarkerEvent(null, model.getStartTime(), model.getDuration(), ((ContextDataProvider.MarkerModel)model).getCategory(), ONE_TRUE_COLOUR, model.getLabel(), true));
            }
        }
        return events;
    }
}

