/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.model.ITokenizationSupport;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.TokenizationResult;

public class TMTokenizationSupport
implements ITokenizationSupport {
    private final IGrammar _grammar;
    private final IStateStack _initialState;
    private final DecodeMap decodeMap = new DecodeMap();
    private final BiFunction<DecodeMap, List<String>, String> decodeTextMateTokenCached = new BiFunction<DecodeMap, List<String>, String>(){
        private static final long EXPIRE_AFTER_ACCESS_MS = 5000L;
        private final Map<List<String>, CacheEntry> cache = new HashMap<List<String>, CacheEntry>();
        private long lastCacheCleanup = System.currentTimeMillis();

        @Override
        public String apply(DecodeMap decodeMap, List<String> scopes) {
            long now;
            CacheEntry entry = this.cache.computeIfAbsent(scopes, s -> new CacheEntry(TMTokenizationSupport.this.decodeTextMateToken(decodeMap, (List<String>)s)));
            entry.lastAccessed = now = System.currentTimeMillis();
            if (now - this.lastCacheCleanup > 5000L) {
                this.lastCacheCleanup = now;
                this.cache.values().removeIf(e -> now - e.lastAccessed > 5000L);
            }
            return entry.tokenType;
        }

        static final class CacheEntry {
            final String tokenType;
            long lastAccessed;

            CacheEntry(String tokenType) {
                this.tokenType = tokenType;
            }
        }
    };

    public TMTokenizationSupport(IGrammar grammar) {
        this(grammar, StateStack.NULL);
    }

    public TMTokenizationSupport(IGrammar grammar, IStateStack initialState) {
        this._grammar = grammar;
        this._initialState = initialState;
    }

    @Override
    public IStateStack getInitialState() {
        return this._initialState;
    }

    @Override
    public TokenizationResult tokenize(String line, @Nullable IStateStack state) {
        return this.tokenize(line, state, null, null);
    }

    @Override
    public TokenizationResult tokenize(String line, @Nullable IStateStack state, @Nullable Integer offsetDeltaOrNull, @Nullable Duration timeLimit) {
        int offsetDelta = offsetDeltaOrNull == null ? 0 : offsetDeltaOrNull;
        ITokenizeLineResult<IToken[]> tokenizationResult = this._grammar.tokenizeLine(line, state, timeLimit);
        IToken[] tokens = tokenizationResult.getTokens();
        ArrayList<TMToken> tmTokens = new ArrayList<TMToken>(tokens.length < 10 ? tokens.length : 10);
        String lastTokenType = null;
        IToken[] iTokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken token = iTokenArray[n2];
            String tokenType = this.decodeTextMateTokenCached.apply(this.decodeMap, token.getScopes());
            if (!tokenType.equals(lastTokenType)) {
                int tokenStartIndex = token.getStartIndex();
                tmTokens.add(new TMToken(tokenStartIndex + offsetDelta, tokenType));
                lastTokenType = tokenType;
            }
            ++n2;
        }
        IToken lastToken = tokens[tokens.length - 1];
        return new TokenizationResult(tmTokens, offsetDelta + Math.min(line.length(), lastToken.getEndIndex()), tokenizationResult.getRuleStack(), tokenizationResult.isStoppedEarly());
    }

    /*
     * Unable to fully structure code
     */
    private String decodeTextMateToken(DecodeMap decodeMap, List<String> scopes) {
        prevTokenScopes = decodeMap.prevToken.scopes;
        prevTokenScopesLength = prevTokenScopes.size();
        prevTokenScopeTokensMaps = decodeMap.prevToken.scopeTokensMaps;
        scopeTokensMaps = new HashMap<Integer, Map<Integer, Boolean>>();
        prevScopeTokensMaps = new HashMap<Integer, Boolean>();
        sameAsPrev = true;
        level = 1;
        while (level < scopes.size()) {
            scope = scopes.get(level);
            if (!sameAsPrev) ** GOTO lbl17
            if (level < prevTokenScopesLength && prevTokenScopes.get(level).equals(scope)) {
                prevScopeTokensMaps = prevTokenScopeTokensMaps.get(level);
                scopeTokensMaps.put(level, prevScopeTokensMaps);
            } else {
                sameAsPrev = false;
lbl17:
                // 2 sources

                tokens = decodeMap.getTokenIds(scope);
                prevScopeTokensMaps = new HashMap<Integer, Boolean>(prevScopeTokensMaps);
                var15_15 = tokens;
                var14_14 = tokens.length;
                var13_13 = 0;
                while (var13_13 < var14_14) {
                    token = var15_15[var13_13];
                    prevScopeTokensMaps.put(token, true);
                    ++var13_13;
                }
                scopeTokensMaps.put(level, prevScopeTokensMaps);
            }
            ++level;
        }
        decodeMap.prevToken = new TMTokenDecodeData(scopes, scopeTokensMaps);
        return decodeMap.getToken(prevScopeTokensMaps);
    }

    @NonNullByDefault(value={})
    private static final class DecodeMap {
        private int lastAssignedTokenId = 0;
        private final Map<String, Integer[]> scopeToTokenIds = new HashMap<String, Integer[]>();
        private final Map<String, Integer> tokenToTokenId = new HashMap<String, Integer>();
        private final List<String> tokenIdToToken = MoreCollections.asArrayList("element-at-index-zero-is-unused");
        TMTokenDecodeData prevToken = new TMTokenDecodeData(Collections.emptyList(), Collections.emptyMap());

        private DecodeMap() {
        }

        Integer[] getTokenIds(String scope) {
            Integer[] tokens = this.scopeToTokenIds.get(scope);
            if (tokens != null) {
                return tokens;
            }
            String[] tmpTokens = StringUtils.splitToArray(scope, '.');
            tokens = new Integer[tmpTokens.length];
            int i = 0;
            while (i < tmpTokens.length) {
                String token = tmpTokens[i];
                Integer tokenId = this.tokenToTokenId.get(token);
                if (tokenId == null) {
                    tokenId = ++this.lastAssignedTokenId;
                    this.tokenToTokenId.put(token, tokenId);
                    this.tokenIdToToken.add(token);
                }
                tokens[i] = tokenId;
                ++i;
            }
            this.scopeToTokenIds.put(scope, tokens);
            return tokens;
        }

        String getToken(Map<Integer, Boolean> tokenMap) {
            StringBuilder result = new StringBuilder();
            boolean isFirst = true;
            int i = 1;
            while (i <= this.lastAssignedTokenId) {
                if (tokenMap.containsKey(i)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        result.append('.');
                    }
                    result.append(this.tokenIdToToken.get(i));
                }
                ++i;
            }
            return result.toString();
        }
    }

    @NonNullByDefault(value={})
    private record TMTokenDecodeData(@NonNull List<String> scopes, @NonNull Map<Integer, Map<Integer, Boolean>> scopeTokensMaps) {
    }
}

