/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.OnEnterRule;
import org.eclipse.tm4e.languageconfiguration.internal.utils.RegExpUtils;

public class OnEnterSupport {
    private static final List<CharacterPair> DEFAULT_BRACKETS = List.of(new CharacterPair("(", ")"), new CharacterPair("{", "}"), new CharacterPair("[", "]"));
    private final List<ProcessedBracketPair> brackets;
    private final List<OnEnterRule> regExpRules;

    public OnEnterSupport(@Nullable List<CharacterPair> brackets, @Nullable List<OnEnterRule> regExpRules) {
        this.brackets = (brackets != null ? brackets : DEFAULT_BRACKETS).stream().filter(Objects::nonNull).map(characterPair -> new ProcessedBracketPair((CharacterPair)characterPair)).toList();
        this.regExpRules = regExpRules != null ? regExpRules : Collections.emptyList();
    }

    public @Nullable EnterAction onEnter(String beforeEnterText, String afterEnterText) {
        for (OnEnterRule rule : this.regExpRules) {
            Pattern beforeText = rule.beforeText;
            if (!beforeText.matcher(beforeEnterText).find()) continue;
            Pattern afterText = rule.afterText;
            if (afterText != null) {
                if (!afterText.matcher(afterEnterText).find()) continue;
                return rule.action;
            }
            return rule.action;
        }
        if (!beforeEnterText.isEmpty() && !afterEnterText.isEmpty()) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText) || !bracket.matchClose(afterEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.IndentOutdent);
            }
        }
        if (!beforeEnterText.isEmpty()) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.Indent);
            }
        }
        return null;
    }

    private static final class ProcessedBracketPair {
        private static final Pattern B_REGEXP = Pattern.compile("\\B");
        private final @Nullable Pattern openRegExp;
        private final @Nullable Pattern closeRegExp;

        private ProcessedBracketPair(CharacterPair charPair) {
            this.openRegExp = ProcessedBracketPair.createOpenBracketRegExp(charPair.open);
            this.closeRegExp = ProcessedBracketPair.createCloseBracketRegExp(charPair.close);
        }

        private boolean matchOpen(String beforeEnterText) {
            return this.openRegExp != null && this.openRegExp.matcher(beforeEnterText).find();
        }

        private boolean matchClose(String afterEnterText) {
            return this.closeRegExp != null && this.closeRegExp.matcher(afterEnterText).find();
        }

        private static @Nullable Pattern createOpenBracketRegExp(String bracket) {
            StringBuilder str = new StringBuilder(RegExpUtils.escapeRegExpCharacters(bracket));
            String c = String.valueOf(str.charAt(0));
            if (!B_REGEXP.matcher(c).find()) {
                str.insert(0, "\\b");
            }
            str.append("\\s*$");
            return RegExpUtils.create(str.toString());
        }

        private static @Nullable Pattern createCloseBracketRegExp(String bracket) {
            StringBuilder str = new StringBuilder(RegExpUtils.escapeRegExpCharacters(bracket));
            String c = String.valueOf(str.charAt(str.length() - 1));
            if (!B_REGEXP.matcher(c).find()) {
                str.append("\\b");
            }
            str.insert(0, "^\\s*");
            return RegExpUtils.create(str.toString());
        }
    }
}

