/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleLineCommentHandler
extends AbstractHandler {
    public static final String TOGGLE_LINE_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand";
    public static final String ADD_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand";
    public static final String REMOVE_BLOCK_COMMENT_COMMAND_ID = "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand";

    private static <T> @Nullable T adapt(@Nullable Object sourceObject, Class<T> adapter) {
        return (T)Adapters.adapt((Object)sourceObject, adapter);
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        block51: {
            if (event == null) {
                return null;
            }
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            ITextEditor editor = ToggleLineCommentHandler.adapt(part, ITextEditor.class);
            if (editor == null) {
                return null;
            }
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection var5_6)) break block51;
            IEditorInput input = editor.getEditorInput();
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null || input == null) {
                return null;
            }
            IDocument document = docProvider.getDocument((Object)input);
            if (document == null) {
                return null;
            }
            try {
                info = ContentTypeHelper.findContentTypes((IDocument)document);
                if (info == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                return null;
            }
            IContentType[] contentTypes = info.getContentTypes();
            Command command = event.getCommand();
            CommentSupport commentSupport = ToggleLineCommentHandler.getCommentSupport(contentTypes);
            if (commentSupport == null) {
                return null;
            }
            if (!this.isValid(commentSupport, command)) {
                return null;
            }
            IRewriteTarget target = ToggleLineCommentHandler.adapt(editor, IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    switch (command.getId()) {
                        case "org.eclipse.tm4e.languageconfiguration.toggleLineCommentCommand": {
                            String lineComment = commentSupport.getLineComment();
                            if (lineComment != null && !lineComment.isEmpty()) {
                                ToggleLineCommentHandler.updateLineComment(document, textSelection, lineComment, editor);
                                break;
                            }
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null && !blockComment.open.isEmpty() && !blockComment.close.isEmpty()) {
                                ITextSelection expandedSelection = ToggleLineCommentHandler.expandTextSelectionToFullyIncludeCommentParts(document, textSelection, blockComment.open, blockComment.close);
                                int shiftOffset = expandedSelection.getOffset() - textSelection.getOffset();
                                int shiftLength = 0;
                                Set<Integer> lines = ToggleLineCommentHandler.computeLines(textSelection, document);
                                int selectionStartLine = textSelection.getStartLine();
                                int selectionEndLine = textSelection.getEndLine();
                                int[] lineRange = new int[]{-1, -1};
                                lines = lines.stream().filter(l -> l >= selectionStartLine && l <= selectionEndLine && !TextUtils.isBlankLine(document, l)).map(l -> {
                                    nArray[0] = lineRange[0] == -1 || lineRange[0] > l ? l : lineRange[0];
                                    nArray[1] = lineRange[1] < l ? l : lineRange[1];
                                    return l;
                                }).collect(Collectors.toSet());
                                int first = lineRange[0];
                                boolean isToAdd = false;
                                for (int line : lines) {
                                    Set<ITypedRegion> existingBlocks = this.getBlockCommentPartsForLine(document, line, blockComment.open, blockComment.close);
                                    if (line == first) {
                                        isToAdd = existingBlocks.isEmpty();
                                    }
                                    int deletedChars = 0;
                                    for (ITypedRegion existingBlock : existingBlocks) {
                                        existingBlock = new TypedRegion(existingBlock.getOffset() - deletedChars, existingBlock.getLength(), existingBlock.getType());
                                        document.replace(existingBlock.getOffset(), existingBlock.getLength(), "");
                                        deletedChars += existingBlock.getLength();
                                        int selectionStart = textSelection.getOffset() + shiftOffset;
                                        int selectionLength = textSelection.getLength() + shiftLength;
                                        int selectionEnd = selectionStart + selectionLength;
                                        if (ToggleLineCommentHandler.isBeforeSelection((IRegion)existingBlock, selectionStart)) {
                                            shiftOffset -= existingBlock.getLength();
                                            continue;
                                        }
                                        if (!ToggleLineCommentHandler.isInsideSelection((IRegion)existingBlock, selectionStart, selectionEnd)) continue;
                                        shiftLength -= existingBlock.getLength();
                                    }
                                }
                                textSelection = new TextSelection(textSelection.getOffset() + shiftOffset, textSelection.getLength() + shiftLength);
                                shiftLength = 0;
                                shiftOffset = 0;
                                if (isToAdd) {
                                    int last = lineRange[1];
                                    for (int line : lines) {
                                        int lineOffset = document.getLineOffset(line);
                                        int lineLength = document.getLineLength(line);
                                        String lineDelimiter = document.getLineDelimiter(line);
                                        TextSelection range = new TextSelection(document, lineOffset, lineDelimiter != null ? lineLength - lineDelimiter.length() : lineLength);
                                        ToggleLineCommentHandler.addBlockComment(document, (ITextSelection)range, blockComment.open, blockComment.close);
                                        if (line == first) {
                                            if (range.getOffset() <= textSelection.getOffset()) {
                                                shiftOffset += blockComment.open.length();
                                            }
                                            if (range.getOffset() + range.getLength() < textSelection.getOffset() + textSelection.getLength()) {
                                                shiftLength += blockComment.close.length();
                                            }
                                        }
                                        if (line == last && line != first) {
                                            int thisShiftLength = shiftLength;
                                            if (range.getOffset() <= textSelection.getOffset() + shiftOffset + textSelection.getLength() + thisShiftLength) {
                                                shiftLength += blockComment.open.length();
                                            }
                                            if (range.getOffset() + range.getLength() < textSelection.getOffset() + shiftOffset + textSelection.getLength() + thisShiftLength) {
                                                shiftLength += blockComment.close.length();
                                            }
                                        }
                                        if (line == first || line == last) continue;
                                        shiftLength += blockComment.open.length() + blockComment.close.length();
                                    }
                                    textSelection = new TextSelection(textSelection.getOffset() + shiftOffset, textSelection.getLength() + shiftLength);
                                }
                                editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.addBlockCommentCommand": {
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null && !blockComment.open.isEmpty() && !blockComment.close.isEmpty()) {
                                if (!ToggleLineCommentHandler.isInsideBlockComment(document, textSelection, blockComment.open, blockComment.close)) {
                                    textSelection = ToggleLineCommentHandler.removeBlockComments(document, textSelection, blockComment.open, blockComment.close);
                                    textSelection = ToggleLineCommentHandler.addBlockComment(document, textSelection, blockComment.open, blockComment.close);
                                    editor.selectAndReveal(textSelection.getOffset(), 0);
                                }
                            } else {
                                String lineComment = commentSupport.getLineComment();
                                if (lineComment != null && !lineComment.isEmpty()) {
                                    ToggleLineCommentHandler.updateLineComment(document, textSelection, lineComment, editor);
                                }
                            }
                            break;
                        }
                        case "org.eclipse.tm4e.languageconfiguration.removeBlockCommentCommand": {
                            CharacterPair blockComment = commentSupport.getBlockComment();
                            if (blockComment != null && !blockComment.open.isEmpty() && !blockComment.close.isEmpty()) {
                                textSelection = ToggleLineCommentHandler.removeBlockComments(document, textSelection, blockComment.open, blockComment.close);
                                editor.selectAndReveal(textSelection.getOffset(), 0);
                                break;
                            }
                            String lineComment = commentSupport.getLineComment();
                            if (lineComment == null || lineComment.isEmpty()) break;
                            ToggleLineCommentHandler.updateLineComment(document, textSelection, lineComment, editor);
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        return null;
    }

    private static boolean isBeforeSelection(IRegion region, int selectionStart) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return regionStart < selectionStart && regionEnd <= selectionStart;
    }

    private static @Nullable ITypedRegion findCommentPartAtOffset(IDocument document, int offset, String part) throws BadLocationException {
        int length = document.getLength();
        int i = offset - 1;
        while (i >= 0 && i >= offset - part.length()) {
            if (length >= i + part.length()) {
                String text = document.get(i, part.length());
                if (part.indexOf(text.charAt(0)) == -1) {
                    return null;
                }
                if (text.indexOf(part) == 0) {
                    return new TypedRegion(i, part.length(), part);
                }
            }
            --i;
        }
        return null;
    }

    private static boolean isInsideSelection(IRegion region, int selectionStart, int selectionEnd) {
        int regionStart = region.getOffset();
        int regionEnd = regionStart + region.getLength();
        return selectionStart <= regionStart && selectionEnd >= regionEnd;
    }

    private static Set<Integer> computeLines(ITextSelection textSelection, IDocument document) throws BadLocationException {
        if (textSelection instanceof IMultiTextSelection var3_3) {
            v0 = multiSelection.getRegions();
        } else {
            IRegion[] iRegionArray = new IRegion[1];
            v0 = iRegionArray;
            iRegionArray[0] = new Region(textSelection.getOffset(), textSelection.getLength());
        }
        IRegion[] regions = v0;
        HashSet<Integer> lines = new HashSet<Integer>();
        IRegion[] iRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion region = iRegionArray[n2];
            int lineFrom = document.getLineOfOffset(region.getOffset());
            int lineTo = document.getLineOfOffset(region.getOffset() + region.getLength());
            int line = lineFrom;
            while (line <= lineTo) {
                lines.add(line);
                ++line;
            }
            ++n2;
        }
        return lines;
    }

    private boolean isValid(CommentSupport commentSupport, Command command) {
        String lineComment = commentSupport.getLineComment();
        CharacterPair blockComment = commentSupport.getBlockComment();
        if ((lineComment == null || lineComment.isEmpty()) && (blockComment == null || blockComment.open.isEmpty() || blockComment.close.isEmpty())) {
            return false;
        }
        return TOGGLE_LINE_COMMENT_COMMAND_ID.equals(command.getId()) || ADD_BLOCK_COMMENT_COMMAND_ID.equals(command.getId()) || REMOVE_BLOCK_COMMENT_COMMAND_ID.equals(command.getId());
    }

    private static @Nullable CommentSupport getCommentSupport(IContentType[] contentTypes) {
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CommentSupport commentSupport;
            IContentType contentType = iContentTypeArray[n2];
            if (registry.shouldComment(contentType) && (commentSupport = registry.getCommentSupport(contentType)) != null) {
                return commentSupport;
            }
            ++n2;
        }
        return null;
    }

    private static void updateLineComment(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        if (ToggleLineCommentHandler.areLinesCommented(document, selection, comment)) {
            ToggleLineCommentHandler.removeLineComments(document, selection, comment, editor);
        } else {
            ToggleLineCommentHandler.addLineComments(document, selection, comment, editor);
        }
    }

    private static boolean areLinesCommented(IDocument document, ITextSelection selection, String comment) throws BadLocationException {
        int lineNumber = selection.getStartLine();
        while (lineNumber <= selection.getEndLine()) {
            IRegion lineRegion = document.getLineInformation(lineNumber);
            if (!document.get(lineRegion.getOffset(), lineRegion.getLength()).trim().startsWith(comment)) {
                return false;
            }
            ++lineNumber;
        }
        return true;
    }

    private static Set<ITypedRegion> getBlockCommentParts(IDocument document, int offset, int length, String open, String close) throws BadLocationException {
        TreeSet<ITypedRegion> result = new TreeSet<ITypedRegion>((r1, r2) -> r1.getOffset() - r2.getOffset());
        String text = document.get(offset, length);
        int index = 0;
        while (true) {
            int indexOpen = text.indexOf(open, index);
            int indexClose = text.indexOf(close, index);
            if (indexOpen != -1 && (indexClose == -1 || indexOpen < indexClose)) {
                result.add((ITypedRegion)new TypedRegion(offset + indexOpen, open.length(), open));
                index = indexOpen + open.length();
                continue;
            }
            if (indexClose == -1) break;
            result.add((ITypedRegion)new TypedRegion(offset + indexClose, close.length(), close));
            index = indexClose + close.length();
        }
        return result;
    }

    private static ITextSelection expandTextSelectionToFullyIncludeCommentParts(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        int textSelectionStart = textSelection.getOffset();
        int textSelectionEnd = textSelectionStart + textSelection.getLength();
        ITypedRegion part = ToggleLineCommentHandler.findCommentPartAtOffset(document, textSelectionStart, open);
        if (part == null) {
            part = ToggleLineCommentHandler.findCommentPartAtOffset(document, textSelectionStart, close);
        }
        textSelectionStart = part != null ? part.getOffset() : textSelectionStart;
        part = ToggleLineCommentHandler.findCommentPartAtOffset(document, textSelectionEnd, open);
        if (part == null) {
            part = ToggleLineCommentHandler.findCommentPartAtOffset(document, textSelectionEnd, close);
        }
        textSelectionEnd = part != null ? part.getOffset() + part.getLength() : textSelectionEnd;
        return new TextSelection(document, textSelectionStart, textSelectionEnd - textSelectionStart);
    }

    private static boolean isInsideBlockComment(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        ITextSelection expandedSelection = ToggleLineCommentHandler.expandTextSelectionToFullyIncludeCommentParts(document, textSelection, open, close);
        String text = document.get(textSelection.getOffset(), textSelection.getLength());
        if (text.startsWith(open)) {
            return true;
        }
        return ToggleLineCommentHandler.findNotClosedOpen(document, expandedSelection, open, close) != null;
    }

    private static @Nullable ITypedRegion findNotClosedOpen(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        ITypedRegion comment;
        TreeSet<ITypedRegion> backOrderedBeforeSelectioonComments = new TreeSet<ITypedRegion>((r1, r2) -> r2.getOffset() - r1.getOffset());
        backOrderedBeforeSelectioonComments.addAll(ToggleLineCommentHandler.getBlockCommentParts(document, 0, textSelection.getOffset(), open, close));
        if (!backOrderedBeforeSelectioonComments.isEmpty() && open.equals((comment = (ITypedRegion)backOrderedBeforeSelectioonComments.first()).getType())) {
            return comment;
        }
        return null;
    }

    private static @Nullable ITypedRegion findNotOpenedClosen(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        int textSelectionEnd = textSelection.getOffset() + textSelection.getLength();
        Set<ITypedRegion> afterSelectioonComments = ToggleLineCommentHandler.getBlockCommentParts(document, textSelectionEnd, document.getLength() - textSelectionEnd, open, close);
        for (ITypedRegion comment : afterSelectioonComments) {
            if (!close.equals(comment.getType())) continue;
            return comment;
        }
        return null;
    }

    private static ITextSelection expandTextSelectionToSurroundingBlockComment(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        ITypedRegion prevOpenCommentPart;
        int textSelectionStart = textSelection.getOffset();
        int textSelectionEnd = textSelectionStart + textSelection.getLength();
        int selectionStartLine = document.getLineOfOffset(textSelectionStart);
        int selectionEndLine = document.getLineOfOffset(textSelectionEnd);
        int[] lineRange = new int[]{-1, -1};
        Set<Integer> lines = ToggleLineCommentHandler.computeLines((ITextSelection)new TextSelection(textSelectionStart, textSelectionEnd - textSelectionStart), document);
        lines = lines.stream().filter(l -> l >= selectionStartLine && l <= selectionEndLine && !TextUtils.isBlankLine(document, l)).map(l -> {
            nArray[0] = lineRange[0] == -1 || lineRange[0] > l ? l : lineRange[0];
            nArray[1] = lineRange[1] < l ? l : lineRange[1];
            return l;
        }).collect(Collectors.toSet());
        Set<ITypedRegion> comments = ToggleLineCommentHandler.getBlockCommentParts(document, textSelectionStart, textSelectionEnd - textSelectionStart, open, close);
        ITypedRegion[] brokenEnds = ToggleLineCommentHandler.findBrokenBlockCommentPart(comments, open, close);
        int newCommentStart = textSelectionStart;
        int newCommentEnd = textSelectionEnd;
        if (brokenEnds[0] != null) {
            ITypedRegion nextCloseCommentPart = ToggleLineCommentHandler.findNotOpenedClosen(document, textSelection, open, close);
            if (nextCloseCommentPart != null) {
                newCommentEnd = nextCloseCommentPart.getOffset() + nextCloseCommentPart.getLength();
            } else {
                int last = lineRange[1];
                newCommentEnd = document.getLineOffset(last) + document.getLineLength(last);
            }
        }
        if (brokenEnds[1] != null && (prevOpenCommentPart = ToggleLineCommentHandler.findNotClosedOpen(document, textSelection, open, close)) != null) {
            newCommentStart = prevOpenCommentPart.getOffset();
        }
        textSelectionStart = textSelectionStart > newCommentStart ? newCommentStart : textSelectionStart;
        textSelectionEnd = textSelectionEnd < newCommentEnd ? newCommentEnd : textSelectionEnd;
        return new TextSelection(document, textSelectionStart, textSelectionEnd - textSelectionStart);
    }

    private static ITypedRegion[] findBrokenBlockCommentPart(Set<ITypedRegion> blockCommentParts, String open, String close) {
        ITypedRegion[] brokenBlockComment = new ITypedRegion[2];
        blockCommentParts.stream().forEach(bc -> {
            if (open.equals(bc.getType())) {
                iTypedRegionArray[0] = bc;
            } else if (close.equals(bc.getType())) {
                if (brokenBlockComment[0] != null) {
                    iTypedRegionArray[0] = null;
                } else if (brokenBlockComment[1] == null) {
                    iTypedRegionArray[1] = bc;
                }
            }
        });
        return brokenBlockComment;
    }

    private Set<ITypedRegion> getBlockCommentPartsForLine(IDocument document, int line, String open, String close) throws BadLocationException {
        return ToggleLineCommentHandler.getBlockCommentParts(document, document.getLineOffset(line), document.getLineLength(line), open, close);
    }

    private static void removeLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        String oldText = document.get();
        int deletedChars = 0;
        boolean isStartBeforeComment = false;
        Set lines = ToggleLineCommentHandler.computeLines(selection, document).stream().filter(l -> l >= selection.getStartLine() && l <= selection.getEndLine()).collect(Collectors.toSet());
        boolean isFirstLineUpdated = false;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            int commentOffset = oldText.indexOf(comment, document.getLineOffset(lineNumber) + deletedChars);
            document.replace(commentOffset - deletedChars, comment.length(), "");
            deletedChars += comment.length();
            if (isFirstLineUpdated) continue;
            isFirstLineUpdated = true;
            boolean bl = isStartBeforeComment = commentOffset >= selection.getOffset();
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() - (isStartBeforeComment ? 0 : comment.length()), selection.getLength() - deletedChars + (isStartBeforeComment ? 0 : comment.length()));
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private static void addLineComments(IDocument document, ITextSelection selection, String comment, ITextEditor editor) throws BadLocationException {
        int insertedChars = 0;
        Set lines = ToggleLineCommentHandler.computeLines(selection, document).stream().filter(l -> l >= selection.getStartLine() && l <= selection.getEndLine()).collect(Collectors.toSet());
        boolean isFirstLineUpdated = false;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            document.replace(document.getLineOffset(lineNumber), 0, comment);
            if (isFirstLineUpdated) {
                insertedChars += comment.length();
                continue;
            }
            isFirstLineUpdated = true;
        }
        TextSelection newSelection = new TextSelection(selection.getOffset() + comment.length(), selection.getLength() + insertedChars);
        editor.selectAndReveal(newSelection.getOffset(), newSelection.getLength());
    }

    private static ITextSelection removeBlockComments(IDocument document, ITextSelection textSelection, String open, String close) throws BadLocationException {
        ITextSelection expandedSelection = ToggleLineCommentHandler.expandTextSelectionToFullyIncludeCommentParts(document, textSelection, open, close);
        int shiftOffset = expandedSelection.getOffset() - textSelection.getOffset();
        int shiftLength = 0;
        expandedSelection = ToggleLineCommentHandler.expandTextSelectionToSurroundingBlockComment(document, expandedSelection, open, close);
        Set<ITypedRegion> existingBlockParts = ToggleLineCommentHandler.getBlockCommentParts(document, expandedSelection.getOffset(), expandedSelection.getLength(), open, close);
        int deletedChars = 0;
        for (ITypedRegion existingBlock : existingBlockParts) {
            existingBlock = new TypedRegion(existingBlock.getOffset() - deletedChars, existingBlock.getLength(), existingBlock.getType());
            document.replace(existingBlock.getOffset(), existingBlock.getLength(), "");
            deletedChars += existingBlock.getLength();
            int selectionStart = textSelection.getOffset() + shiftOffset;
            int selectionLength = textSelection.getLength() + shiftLength;
            int selectionEnd = selectionStart + selectionLength;
            if (ToggleLineCommentHandler.isBeforeSelection((IRegion)existingBlock, selectionStart)) {
                shiftOffset -= existingBlock.getLength();
                continue;
            }
            if (!ToggleLineCommentHandler.isInsideSelection((IRegion)existingBlock, selectionStart, selectionEnd)) continue;
            shiftLength -= existingBlock.getLength();
        }
        return new TextSelection(textSelection.getOffset() + shiftOffset, textSelection.getLength() + shiftLength);
    }

    private static ITextSelection addBlockComment(IDocument document, ITextSelection selection, String open, String close) throws BadLocationException {
        document.replace(selection.getOffset(), 0, open);
        document.replace(selection.getOffset() + selection.getLength() + open.length(), 0, close);
        return new TextSelection(selection.getOffset() + open.length(), selection.getLength());
    }
}

