/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.registry.AbstractLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyLanguageConfigurationRegistryManager
extends AbstractLanguageConfigurationRegistryManager {
    private final ILanguageConfigurationRegistryManager manager;
    private @Nullable List<ILanguageConfigurationDefinition> added;
    private @Nullable List<ILanguageConfigurationDefinition> removed;

    public WorkingCopyLanguageConfigurationRegistryManager(ILanguageConfigurationRegistryManager manager) {
        ILanguageConfigurationDefinition[] definitions;
        this.manager = manager;
        ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = definitions = manager.getDefinitions();
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageConfigurationDefinition definition = iLanguageConfigurationDefinitionArray[n2];
            super.registerLanguageConfigurationDefinition(definition);
            ++n2;
        }
    }

    @Override
    public void registerLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.registerLanguageConfigurationDefinition(definition);
        List<ILanguageConfigurationDefinition> added = this.added;
        if (added == null) {
            added = this.added = new ArrayList<ILanguageConfigurationDefinition>();
        }
        added.add(definition);
    }

    @Override
    public void unregisterLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.unregisterLanguageConfigurationDefinition(definition);
        List<ILanguageConfigurationDefinition> removed = this.added;
        if (removed == null) {
            this.removed = new ArrayList<ILanguageConfigurationDefinition>();
            removed = this.removed;
        }
        if (this.added != null) {
            this.added.remove(definition);
        } else {
            removed.add(definition);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (this.removed != null) {
            for (ILanguageConfigurationDefinition definition : this.removed) {
                this.manager.unregisterLanguageConfigurationDefinition(definition);
            }
        }
        if (this.added != null) {
            for (ILanguageConfigurationDefinition definition : this.added) {
                this.manager.registerLanguageConfigurationDefinition(definition);
            }
        }
        if (this.added != null || this.removed != null) {
            this.manager.save();
        }
    }
}

