/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes.css;

import com.google.common.base.Splitter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.core.theme.css.CSSParser;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.themes.AbstractTokenProvider;
import org.eclipse.tm4e.ui.themes.ColorManager;

public class CSSTokenProvider
extends AbstractTokenProvider {
    private static final Splitter BY_DOT_SPLITTER = Splitter.on((char)'.');
    private final Map<IStyle, @Nullable IToken> tokenMaps = new HashMap<IStyle, IToken>();
    private @Nullable CSSParser parser;

    public CSSTokenProvider(InputStream in) {
        try {
            this.parser = new CSSParser(in);
            for (IStyle style : this.parser.getStyles()) {
                RGB color = style.getColor();
                if (color == null) continue;
                int s = 0;
                if (style.isBold()) {
                    s |= 1;
                }
                if (style.isItalic()) {
                    s |= 2;
                }
                if (style.isUnderline()) {
                    s |= 0x40000000;
                }
                if (style.isStrikeThrough()) {
                    s |= 0x20000000;
                }
                this.tokenMaps.put(style, (IToken)new Token((Object)new TextAttribute(ColorManager.getInstance().getColor(color), null, s)));
            }
        }
        catch (Exception e) {
            TMUIPlugin.log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public @Nullable IToken getToken(@Nullable String type) {
        if (type == null) {
            return null;
        }
        CSSParser parser = this.parser;
        if (parser == null) {
            return null;
        }
        IStyle style = parser.getBestStyle((String[])BY_DOT_SPLITTER.splitToStream((CharSequence)type).toArray(String[]::new));
        if (style == null) {
            return null;
        }
        return this.tokenMaps.get(style);
    }

    private @Nullable Color getColor(boolean isForeground, String ... styles) {
        RGB rgb;
        CSSParser parser = this.parser;
        if (parser == null) {
            return null;
        }
        IStyle style = parser.getBestStyle(styles);
        if (style == null) {
            return null;
        }
        RGB rGB = rgb = isForeground ? style.getColor() : style.getBackgroundColor();
        if (rgb == null) {
            return null;
        }
        return ColorManager.getInstance().getColor(rgb);
    }

    @Override
    public @Nullable Color getEditorForeground() {
        return this.getColor(true, "editor");
    }

    @Override
    public @Nullable Color getEditorBackground() {
        return this.getColor(false, "editor");
    }

    @Override
    public @Nullable Color getEditorSelectionForeground() {
        return this.getColor(true, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorSelectionBackground() {
        return this.getColor(false, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorCurrentLineHighlight() {
        return this.getColor(false, "editor", "lineHighlight");
    }
}

