/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.internal.core.server.ServerAttributes;
import org.eclipse.dstore.internal.core.server.ServerSSLProperties;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;

public class ServerLauncher
extends Thread {
    private ServerSocket _serverSocket;
    private String _path;
    private ArrayList _connections;
    private String _serverPortRange;
    private ISSLProperties _sslProperties;
    private boolean _logDaemon = false;
    private RandomAccessFile _logFile = null;
    public static int DEFAULT_DAEMON_PORT = 4075;

    public ServerLauncher() {
        String pluginPath = System.getProperty("A_PLUGIN_PATH");
        if (pluginPath == null) {
            System.out.println("A_PLUGIN_PATH is not defined");
            System.exit(-1);
        } else {
            this._path = pluginPath.trim();
            this._connections = new ArrayList();
            this.init(String.valueOf(DEFAULT_DAEMON_PORT));
        }
    }

    public ServerLauncher(String portStr) {
        String pluginPath = System.getProperty("A_PLUGIN_PATH");
        if (pluginPath == null) {
            System.out.println("A_PLUGIN_PATH is not defined");
            System.exit(-1);
        } else {
            this._path = pluginPath.trim();
            this._connections = new ArrayList();
            this.init(portStr);
        }
    }

    public ServerLauncher(String portStr, String serverPortRange) {
        String pluginPath = System.getProperty("A_PLUGIN_PATH");
        if (pluginPath == null) {
            System.out.println("A_PLUGIN_PATH is not defined");
            System.exit(-1);
        } else {
            this._path = pluginPath.trim();
            this._serverPortRange = serverPortRange;
            this._connections = new ArrayList();
            this.init(portStr);
        }
    }

    private String getKeyStoreLocation() {
        return this._sslProperties.getDaemonKeyStorePath();
    }

    private String getKeyStorePassword() {
        return this._sslProperties.getDaemonKeyStorePassword();
    }

    public void init(String portStr) {
        String logdaemonLocation = System.getProperty("logdaemonpath");
        if (logdaemonLocation != null && logdaemonLocation.length() > 0) {
            File traceFileHandle = new File(logdaemonLocation);
            if (!traceFileHandle.exists()) {
                try {
                    traceFileHandle.createNewFile();
                }
                catch (IOException iOException) {}
            }
            if (traceFileHandle.canWrite()) {
                try {
                    this._logFile = new RandomAccessFile(traceFileHandle, "rw");
                    this._logFile.seek(traceFileHandle.length());
                    this.logMessage("-----------------------------------------");
                    this.logMessage("Start Tracing at " + System.currentTimeMillis());
                    this._logDaemon = true;
                }
                catch (Exception exception) {}
            }
        }
        this._sslProperties = new ServerSSLProperties();
        String[] range = portStr.split("-");
        if (range.length == 2) {
            int lPort = 0;
            int hPort = 0;
            try {
                lPort = Integer.parseInt(range[0]);
                hPort = Integer.parseInt(range[1]);
            }
            catch (Exception exception) {}
            boolean socketBound = false;
            int i = lPort;
            while (i < hPort && !socketBound) {
                String msg;
                try {
                    if (this._sslProperties.usingSSL()) {
                        String keyStoreFileName = this.getKeyStoreLocation();
                        String keyStorePassword = this.getKeyStorePassword();
                        try {
                            SSLContext sslContext = DStoreSSLContext.getServerSSLContext(keyStoreFileName, keyStorePassword);
                            this._serverSocket = sslContext.getServerSocketFactory().createServerSocket(i);
                        }
                        catch (Exception exception) {}
                    } else {
                        this._serverSocket = new ServerSocket(i);
                    }
                    if (this._serverSocket != null && this._serverSocket.getLocalPort() > 0) {
                        socketBound = true;
                        String msg2 = "Daemon running on: " + ServerAttributes.getHostName() + ", port: " + i;
                        System.out.println(msg2);
                        this.logMessage(msg2);
                    }
                }
                catch (UnknownHostException e) {
                    msg = "Networking problem, can't resolve local host";
                    System.err.println(msg);
                    this.logError(msg, e);
                    System.exit(-1);
                }
                catch (BindException e) {
                    msg = "socket taken on " + i;
                    System.err.println(msg);
                    this.logError(msg, e);
                }
                catch (IOException e) {
                    msg = "Failure to create ServerSocket";
                    System.err.println(msg);
                    this.logError(msg, e);
                    System.exit(-1);
                }
                ++i;
            }
        } else {
            int port = Integer.parseInt(portStr);
            try {
                if (this._sslProperties.usingSSL()) {
                    String keyStoreFileName = this.getKeyStoreLocation();
                    String keyStorePassword = this.getKeyStorePassword();
                    try {
                        SSLContext sslContext = DStoreSSLContext.getServerSSLContext(keyStoreFileName, keyStorePassword);
                        this._serverSocket = sslContext.getServerSocketFactory().createServerSocket(port);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        this.logError(e.getMessage(), e);
                        System.exit(-1);
                    }
                } else {
                    this._serverSocket = new ServerSocket(port);
                }
                String msg = "Daemon running on: " + ServerAttributes.getHostName() + ", port: " + port;
                System.out.println(msg);
                this.logMessage(msg);
            }
            catch (UnknownHostException e) {
                String msg = "Networking problem, can't resolve local host";
                System.err.println(msg);
                this.logError(msg, e);
                System.exit(-1);
            }
            catch (IOException e) {
                String msg = "Failure to create ServerSocket";
                System.err.println(msg);
                this.logError(msg, e);
                System.exit(-1);
            }
        }
    }

    private void logMessage(String msg) {
        if (this._logDaemon && this._logFile != null) {
            try {
                this._logFile.writeBytes(String.valueOf(new Date().toString()) + ": ");
                this._logFile.writeBytes(msg);
                this._logFile.writeBytes(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        }
    }

    private void logError(String msg, Throwable e) {
        if (this._logDaemon && this._logFile != null) {
            try {
                this._logFile.writeBytes(String.valueOf(new Date().toString()) + ": ");
                this._logFile.writeBytes(msg);
                this._logFile.writeBytes(System.getProperty("line.separator"));
                StackTraceElement[] stack = e.getStackTrace();
                int i = 0;
                while (i < stack.length) {
                    this._logFile.writeBytes(stack[i].toString());
                    this._logFile.writeBytes(System.getProperty("line.separator"));
                    ++i;
                }
                this._logFile.writeBytes(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        }
    }

    protected ConnectionListener getListenerForPort(String port) {
        int i = 0;
        while (i < this._connections.size()) {
            ConnectionListener listener = (ConnectionListener)this._connections.get(i);
            if (listener.getServerPort().equals(port)) {
                return listener;
            }
            ++i;
        }
        return null;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    boolean connectionOkay = true;
                    Socket newSocket = this._serverSocket.accept();
                    if (this._sslProperties.usingSSL()) {
                        SSLSocket sslSocket = (SSLSocket)newSocket;
                        sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                            public void handshakeCompleted(HandshakeCompletedEvent event) {
                                String msg = "handshake completed";
                                System.out.println(msg);
                                ServerLauncher.this.logMessage(msg);
                            }
                        });
                        SSLSession session = sslSocket.getSession();
                        if (session == null) {
                            String msg = "handshake failed";
                            System.out.println(msg);
                            this.logMessage(msg);
                            sslSocket.close();
                            connectionOkay = false;
                        }
                    }
                    if (!connectionOkay) continue;
                    ConnectionListener listener = new ConnectionListener(newSocket);
                    listener.start();
                    this._connections.add(listener);
                }
            }
            catch (IOException ioe) {
                String msg = "Server: error initializing socket: " + ioe;
                System.err.println(msg);
                this.logMessage(msg);
                System.exit(-1);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            ServerLauncher theServer = new ServerLauncher(args[0], args[1]);
            theServer.start();
        } else if (args.length == 1) {
            ServerLauncher theServer = new ServerLauncher(args[0]);
            theServer.start();
        } else {
            ServerLauncher theServer = new ServerLauncher();
            theServer.start();
        }
    }

    public class ConnectionListener
    extends Thread
    implements HandshakeCompletedListener {
        private Socket _socket;
        private PrintWriter _writer;
        private BufferedReader _reader;
        private Process _serverProcess;
        private String _port;
        private boolean _done;
        private BufferedReader _outReader;
        private BufferedReader _errReader;

        public ConnectionListener(Socket socket) {
            this._socket = socket;
            try {
                this._writer = new PrintWriter(new OutputStreamWriter(this._socket.getOutputStream(), "UTF-8"));
                this._reader = new BufferedReader(new InputStreamReader(this._socket.getInputStream(), "UTF-8"));
            }
            catch (IOException e) {
                String msg = "ServerLauncher:" + e;
                System.out.println(msg);
                ServerLauncher.this.logError(msg, e);
            }
        }

        public void finalize() throws Throwable {
            if (this._serverProcess != null) {
                this._serverProcess.destroy();
            }
            super.finalize();
        }

        public void run() {
            this._done = true;
            if (this.listen()) {
                if (this._serverProcess != null) {
                    this._done = false;
                    try {
                        String line = null;
                        while (this._outReader != null && (line = this._outReader.readLine()) != null) {
                            if (line.equals("Server Finished")) break;
                            System.out.println(line);
                        }
                        if (this._outReader != null) {
                            this._outReader.close();
                        }
                        if (this._errReader != null) {
                            this._errReader.close();
                        }
                        this._serverProcess.waitFor();
                    }
                    catch (Exception e) {
                        String msg = "ServerLauncher:" + e;
                        System.out.println(msg);
                        ServerLauncher.this.logError(msg, e);
                    }
                }
                String msg = "finished on port " + this._port;
                System.out.println(msg);
                this._outReader = null;
                this._errReader = null;
                this._serverProcess = null;
                this._done = true;
            } else {
                this._done = true;
            }
        }

        public boolean isDone() {
            return this._done;
        }

        public String getServerPort() {
            return this._port;
        }

        private boolean isPortInRange(String portStr, String portRange) {
            String[] range;
            if (portRange != null && (range = portRange.split("-")).length == 2) {
                int lPort = 0;
                int hPort = 0;
                int port = 0;
                try {
                    lPort = Integer.parseInt(range[0]);
                    hPort = Integer.parseInt(range[1]);
                    port = Integer.parseInt(portStr);
                }
                catch (Exception exception) {}
                return port >= lPort && port <= hPort;
            }
            return true;
        }

        public boolean listen() {
            boolean connected = false;
            String user = null;
            String password = null;
            this._port = null;
            boolean problemReadingSocket = false;
            try {
                user = this._reader.readLine();
                password = this._reader.readLine();
                this._port = this._reader.readLine();
            }
            catch (IOException e) {
                this._port = "0";
                this._writer.println("server failure: " + e);
                problemReadingSocket = true;
            }
            if (ServerLauncher.this._serverPortRange != null && (this._port == null || this._port.equals("0"))) {
                this._port = ServerLauncher.this._serverPortRange;
            }
            if (!problemReadingSocket) {
                boolean isError = false;
                if (ServerLauncher.this._serverPortRange != null && this._port != ServerLauncher.this._serverPortRange && !this.isPortInRange(this._port, ServerLauncher.this._serverPortRange)) {
                    String message = "specified port out of range:";
                    message = String.valueOf(message) + ServerLauncher.this._serverPortRange;
                    this._writer.println(message);
                    isError = true;
                }
                if (!isError) {
                    try {
                        String launchStatus = null;
                        String ticket = new String("" + System.currentTimeMillis());
                        String theOS = System.getProperty("os.name");
                        String timeout = "120000";
                        if (!theOS.toLowerCase().startsWith("win")) {
                            String authPath = System.getProperty("RSE.AUTH");
                            File authFile = null;
                            if (authPath != null && authPath.length() > 0) {
                                authFile = new File(authPath);
                            }
                            if (authFile == null || !authFile.exists()) {
                                authPath = "perl " + ServerLauncher.this._path + File.separator + "auth.pl";
                            }
                            String authString = String.valueOf(authPath) + " " + user + " " + ServerLauncher.this._path + " " + this._port + " " + timeout + " " + ticket + " " + System.getProperty("java.home");
                            String[] authArray = new String[]{"sh", "-c", authString};
                            this._serverProcess = Runtime.getRuntime().exec(authArray);
                            this._outReader = new BufferedReader(new InputStreamReader(this._serverProcess.getInputStream()));
                            this._errReader = new BufferedReader(new InputStreamReader(this._serverProcess.getErrorStream()));
                            BufferedWriter inWriter = new BufferedWriter(new OutputStreamWriter(this._serverProcess.getOutputStream()));
                            if (password != null) {
                                inWriter.write(password);
                                inWriter.newLine();
                                inWriter.flush();
                                launchStatus = this._outReader.readLine();
                            }
                        } else {
                            String[] cmdArray = new String[]{"java", "-DA_PLUGIN_PATH=" + ServerLauncher.this._path, "-DDSTORE_SPIRIT_ON=true", "org.eclipse.dstore.core.server.Server", this._port, timeout, ticket};
                            this._serverProcess = Runtime.getRuntime().exec(cmdArray);
                            this._outReader = new BufferedReader(new InputStreamReader(this._serverProcess.getInputStream()));
                            this._errReader = new BufferedReader(new InputStreamReader(this._serverProcess.getErrorStream()));
                            launchStatus = "success";
                        }
                        ServerLauncher.this.logMessage("launch status = " + launchStatus);
                        if (launchStatus == null || !launchStatus.equals("success")) {
                            this._writer.println("Authentification Failed");
                        } else {
                            String status = this._errReader.readLine();
                            ServerLauncher.this.logMessage("status = " + status);
                            while (status != null && status.indexOf("DStore Server Starting...") < 0) {
                                status = this._errReader.readLine();
                            }
                            if (status != null) {
                                status = this._errReader.readLine();
                            }
                            if (status != null && status.equals("Server Started Successfully")) {
                                this._port = this._errReader.readLine();
                                this._errReader.readLine();
                                this._writer.println("connected");
                                this._writer.println(this._port);
                                this._writer.println(ticket);
                                String msg = "launched new server on " + this._port;
                                System.out.println(msg);
                                ServerLauncher.this.logMessage(msg);
                                connected = true;
                            } else {
                                if (status == null) {
                                    status = new String("unknown problem connecting to server");
                                }
                                this._writer.println(status);
                                this._serverProcess.destroy();
                                this._serverProcess = null;
                                this._outReader.close();
                                this._outReader = null;
                                this._errReader.close();
                                this._errReader = null;
                            }
                        }
                    }
                    catch (IOException e) {
                        this._writer.println("server failure: " + e);
                    }
                }
            }
            this._writer.flush();
            try {
                this._socket.close();
            }
            catch (IOException e) {
                String msg = "ServerLauncher:" + e;
                System.out.println(msg);
                ServerLauncher.this.logError(msg, e);
            }
            return connected;
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            String msg = "handshake completed";
            System.out.println(msg);
            System.out.println(event);
            ServerLauncher.this.logMessage(msg);
        }
    }
}

