/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.shells;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.services.terminals.ITerminalService;
import org.eclipse.rse.subsystems.terminals.core.TerminalServiceSubSystem;
import org.eclipse.rse.tests.subsystems.shells.ShellServiceTest;

public class TerminalShellServiceTest
extends ShellServiceTest {
    protected ITerminalService terminalService;
    protected TerminalServiceSubSystem terminalSubSystem;

    public TerminalShellServiceTest(String name, String propertiesFileName) {
        super(name, propertiesFileName);
    }

    public TerminalShellServiceTest(String name) {
        super(name);
    }

    public static Test suite() {
        String baseName = TerminalShellServiceTest.class.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"sshTerminal"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Method[] m = TerminalShellServiceTest.class.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new TerminalShellServiceTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    protected TerminalServiceSubSystem getTerminalServiceSubSystem() {
        if (this.fPropertiesFileName == null) {
            return null;
        }
        IHost host = this.getHost(this.fPropertiesFileName);
        ISubSystem[] ss = RSECorePlugin.getTheSystemRegistry().getServiceSubSystems(host, ITerminalService.class);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof TerminalServiceSubSystem) {
                return (TerminalServiceSubSystem)ss[i];
            }
            ++i;
        }
        return null;
    }

    protected void initShellService() throws SystemMessageException {
        this.terminalSubSystem = this.getTerminalServiceSubSystem();
        this.terminalService = this.terminalSubSystem.getTerminalService();
        this.terminalSubSystem.checkIsConnected(this.getDefaultProgressMonitor());
        this.shellService = (IShellService)this.terminalService.getAdapter(IShellService.class);
    }

    public boolean isWindows() {
        return this.terminalSubSystem.getHost().getSystemType().isWindows();
    }
}

