/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.services.files.ftp.FTPService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.ftp.FTPFileSubSystemConfiguration;
import org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.ui.RSEUIPlugin;

public class FTPFileSubsystemTestCase
extends RSEBaseConnectionTestCase {
    private ISubSystem subSystem;
    private IHost connection;

    protected void tearDown() throws Exception {
        if (this.subSystem != null && this.subSystem.isConnected()) {
            this.subSystem.disconnect(true);
        }
        if (this.connection != null) {
            this.getConnectionManager().removeConnection(this.connection.getSystemProfileName(), this.connection.getName());
        }
        this.subSystem = null;
        this.connection = null;
        super.tearDown();
    }

    public void testFTPReadAccessToRemoteHost() {
        if (this.isTestDisabled()) {
            return;
        }
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to get RSE system registry instance!", (Object)systemRegistry);
        IPath location = this.getTestDataLocation("testFTPReadAccessToRemoteHost", false);
        FTPFileSubsystemTestCase.assertNotNull((String)"Cannot locate test data! Missing test data location?", (Object)location);
        location = location.append("connection.properties");
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to construct location to 'connection.properties' test data file!", (Object)location);
        FTPFileSubsystemTestCase.assertTrue((String)"Required test data file seems to be not a file!", (boolean)location.toFile().isFile());
        FTPFileSubsystemTestCase.assertTrue((String)"Required test data file is not readable!", (boolean)location.toFile().canRead());
        IRSEConnectionProperties properties = this.getConnectionManager().loadConnectionProperties(location, false);
        FTPFileSubsystemTestCase.assertNotNull((String)("Failed to load test connection properties from location " + location.toOSString()), (Object)properties);
        this.connection = this.getConnectionManager().findOrCreateConnection(properties);
        FTPFileSubsystemTestCase.assertNotNull((String)("Failed to create connection " + properties.getProperty("name")), (Object)this.connection);
        RSEUIPlugin.getTheSystemRegistryUI().expandHost(this.connection);
        Exception exception = null;
        String cause = null;
        this.subSystem = null;
        try {
            this.subSystem = this.getConnectionManager().getFileSubSystem(this.connection, "ftp.files");
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        FTPFileSubsystemTestCase.assertNull((String)("Failed to get ftp.files subsystem! Possible cause: " + cause), (Object)exception);
        FTPFileSubsystemTestCase.assertNotNull((String)"No ftp.files subystem", (Object)this.subSystem);
        ISubSystemConfiguration configuration = this.subSystem.getSubSystemConfiguration();
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to get ftp.files subsystem configuration instance!", (Object)configuration);
        FTPFileSubsystemTestCase.assertTrue((String)"Unexpected return value false for ftp.files subsystem configuration supportFilters()!", (boolean)configuration.supportsFilters());
        FTPFileSubsystemTestCase.assertNotNull((String)"Unexpected return value null for ftp.files subsystem getChildren()!", (Object)this.subSystem.getChildren());
        FTPFileSubsystemTestCase.assertTrue((String)"ftp.files subsystem configuration instance is not of expected type FileServiceSubSystemConfiguration!", (boolean)(configuration instanceof FTPFileSubSystemConfiguration));
        FTPFileSubSystemConfiguration ftpConfiguration = (FTPFileSubSystemConfiguration)configuration;
        IFileService service = ftpConfiguration.getFileService(this.connection);
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to get IFileService instance from ftp.files subsystem configuration!", (Object)service);
        FTPFileSubsystemTestCase.assertTrue((String)"IFileService instance is not of expected type FTPService!", (boolean)(service instanceof FTPService));
        FTPService ftpService = (FTPService)service;
        PropertySet set = new PropertySet("testFTPReadAccessToRemoteHost");
        set.addProperty("passive", "true");
        ftpService.setPropertySet((IPropertySet)set);
        FTPFileSubsystemTestCase.assertFalse((String)"ftp.files subsystem is unexpectedly connected!", (boolean)this.subSystem.isConnected());
        try {
            this.subSystem.connect(false, null);
        }
        catch (Exception e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        FTPFileSubsystemTestCase.assertNull((String)("Failed to connect ftp.files subsystem to host " + properties.getProperty("name") + "! Possible cause: " + cause), (Object)exception);
        RSEWaitAndDispatchUtil.waitAndDispatch(10000L);
        if (!this.subSystem.isConnected() || !ftpService.isConnected()) {
            return;
        }
        RSEUIPlugin.getTheSystemRegistryUI().expandSubSystem(this.subSystem);
        IHostFile[] roots = ftpService.getRoots((IProgressMonitor)new NullProgressMonitor());
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to get root nodes from ftp.files service!", (Object)roots);
        FTPClient ftpClient = ftpService.getFTPClient();
        FTPFileSubsystemTestCase.assertNotNull((String)"Failed to get FTPClient instance!", (Object)ftpClient);
        exception = null;
        cause = null;
        FTPFile[] files = null;
        try {
            files = ftpClient.listFiles();
        }
        catch (IOException e) {
            exception = e;
            cause = e.getLocalizedMessage();
        }
        FTPFileSubsystemTestCase.assertNull((String)("Failed to list the files from ftp server " + properties.getProperty("name") + "! Possible cause: " + cause), (Object)exception);
        FTPFileSubsystemTestCase.assertNotNull((String)"Unexpected return value null for FTPClient.listFiles()!", (Object)files);
        if (ftpService.isConnected()) {
            ftpService.disconnect();
        }
    }
}

