/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.IMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteSearchResult;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileChildrenContentsType;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEmpty;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFolderChildrenContentsType;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.propertypages.SystemSubSystemPropertyPageCore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class RemoteFileSubSystem
extends SubSystem
implements IRemoteFileSubSystem,
ICommunicationsListener {
    public boolean osVarsSet;
    public boolean osWindows;
    public boolean osWindows95;
    public boolean osWindowsNT;
    public String osName;
    public String osCmdShell;
    private int includeFilesOrFolders = 8;
    protected IMatcher matcher = null;
    protected NamePatternMatcher folderNameMatcher = null;
    protected RemoteFileFilterString currFilterString = null;
    protected RemoteFileFilterString FILTERSTRING_LISTROOTS = null;
    protected RemoteFileContext DEFAULT_CONTEXT = null;
    protected RemoteFileContext DEFAULT_CONTEXT_NOFILTERSTRING = null;
    protected ArrayList _searchHistory;
    protected HashMap _cachedRemoteFiles = new HashMap();

    public RemoteFileSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this._searchHistory = new ArrayList();
        Platform.getAdapterManager().loadAdapter((Object)new RemoteFileEmpty(), "org.eclipse.rse.ui.view.ISystemViewElementAdapter");
    }

    public boolean isPrimarySubSystem() {
        return true;
    }

    public IRemoteFileSubSystemConfiguration getParentRemoteFileSubSystemConfiguration() {
        return (IRemoteFileSubSystemConfiguration)super.getSubSystemConfiguration();
    }

    public boolean isCaseSensitive() {
        return false;
    }

    protected RemoteFileFilterString getCurrentFilterString() {
        RemoteFileFilterString crffs = this.currFilterString;
        this.currFilterString = null;
        return crffs;
    }

    protected RemoteFileFilterString getFilterStringListRoots() {
        if (this.FILTERSTRING_LISTROOTS == null) {
            this.FILTERSTRING_LISTROOTS = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration());
        }
        return this.FILTERSTRING_LISTROOTS;
    }

    protected RemoteFileContext getDefaultContext() {
        if (this.DEFAULT_CONTEXT == null) {
            this.DEFAULT_CONTEXT = new RemoteFileContext(this, null, this.getFilterStringListRoots());
        }
        return this.DEFAULT_CONTEXT;
    }

    protected RemoteFileContext getDefaultContextNoFilterString() {
        if (this.DEFAULT_CONTEXT_NOFILTERSTRING == null) {
            this.DEFAULT_CONTEXT_NOFILTERSTRING = new RemoteFileContext(this, null, null);
        }
        return this.DEFAULT_CONTEXT_NOFILTERSTRING;
    }

    protected RemoteFileContext getContext(IRemoteFile parent) {
        return new RemoteFileContext(this, parent, null);
    }

    protected RemoteFileContext getContext(IRemoteFile parent, RemoteFileFilterString rffs) {
        return new RemoteFileContext(this, parent, rffs);
    }

    public String getSeparator() {
        return this.getParentRemoteFileSubSystemConfiguration().getSeparator();
    }

    public char getSeparatorChar() {
        return this.getParentRemoteFileSubSystemConfiguration().getSeparatorChar();
    }

    public String getPathSeparator() {
        return this.getParentRemoteFileSubSystemConfiguration().getPathSeparator();
    }

    public char getPathSeparatorChar() {
        return this.getParentRemoteFileSubSystemConfiguration().getPathSeparatorChar();
    }

    public String getLineSeparator() {
        return this.getParentRemoteFileSubSystemConfiguration().getLineSeparator();
    }

    public PropertyPage getPropertyPage(Composite parent) {
        return new SystemSubSystemPropertyPageCore();
    }

    public boolean doesFilterMatch(ISystemFilter filter, String remoteObjectAbsoluteName) {
        if (filter.isPromptable() || !this.doesFilterTypeMatch(filter, remoteObjectAbsoluteName)) {
            return false;
        }
        boolean would = false;
        String[] strings = filter.getFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (!would && idx < strings.length) {
                if (strings[idx].equals("*")) {
                    Path path = new Path(remoteObjectAbsoluteName);
                    return path.segmentCount() == 0;
                }
                would = this.doesFilterStringMatch(strings[idx], remoteObjectAbsoluteName, filter.areStringsCaseSensitive());
                ++idx;
            }
        }
        return would;
    }

    public boolean doesFilterStringMatch(String filterString, String remoteObjectAbsoluteName, boolean caseSensitive) {
        RemoteFileFilterString rffs = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), filterString);
        if (remoteObjectAbsoluteName.endsWith(" -folder")) {
            if (!rffs.getShowSubDirs()) {
                return false;
            }
            remoteObjectAbsoluteName = remoteObjectAbsoluteName.substring(0, remoteObjectAbsoluteName.indexOf(" -folder"));
        }
        if (!rffs.getShowFiles()) {
            return false;
        }
        String container = rffs.getPath();
        if (container == null) {
            return false;
        }
        if (container.equals(".") && !this.isOffline()) {
            try {
                container = this.getRemoteFileObject(container, (IProgressMonitor)new NullProgressMonitor()).getAbsolutePath();
            }
            catch (Exception exception) {}
        }
        if (container.equals(remoteObjectAbsoluteName)) {
            return true;
        }
        RemoteFileFilterString rmtName = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), remoteObjectAbsoluteName);
        boolean pathMatch = false;
        pathMatch = caseSensitive ? container.equals(rmtName.getPath()) : container.equalsIgnoreCase(rmtName.getPath());
        if (!pathMatch) {
            return false;
        }
        String nameFilter = rffs.getFileOrTypes();
        if (nameFilter == null) {
            return false;
        }
        if (!nameFilter.equals("*")) {
            Object matcher = null;
            matcher = nameFilter.endsWith(",") ? new FileTypeMatcher(FileTypeMatcher.parseTypes((String)nameFilter), true) : new NamePatternMatcher(nameFilter, true, caseSensitive);
            return matcher.matches(rmtName.getFile());
        }
        return true;
    }

    public boolean doesFilterStringListContentsOf(ISystemFilterString filterString, String remoteObjectAbsoluteName) {
        RemoteFileFilterString rffs = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), filterString.getString());
        String container = rffs.getPath();
        if (container == null) {
            return false;
        }
        boolean affected = false;
        String remoteObjectContainer = remoteObjectAbsoluteName;
        int lastSep = remoteObjectAbsoluteName.lastIndexOf(this.getSeparator());
        if (lastSep != -1) {
            remoteObjectContainer = remoteObjectAbsoluteName.substring(0, lastSep);
        }
        affected = filterString.getParentSystemFilter().isStringsCaseSensitive() ? container.equals(remoteObjectContainer) : container.equalsIgnoreCase(remoteObjectContainer);
        return affected;
    }

    public Object[] internalResolveFilterStrings(String[] filterStrings, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (!this.isConnected()) {
            return null;
        }
        Object[] children = null;
        Vector vChildren = new Vector();
        Vector vMessages = new Vector();
        boolean oneSuccess = false;
        boolean success = false;
        if (filterStrings == null) {
            System.out.println("filterStrings==null!");
            System.out.println("connection == " + this.getHostAliasName());
            return null;
        }
        int idx = 0;
        while (idx < filterStrings.length) {
            if (monitor != null) {
                monitor.setTaskName(RemoteFileSubSystem.getResolvingMessage((String)filterStrings[idx]));
            }
            if ((children = this.internalResolveFilterString(filterStrings[idx], monitor)) == null || children.length != 1 || !(children[0] instanceof SystemMessageObject)) {
                success = true;
                oneSuccess = true;
            } else {
                success = false;
            }
            if (children != null && success) {
                this.addResolvedFilterStringObjects(vChildren, children, filterStrings, idx);
            } else if (children != null) {
                super.addResolvedFilterStringObjects(vMessages, children, filterStrings, idx);
            }
            ++idx;
        }
        if (oneSuccess) {
            int nbrChildren = vChildren.size();
            children = new Object[nbrChildren];
            int idx2 = 0;
            while (idx2 < nbrChildren) {
                children[idx2] = vChildren.elementAt(idx2);
                ++idx2;
            }
        } else {
            int nbrMessages = vMessages.size();
            children = new Object[nbrMessages];
            int idx3 = 0;
            while (idx3 < nbrMessages) {
                children[idx3] = vMessages.elementAt(idx3);
                ++idx3;
            }
        }
        return children;
    }

    protected void addResolvedFilterStringObjects(Vector allChildrenSoFar, Object[] childrenForThisFilterString, String[] allFilterStrings, int currFilterStringIndex) {
        if (currFilterStringIndex == 0) {
            super.addResolvedFilterStringObjects(allChildrenSoFar, childrenForThisFilterString, allFilterStrings, currFilterStringIndex);
        } else {
            int jdx;
            RemoteFileFilterString currFS = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), allFilterStrings[currFilterStringIndex]);
            String currPath = currFS.getPath();
            if (currPath == null) {
                currPath = "";
            }
            boolean matchingPaths = false;
            boolean caseSensitive = this.getParentRemoteFileSubSystemConfiguration().isCaseSensitive();
            int idx = 0;
            while (idx < currFilterStringIndex) {
                RemoteFileFilterString prevFS = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), allFilterStrings[idx]);
                String prevPath = prevFS.getPath();
                if (prevPath == null) {
                    prevPath = "";
                }
                if (caseSensitive && prevPath.equals(currPath) || !caseSensitive && prevPath.equalsIgnoreCase(currPath)) {
                    matchingPaths = true;
                }
                ++idx;
            }
            if (matchingPaths) {
                jdx = 0;
                while (jdx < childrenForThisFilterString.length) {
                    if (childrenForThisFilterString[jdx] instanceof IRemoteFile) {
                        IRemoteFile child = (IRemoteFile)childrenForThisFilterString[jdx];
                        String path1 = child.getAbsolutePath();
                        if (path1 == null) {
                            path1 = "";
                        }
                        IRemoteFile match = null;
                        int idx2 = 0;
                        while (match == null && idx2 < allChildrenSoFar.size()) {
                            Object prevChild = allChildrenSoFar.elementAt(idx2);
                            if (prevChild instanceof IRemoteFile) {
                                String path2 = ((IRemoteFile)prevChild).getAbsolutePath();
                                if (path2 == null) {
                                    path2 = "";
                                }
                                if (path1.equals(path2)) {
                                    match = (IRemoteFile)prevChild;
                                }
                            }
                            ++idx2;
                        }
                        if (match != null) {
                            IRemoteFileContext context;
                            childrenForThisFilterString[jdx] = null;
                            if (match.isDirectory() && match instanceof RemoteFile && (context = ((RemoteFile)match).getContext()) != null) {
                                context.addFilterString(currFS);
                            }
                        }
                    }
                    ++jdx;
                }
            }
            jdx = 0;
            while (jdx < childrenForThisFilterString.length) {
                if (childrenForThisFilterString[jdx] != null) {
                    allChildrenSoFar.addElement(childrenForThisFilterString[jdx]);
                }
                ++jdx;
            }
        }
    }

    private String fixFilterString(IRemoteFileSubSystemConfiguration rfssf, String filterString) {
        boolean windows;
        boolean bl = windows = !rfssf.isUnixStyle();
        if (filterString.startsWith("/") && windows) {
            int len = filterString.length();
            filterString = len == 1 ? "*" : filterString.substring(1);
        }
        return filterString;
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean windows;
        RemoteFileFilterString fs;
        IRemoteFileSubSystemConfiguration rfssf = this.getParentRemoteFileSubSystemConfiguration();
        filterString = this.fixFilterString(rfssf, filterString);
        this.currFilterString = fs = new RemoteFileFilterString(rfssf, filterString);
        if (fs.listRoots()) {
            return this.listRoots(new RemoteFileContext(this, null, fs), monitor);
        }
        boolean showDirs = fs.getShowSubDirs();
        boolean showFiles = fs.getShowFiles();
        String path = fs.getPath();
        boolean bl = windows = !rfssf.isUnixStyle();
        if (windows && path != null && !path.endsWith(rfssf.getSeparator())) {
            path = String.valueOf(path) + rfssf.getSeparatorChar();
        }
        String filter = fs.getFileOrTypes();
        IRemoteFile parent = null;
        try {
            parent = this.getRemoteFileObject(path, monitor);
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"RemoteFileSubSystemImpl.logError()", (Throwable)e);
        }
        boolean parentExists = true;
        if (parent != null) {
            parentExists = parent.exists();
        }
        Object[] children = null;
        try {
            if (parent != null && parentExists) {
                boolean hasFileAndFolderContents;
                boolean hasFileContents = !parent.isStale() && parent.hasContents(RemoteFileChildrenContentsType.getInstance(), filter);
                boolean hasFolderContents = !parent.isStale() && parent.hasContents(RemoteFolderChildrenContentsType.getInstance(), filter);
                boolean bl2 = hasFileAndFolderContents = !parent.isStale() && parent.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
                if (showDirs && showFiles) {
                    if (!hasFileAndFolderContents) {
                        if (hasFileContents) {
                            this.list(parent, filter, 2, monitor);
                        } else if (hasFolderContents) {
                            this.list(parent, filter, 1, monitor);
                        } else {
                            this.list(parent, filter, 0, monitor);
                        }
                    }
                    children = parent.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
                } else {
                    children = showDirs ? (hasFolderContents ? parent.getContents(RemoteFolderChildrenContentsType.getInstance(), filter) : this.list(parent, filter, 2, monitor)) : (hasFileContents ? parent.getContents(RemoteFileChildrenContentsType.getInstance(), filter) : this.list(parent, filter, 1, monitor));
                }
            } else if (parent != null && !parentExists) {
                children = new SystemMessageObject[1];
                String msgTxt = NLS.bind((String)SystemFileResources.FILEMSG_FILE_NOTFOUND, (Object)parent.getAbsolutePath());
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.subsystems.files.core", "RSEF1006", 4, msgTxt);
                children[0] = new SystemMessageObject((SystemMessage)msg, 0, null);
            }
        }
        catch (SystemMessageException e) {
            children = new SystemMessageObject[]{new SystemMessageObject(e.getSystemMessage(), 0, null)};
        }
        return children;
    }

    public Object[] sortResolvedFilterStringObjects(Object[] children) {
        if (children != null && children.length > 1) {
            Arrays.sort(children);
        }
        return children;
    }

    protected String getFirstParentFilterString(Object parent) {
        RemoteFileFilterString[] allFilterStrings = ((IRemoteFile)parent).getAllFilterStrings();
        if (allFilterStrings == null || allFilterStrings.length == 0) {
            return "*";
        }
        return allFilterStrings[0].getFileOrTypes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] internalResolveFilterString(Object parent, String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RemoteFileFilterString fs = null;
        try {
            if (filterString != null) {
                fs = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), filterString);
                return this.internalResolveOneFilterString(parent, fs, true, monitor);
            }
            RemoteFileFilterString[] allFilterStrings = ((IRemoteFile)parent).getAllFilterStrings();
            if (allFilterStrings == null) {
                fs = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), "*");
                return this.internalResolveOneFilterString(parent, fs, true, monitor);
            }
            boolean onlyOne = allFilterStrings.length == 1;
            Object[] children = null;
            Vector vChildren = null;
            if (!onlyOne) {
                vChildren = new Vector();
            }
            String[] allStrings = new String[allFilterStrings.length];
            int idx = 0;
            while (idx < allFilterStrings.length) {
                allStrings[idx] = allFilterStrings[idx].toString();
                ++idx;
            }
            idx = 0;
            while (idx < allFilterStrings.length) {
                fs = (RemoteFileFilterString)allFilterStrings[idx].clone();
                fs.setPath(null);
                children = this.internalResolveOneFilterString(parent, fs, onlyOne, monitor);
                if (!onlyOne && children != null) {
                    this.addResolvedFilterStringObjects(vChildren, children, allStrings, idx);
                }
                ++idx;
            }
            if (onlyOne) return children;
            if (vChildren == null) return children;
            children = new Object[vChildren.size()];
            int cdx = 0;
            while (cdx < children.length) {
                children[cdx] = vChildren.elementAt(cdx);
                ++cdx;
            }
            Arrays.sort(children);
            return children;
        }
        catch (SystemMessageException e) {
            Object[] children = new SystemMessageObject[]{new SystemMessageObject(e.getSystemMessage(), 0, null)};
            return children;
        }
    }

    protected Object[] internalResolveOneFilterString(Object parent, RemoteFileFilterString fs, boolean sort, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        this.currFilterString = fs;
        String filterString = fs.toStringNoSwitches();
        boolean showDirs = fs.getShowSubDirs();
        boolean showFiles = fs.getShowFiles();
        Object[] children = null;
        if (parent != null) {
            children = showDirs && showFiles ? this.list((IRemoteFile)parent, filterString, 0, monitor) : (showDirs ? this.list((IRemoteFile)parent, filterString, 0, monitor) : this.list((IRemoteFile)parent, filterString, 1, monitor));
            if (sort && children != null && children.length > 1) {
                Arrays.sort(children);
            }
        }
        return children;
    }

    public IRemoteFile[] listRoots(IProgressMonitor monitor) throws InterruptedException {
        return this.listRoots(this.getDefaultContext(), monitor);
    }

    public IRemoteFile[] listMultiple(IRemoteFile[] parents, int[] fileTypes, IProgressMonitor monitor) throws SystemMessageException {
        String[] fileNameFilters = new String[parents.length];
        int i = 0;
        while (i < parents.length) {
            fileNameFilters[i] = "*";
            ++i;
        }
        return this.listMultiple(parents, fileNameFilters, fileTypes, monitor);
    }

    public IRemoteFile[] listMultiple(IRemoteFile[] parents, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        String[] fileNameFilters = new String[parents.length];
        int i = 0;
        while (i < parents.length) {
            fileNameFilters[i] = "*";
            ++i;
        }
        return this.listMultiple(parents, fileNameFilters, fileType, monitor);
    }

    public IRemoteFile[] list(IRemoteFile parent, IProgressMonitor monitor) throws SystemMessageException {
        return this.list(parent, 0, monitor);
    }

    public IRemoteFile[] list(IRemoteFile parent, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        return this.list(parent, null, fileType, monitor);
    }

    public IRemoteFile[] list(IRemoteFile parent, String fileNameFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        String path = parent.getAbsolutePath();
        fileNameFilter = fileNameFilter == null ? "*" : fileNameFilter;
        IRemoteFileSubSystemConfiguration config = this.getParentRemoteFileSubSystemConfiguration();
        RemoteFileFilterString filterString = new RemoteFileFilterString(config, path, fileNameFilter);
        filterString.setShowFiles(true);
        filterString.setShowSubDirs(true);
        RemoteFileContext context = new RemoteFileContext(this, parent, filterString);
        return this.list(parent, fileNameFilter, context, fileType, monitor);
    }

    public String getParentFolderName(IRemoteFile folderOrFile) {
        return folderOrFile.getParentPath();
    }

    public IRemoteSearchResult getRemoteSearchResultObject(String key) throws SystemMessageException {
        int idx = key.indexOf(":SEARCH");
        if (idx != -1) {
            String remoteFilePath = key.substring(0, idx);
            IRemoteFile remoteFile = this.getRemoteFileObject(remoteFilePath, (IProgressMonitor)new NullProgressMonitor());
            if (remoteFile != null) {
                int jdx = idx + ":SEARCH".length() + "<".length();
                int kdx = key.indexOf(":", jdx);
                String searchString = key.substring(jdx, kdx);
                Object[] children = remoteFile.getContents(RemoteSearchResultsContentsType.getInstance(), searchString);
                if (children != null) {
                    int ldx = key.indexOf(">", kdx + 1);
                    int index = Integer.valueOf(key.substring(kdx + 1, ldx));
                    if (children.length > index) {
                        IRemoteSearchResult result = (IRemoteSearchResult)children[index];
                        return result;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public IRemoteFile[] getRemoteFileObjects(String[] folderOrFileNames, IProgressMonitor monitor) throws SystemMessageException {
        IRemoteFile[] results = new IRemoteFile[folderOrFileNames.length];
        int i = 0;
        while (i < folderOrFileNames.length) {
            String path = folderOrFileNames[i];
            results[i] = this.getRemoteFileObject(path, monitor);
            ++i;
        }
        return results;
    }

    public Object getObjectWithAbsoluteName(String key, IProgressMonitor monitor) throws Exception {
        Object filterRef = super.getObjectWithAbsoluteName(key, monitor);
        if (filterRef != null) {
            return filterRef;
        }
        if (key.lastIndexOf(":SEARCH") < 0) {
            IRemoteFile remoteFile = this.getRemoteFileObject(key, monitor);
            if (remoteFile != null) {
                return remoteFile;
            }
            return null;
        }
        return this.getRemoteSearchResultObject(key);
    }

    protected void setListValues(int includeFilesOrFolders, String nameFilter) {
        this.includeFilesOrFolders = includeFilesOrFolders;
        this.matcher = nameFilter != null && !nameFilter.equals("*") ? (nameFilter.endsWith(",") ? new FileTypeMatcher(FileTypeMatcher.parseTypes((String)nameFilter), this.isCaseSensitive()) : new NamePatternMatcher(nameFilter, true, this.isCaseSensitive())) : null;
        this.folderNameMatcher = null;
    }

    protected void setListValues(int includeFilesOrFolders, String folderNameFilter, String fileNameFilter) {
        this.setListValues(includeFilesOrFolders, fileNameFilter);
        if (folderNameFilter != null && !folderNameFilter.equals("*")) {
            this.folderNameMatcher = new NamePatternMatcher(folderNameFilter, true, this.isCaseSensitive());
        }
    }

    protected boolean accept(String name, boolean isFile) {
        boolean match = true;
        if (this.includeFilesOrFolders == 2 ? !isFile : this.includeFilesOrFolders == 4 && isFile) {
            return false;
        }
        if (this.matcher == null && this.folderNameMatcher == null) {
            return true;
        }
        if (this.includeFilesOrFolders != 8) {
            match = this.matcher.matches(name);
        } else if (isFile) {
            if (this.matcher != null) {
                match = this.matcher.matches(name);
            }
        } else if (this.folderNameMatcher != null) {
            match = this.folderNameMatcher.matches(name);
        }
        return match;
    }

    public static int runLocalCommand(String cmd, Vector lines) throws Exception {
        String line;
        Process process;
        boolean debug = true;
        int rc = -99;
        try {
            if (debug) {
                SystemBasePlugin.logInfo((String)("Running local command: " + cmd));
            }
            process = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException exc) {
            if (debug) {
                String msg = exc.getMessage();
                if (msg == null) {
                    msg = exc.getClass().getName();
                }
                SystemBasePlugin.logInfo((String)("...Unexpected error running command '" + cmd + "'. Error msg: " + msg));
            }
            throw exc;
        }
        DataInputStream err = new DataInputStream(process.getErrorStream());
        BufferedReader berr = new BufferedReader(new InputStreamReader(err));
        try {
            while ((line = berr.readLine()) != null) {
                if (debug) {
                    SystemBasePlugin.logInfo((String)("...System.err: " + line));
                }
                if (lines == null || line.trim().length() <= 0) continue;
                lines.addElement(line);
            }
        }
        catch (IOException iOException) {}
        DataInputStream in = new DataInputStream(process.getInputStream());
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = bin.readLine()) != null) {
                if (debug) {
                    SystemBasePlugin.logInfo((String)("...System out: " + line));
                }
                if (lines == null || line.trim().length() <= 0) continue;
                lines.addElement(line);
            }
        }
        catch (IOException iOException) {}
        try {
            rc = process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return rc;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
        super.uninitializeSubSystem(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheRemoteFile(IRemoteFile file, String path) {
        boolean containsKey = false;
        HashMap hashMap = this._cachedRemoteFiles;
        synchronized (hashMap) {
            containsKey = this._cachedRemoteFiles.containsKey(path);
        }
        if (containsKey) {
            IRemoteFile oldFile = null;
            HashMap hashMap2 = this._cachedRemoteFiles;
            synchronized (hashMap2) {
                oldFile = (IRemoteFile)this._cachedRemoteFiles.remove(path);
            }
            if (oldFile == file) {
                hashMap2 = this._cachedRemoteFiles;
                synchronized (hashMap2) {
                    this._cachedRemoteFiles.put(path, file);
                }
                return;
            }
            if (oldFile instanceof RemoteFile) {
                RemoteFile roldFile = (RemoteFile)oldFile;
                if (roldFile._parentFile != null) {
                    roldFile._parentFile.replaceContent(oldFile, file);
                }
            } else if (oldFile != null && oldFile.getParentRemoteFile() != null) {
                oldFile.getParentRemoteFile().replaceContent(oldFile, file);
            }
            if (oldFile != null) {
                oldFile.copyContentsTo(file);
            }
        }
        hashMap = this._cachedRemoteFiles;
        synchronized (hashMap) {
            this._cachedRemoteFiles.put(path, file);
        }
    }

    public void cacheRemoteFile(IRemoteFile file) {
        if (file.exists()) {
            this.cacheRemoteFile(file, file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteFile getCachedRemoteFile(String path) {
        HashMap hashMap = this._cachedRemoteFiles;
        synchronized (hashMap) {
            if (this._cachedRemoteFiles.size() > 0) {
                if ((path = path.replaceAll("//", "/")).endsWith("\\") || path.endsWith("/") && path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                }
                if (this._cachedRemoteFiles.containsKey(path)) {
                    return (IRemoteFile)this._cachedRemoteFiles.get(path);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCachedRemoteFile(IRemoteFile file) {
        if (file != null) {
            Object[] children = file.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance());
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IRemoteFile) {
                        this.removeCachedRemoteFile((IRemoteFile)children[i]);
                    }
                    ++i;
                }
            }
            String prefix = String.valueOf(file.getAbsolutePath()) + file.getSeparator();
            HashMap tmpMap = null;
            HashMap hashMap = this._cachedRemoteFiles;
            synchronized (hashMap) {
                tmpMap = (HashMap)this._cachedRemoteFiles.clone();
            }
            Iterator it = tmpMap.keySet().iterator();
            while (it.hasNext()) {
                String remotePath = (String)it.next();
                if (!remotePath.startsWith(prefix)) continue;
                this.removeCachedRemoteFile(remotePath);
            }
            this.removeCachedRemoteFile(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCachedRemoteFile(String path) {
        HashMap hashMap = this._cachedRemoteFiles;
        synchronized (hashMap) {
            this._cachedRemoteFiles.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRemoteFileCache() {
        HashMap hashMap = this._cachedRemoteFiles;
        synchronized (hashMap) {
            this._cachedRemoteFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 4: {
                HashMap hashMap = this._cachedRemoteFiles;
                synchronized (hashMap) {
                    this._cachedRemoteFiles.clear();
                }
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public int getUnusedPort() {
        return -1;
    }

    public InetAddress getLocalAddress() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            SystemBasePlugin.logError((String)"Error occured trying to get local host address", (Throwable)e);
        }
        if (addr != null && addr.isLoopbackAddress()) {
            return null;
        }
        return addr;
    }

    public Object getTargetForFilter(ISystemFilterReference filterRef) {
        String firstFilterString = filterRef.getReferencedFilter().getFilterStrings()[0];
        RemoteFileFilterString fs = new RemoteFileFilterString(this.getParentRemoteFileSubSystemConfiguration(), firstFilterString);
        try {
            return this.getRemoteFileObject(fs.getPath(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cancelSearch(IHostSearchResultConfiguration searchConfig) {
    }

    public String getRemoteEncoding() {
        IHost host = this.getHost();
        String encoding = host.getDefaultEncoding(false);
        if (encoding == null) {
            encoding = host.getDefaultEncoding(true);
        }
        if (encoding != null) {
            return encoding;
        }
        return SystemEncodingUtil.getInstance().getLocalDefaultEncoding();
    }
}

