/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.examples.daytime.connectorservice;

import java.net.ConnectException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.BasicConnectorService;
import org.eclipse.rse.examples.daytime.DaytimeResources;
import org.eclipse.rse.examples.daytime.service.DaytimeService;
import org.eclipse.rse.examples.daytime.service.IDaytimeService;

public class DaytimeConnectorService
extends BasicConnectorService {
    private boolean fIsConnected = false;
    private DaytimeService fDaytimeService = new DaytimeService();

    public DaytimeConnectorService(IHost host) {
        super(DaytimeResources.Daytime_Connector_Name, DaytimeResources.Daytime_Connector_Description, host, 13);
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        this.fDaytimeService.setHostName(this.getHostName());
        try {
            this.fDaytimeService.getTimeOfDay();
        }
        catch (ConnectException connectException) {
            String message = NLS.bind((String)DaytimeResources.DaytimeConnectorService_NotAvailable, (Object)this.getHostName());
            throw new Exception(message);
        }
        this.fIsConnected = true;
        this.notifyConnection();
    }

    public IDaytimeService getDaytimeService() {
        return this.fDaytimeService;
    }

    public boolean isConnected() {
        return this.fIsConnected;
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        this.fIsConnected = false;
    }
}

