/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.services.terminals.ITerminalService;
import org.eclipse.rse.internal.services.terminals.ITerminalShell;
import org.eclipse.rse.internal.terminals.ui.TerminalServiceHelper;
import org.eclipse.rse.internal.terminals.ui.views.RSETerminalConnectorImpl;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.TerminalServiceSubSystem;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class RSETerminalConnectionThread
extends Thread {
    private final ITerminalControl fControl;
    private final RSETerminalConnectorImpl fConn;
    private ITerminalShell shell;

    public RSETerminalConnectionThread(RSETerminalConnectorImpl conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    public void run() {
        ITerminalServiceSubSystem subsystem = TerminalServiceHelper.getTerminalSubSystem(this.fConn.host);
        try {
            subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
        }
        catch (Exception e1) {
            this.connectFailed(e1.getMessage(), e1.getMessage());
        }
        try {
            if (subsystem instanceof TerminalServiceSubSystem) {
                ITerminalService ts = ((TerminalServiceSubSystem)subsystem).getTerminalService();
                this.shell = ts.launchTerminal("ansi", null, null, null, null, (IProgressMonitor)new NullProgressMonitor());
            }
            this.fConn.setInputStream(this.shell.getInputStream());
            this.fConn.setOutputStream(this.shell.getOutputStream());
        }
        catch (SystemMessageException e) {
            RSECorePlugin.getDefault().getLogger().logError("Error launching terminal", (Throwable)e);
        }
        this.fConn.setTerminalHostShell(this.shell);
        this.fControl.setState(TerminalState.CONNECTED);
        try {
            Thread.sleep(500L);
            this.readDataForever(this.fConn.getInputStream());
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException e) {
            RSECorePlugin.getDefault().getLogger().logError("Error while reading data", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.fControl.setState(TerminalState.CLOSED);
    }

    void disconnect() {
        this.interrupt();
    }

    private void readDataForever(InputStream in) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = in.read(bytes)) != -1) {
            this.fControl.getRemoteToTerminalOutputStream().write(bytes, 0, n);
        }
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
        this.fControl.setState(TerminalState.CLOSED);
        this.fControl.setMsg(msg);
    }
}

