/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.export;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.images.ImageSupplier;
import org.eclipse.swtchart.extensions.menu.export.AbstractSeriesExportHandler;
import org.eclipse.swtchart.extensions.menu.export.ISeriesExportConverter;

public class BMPExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.bmp";
    public static final String NAME = "Image (*.bmp)";
    private static final String TITLE = "Save As Image";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute(Shell shell, ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        String fileName = fileDialog.open();
        if (fileName != null) {
            ImageSupplier imageSupplier = new ImageSupplier();
            ImageData imageData = imageSupplier.getImageData(scrollableChart.getBaseChart());
            imageSupplier.saveImage(imageData, fileName, 0);
            MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)"The data has been exported successully.");
        }
    }
}

