/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ICON_SET_RANGE = "ICON_SET_RANGE";
    public static final String ICON_HIDE = "ICON_HIDE";
    public static final String ICON_RESET = "ICON_RESET";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (PlatformUI.isWorkbenchRunning()) {
            this.initializeImageRegistry();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void initializeImageRegistry() {
        HashMap<String, String> imageHashMap = new HashMap<String, String>();
        imageHashMap.put(ICON_SET_RANGE, "icons/16x16/set_range.gif");
        imageHashMap.put(ICON_HIDE, "icons/16x16/hide.gif");
        imageHashMap.put(ICON_RESET, "icons/16x16/reset.gif");
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry != null) {
            for (Map.Entry entry : imageHashMap.entrySet()) {
                imageRegistry.put((String)entry.getKey(), this.createImageDescriptor(this.getBundle(), (String)entry.getValue()));
            }
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, String string) {
        ImageDescriptor imageDescriptor = null;
        Path path = new Path(string);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        return imageDescriptor;
    }
}

