/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.model.IdNodeDataModel;

public class Node {
    private double val;
    private int level;
    private String id;
    private IdNodeDataModel data;
    private List<Node> children;
    private Point angleBounds;
    private Color color;
    private boolean isVisible;
    private Node parent;
    private int maxSubTreeDepth;

    Node(String id, double val, IdNodeDataModel data) {
        this.id = id;
        this.val = val;
        this.data = data;
        this.level = 0;
        this.children = new ArrayList<Node>();
        this.isVisible = true;
    }

    public Node(String id, double val, Node parent) {
        this.id = id;
        this.val = val;
        this.children = new ArrayList<Node>();
        this.isVisible = parent.isVisible;
        this.parent = parent;
        this.level = parent.level + 1;
        this.data = parent.data;
        this.setColor(Display.getDefault().getSystemColor(3));
        this.data.getTree().put(id, this);
        this.getParent().getChildren().add(this);
    }

    public double getValue() {
        return this.val;
    }

    public String getId() {
        return this.id;
    }

    public Point getAngleBounds() {
        return this.angleBounds;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxSubTreeDepth() {
        return this.maxSubTreeDepth;
    }

    public IdNodeDataModel getDataModel() {
        return this.data;
    }

    public void setValue(double value) {
        this.val = value;
        this.update();
    }

    public void setId(String label) {
        this.id = label;
    }

    public void setAngleBounds(Point point) {
        this.angleBounds = point;
    }

    public void changeParent(Node parent) {
        this.parent = parent;
    }

    public void setDataModel(IdNodeDataModel model) {
        this.data = model;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void addChildren(String[] labels, double[] vals) {
        int length = labels.length;
        int cfr_ignored_0 = vals.length;
        int i = 0;
        while (i < length) {
            new Node(labels[i], vals[i], this);
            ++i;
        }
        this.update();
    }

    public void addChildren(Node[] nodes) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            String label = node.id;
            double value = node.val;
            new Node(label, value, this);
            ++n2;
        }
        this.update();
    }

    public Node addChild(String label, double value) {
        Node node = new Node(label, value, this);
        this.update();
        return node;
    }

    Node removeChild(String child) {
        Node node = null;
        for (Node nodes : this.children) {
            if (nodes.getId() != child) continue;
            node = nodes;
        }
        if (node == null) {
            return null;
        }
        this.children.remove(node);
        this.data.getTree().remove(child);
        this.update();
        return node;
    }

    public void setVisibility(boolean visibility) {
        this.isVisible = visibility;
        if (!this.parent.isVisible) {
            this.isVisible = false;
        }
        List<Node> nodes = this.children;
        for (Node node : nodes) {
            node.setVisibility(node.isVisible ? this.isVisible : false);
        }
    }

    public void updateValues() {
        if (this.children.isEmpty()) {
            this.maxSubTreeDepth = 1;
            return;
        }
        double total = 0.0;
        List<Node> nodes = this.children;
        for (Node node : nodes) {
            node.updateValues();
            total += node.val;
            this.maxSubTreeDepth = Math.max(this.maxSubTreeDepth, node.maxSubTreeDepth + 1);
        }
        if (total > this.val) {
            this.val = total;
        }
    }

    public void updateAngularBounds() {
        List<Node> nodes = this.children;
        if (nodes == null) {
            return;
        }
        int start = this.angleBounds.x;
        double diff = 0.0;
        double required = 0.0;
        for (Node node : nodes) {
            int angleCovered = (int)(node.getValue() * (double)this.angleBounds.y / this.getValue());
            if (angleCovered == 0 && node.getValue() != 0.0) {
                angleCovered = 1;
                required -= 1.0;
            } else {
                diff = node.getValue() * (double)this.angleBounds.y / this.val - (double)angleCovered;
                if ((required += diff) > 0.999) {
                    required -= 1.0;
                    ++angleCovered;
                }
            }
            node.setAngleBounds(new Point(start, angleCovered));
            this.data.getNodes()[node.getLevel() - this.data.getRootPointer().getLevel()].add(node);
            node.updateAngularBounds();
            start += angleCovered;
        }
    }

    public void update() {
        this.data.update();
    }
}

