/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.extended.svg;

import java.awt.Graphics2D;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.export.extended.awt.ChartToGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGFactory {
    private SVGGraphics2D svgGraphics2D;

    public SVGFactory() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        this.svgGraphics2D = new SVGGraphics2D(document);
    }

    public void createSvg(Chart chart, int indexXAxis, int indexYAxis) {
        this.svgGraphics2D = (SVGGraphics2D)new ChartToGraphics2D(chart, indexXAxis, indexYAxis, (Graphics2D)this.svgGraphics2D).getGraphics2D();
    }

    public boolean stream(Writer output, boolean useCss) {
        try {
            this.svgGraphics2D.stream(output, useCss);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Document getDOM() {
        return this.svgGraphics2D.getDOMFactory();
    }
}

