/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexWriter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;

@NonNullByDefault
public class REnvHelpIndexChecker {
    private final RHelpManager rHelpManager;
    private final REnvHelpConfiguration rEnvConfig;
    private int newPkg;
    private int changedPkg;
    private int newChange;
    private Map<String, RPkgBuilt> needUpdate;
    private Map<String, RPkgBuilt> needUpdatePrevious;
    private @Nullable Object indexLock;
    private @Nullable REnvHelp rEnvHelp;
    private boolean rEnvHelpLock;
    private boolean inPackageCheck;

    private static boolean equalVersion(RPkgBuilt pkg1, @Nullable RPkgBuilt pkg2) {
        return pkg2 != null && pkg1.getVersion().equals((Object)pkg2.getVersion()) && pkg1.getBuilt().equals(pkg2.getBuilt());
    }

    public REnvHelpIndexChecker(RHelpManager rHelpManager, REnvHelpConfiguration rEnvConfig) {
        block6: {
            this.newChange = -1;
            this.needUpdate = new HashMap<String, RPkgBuilt>();
            this.needUpdatePrevious = new HashMap<String, RPkgBuilt>();
            this.rHelpManager = (RHelpManager)ObjectUtils.nonNullAssert((Object)rHelpManager);
            this.rEnvConfig = (REnvHelpConfiguration)ObjectUtils.nonNullAssert((Object)rEnvConfig);
            try {
                Path directory = SerUtil.getIndexDirectoryPath(this.rEnvConfig);
                if (directory == null) break block6;
                try {
                    if (!this.isWritable(directory)) {
                        if (RHelpCoreInternals.DEBUG) {
                            RHelpCoreInternals.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("The index directory '%1$s' is not writable.", directory.toString()), null));
                        }
                        return;
                    }
                }
                catch (IOException e) {
                    RHelpCoreInternals.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("The index directory '%1$s' is not accessible.", directory.toString()), (Throwable)e));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isWritable(Path directory) throws IOException {
        Path testFile = directory.resolve("test" + System.nanoTime());
        try {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            Files.createFile(testFile, new FileAttribute[0]);
            Files.delete(testFile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean beginCheck() {
        int n = this.newChange = this.newChange < 0 ? 1 : 0;
        if (this.rEnvConfig == null) {
            return false;
        }
        REnvHelpImpl envHelp = this.rHelpManager.getHelpIntern(this.rEnvConfig.getREnv());
        if (envHelp != null && envHelp.getVersion() != 12) {
            envHelp = null;
        }
        if (envHelp != null != (this.rEnvHelp != null)) {
            this.newChange = 1;
        }
        this.rEnvHelp = envHelp;
        boolean bl = this.rEnvHelpLock = envHelp != null;
        if (!this.rEnvConfig.equals(this.rEnvConfig.getREnv().get(REnvHelpConfiguration.class))) {
            return false;
        }
        this.indexLock = this.rHelpManager.beginIndexCheck(this.rEnvConfig.getREnv());
        return this.indexLock != null;
    }

    public void beginPackageCheck() {
        this.inPackageCheck = true;
        Map<String, RPkgBuilt> tmp = this.needUpdate;
        this.needUpdate = this.needUpdatePrevious;
        this.needUpdatePrevious = tmp;
        this.newPkg = 0;
        this.changedPkg = 0;
        this.newChange = 0;
    }

    public void checkPackage(RPkgBuilt pkgInfo) {
        if (!REnvIndexWriter.IGNORE_PKG_NAMES.contains(pkgInfo.getName())) {
            RPkgHelp pkgHelp = this.rEnvHelp.getPkgHelp(pkgInfo.getName());
            if (pkgHelp == null) {
                ++this.newPkg;
                this.needUpdate.put(pkgInfo.getName(), pkgInfo);
                if (this.newChange == 0 && !REnvHelpIndexChecker.equalVersion(pkgInfo, this.needUpdatePrevious.get(pkgInfo.getName()))) {
                    this.newChange = 1;
                }
            } else if (!RPkgBuilt.equalsBuilt((RPkgBuilt)pkgInfo, (RPkgBuilt)pkgHelp.getPkgDescription())) {
                ++this.changedPkg;
                this.needUpdate.put(pkgInfo.getName(), pkgInfo);
                if (this.newChange == 0 && !REnvHelpIndexChecker.equalVersion(pkgInfo, this.needUpdatePrevious.get(pkgInfo.getName()))) {
                    this.newChange = 1;
                }
            }
        }
    }

    public void endPackageCheck() {
        this.inPackageCheck = false;
        this.needUpdatePrevious.clear();
    }

    public void cancelCheck() {
        if (this.inPackageCheck) {
            Map<String, RPkgBuilt> tmp = this.needUpdate;
            this.needUpdate = this.needUpdatePrevious;
            this.needUpdatePrevious = tmp;
        }
        this.needUpdatePrevious.clear();
        this.unlock();
    }

    public void finalCheck() {
        this.unlock();
    }

    private void unlock() {
        if (this.rEnvHelpLock) {
            this.rEnvHelpLock = false;
            this.rEnvHelp.unlock();
        }
    }

    public void release() {
        if (this.indexLock != null) {
            this.rHelpManager.endIndexCheck(this.indexLock);
            this.indexLock = null;
        }
    }

    public boolean hasNewChanges() {
        return this.newChange > 0;
    }

    public boolean needsComplete() {
        return this.rEnvHelp == null;
    }

    public boolean hasPackageChanges() {
        return this.newPkg > 0 || this.changedPkg > 0;
    }

    public int getNewPackageCount() {
        return this.newPkg;
    }

    public int getChangedPackageCount() {
        return this.changedPkg;
    }
}

