/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import com.ibm.icu.util.TimeZone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.waltable.core.data.ControlData;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.core.SortModel;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.FindListener;
import org.eclipse.statet.internal.r.ui.dataeditor.FindManager;
import org.eclipse.statet.internal.r.ui.dataeditor.FindTask;
import org.eclipse.statet.internal.r.ui.dataeditor.LoadDataException;
import org.eclipse.statet.internal.r.ui.dataeditor.Lock;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.data.impl.RFactorStructStore;
import org.eclipse.statet.rj.services.BasicFQRObjectRef;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.AbstractRDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractRDataProvider<T extends RObject>
implements DataProvider {
    public static final ControlData LOADING = new ControlData(4, "loading...");
    public static final ControlData ERROR = new ControlData(1, "ERROR");
    public static final ControlData NA = new ControlData(2, "NA");
    public static final ControlData DUMMY = new ControlData(0, "");
    protected static final RElementName BASE_NAME = RElementName.create((int)17, (String)"x");
    private static final long DEFAULT_WAIT = 25000000L;
    private static final long CANCEL_WAIT = 200000000L;
    private static final long BLOCKING_WAIT = 300000000L;
    private final ToolRunnable initRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/dataeditor/init";
        }

        public String getLabel() {
            return "Prepare Data Viewer (" + AbstractRDataProvider.this.input.getName() + ")";
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            AbstractRDataProvider.this.runInit((RToolService)service, m);
        }
    };
    private final ToolRunnable updateRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/dataeditor/load";
        }

        public String getLabel() {
            return "Load Data (" + AbstractRDataProvider.this.input.getName() + ")";
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    AbstractRDataProvider.this.fragmentsLock.lock();
                    try {
                        AbstractRDataProvider.this.fragmentsLock.scheduled = false;
                        AbstractRDataProvider.this.fragmentsLock.clear();
                        break;
                    }
                    finally {
                        AbstractRDataProvider.this.fragmentsLock.unlock();
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            AbstractRDataProvider.this.runUpdate((RToolService)service, m);
        }
    };
    private final ToolRunnable cleanRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/dataeditor/clean";
        }

        public String getLabel() {
            return "Clean Cache (" + AbstractRDataProvider.this.input.getName() + ")";
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            AbstractRDataProvider.this.runClean((RToolService)service, m);
        }
    };
    private final Display realm;
    private final RDataTableInput input;
    private final long columnCount;
    private long fullRowCount;
    private long rowCount;
    private final CopyOnWriteIdentityListSet<DataProviderListener> dataListeners = new CopyOnWriteIdentityListSet();
    private boolean initScheduled;
    private volatile boolean disposeScheduled;
    private ContentDescription description;
    private final DataProvider columnDataProvider;
    private final DataProvider rowDataProvider;
    private final DataProvider columnLabelProvider;
    private final DataProvider rowLabelProvider;
    private final MainLock fragmentsLock = new MainLock();
    protected final AbstractRDataAdapter<T, T> adapter;
    private final LazyRStore<T> dataStore;
    private final List<Object> activeOperations = new ArrayList<Object>();
    private boolean updateSorting;
    private boolean updateFiltering;
    private final StringBuilder rStringBuilder = new StringBuilder(128);
    private TmpUtils.Item rTmpItem;
    private T rObjectStruct;
    private final SortModel sortModel;
    private SortColumn sortColumn = null;
    private String rCacheSort;
    private @Nullable String filter;
    private @Nullable String rCacheFilter;
    private boolean updateIdx;
    private @Nullable String rCacheIdx;
    private @Nullable String rCacheIdxR;
    private final FindManager findManager;

    static final void checkCancel(Exception e) throws StatusException {
        if (e instanceof StatusException && ((StatusException)((Object)e)).getStatus().getSeverity() == 8) {
            throw (StatusException)((Object)e);
        }
    }

    protected AbstractRDataProvider(RDataTableInput input, AbstractRDataAdapter<T, T> adapter, T initialRObject) {
        this.realm = UIAccess.getDisplay();
        this.input = input;
        this.adapter = adapter;
        this.fullRowCount = this.rowCount = this.adapter.getRowCount(initialRObject);
        this.columnCount = this.adapter.getColumnCount(initialRObject);
        int dataMax = this.columnCount <= 25L ? 10 : (this.columnCount <= 50L ? 20 : 25);
        this.dataStore = new LazyRStore(this.rowCount, this.columnCount, dataMax, (LazyRStore.Updater)this.fragmentsLock);
        this.findManager = new FindManager(this);
        this.columnDataProvider = this.createColumnDataProvider();
        this.rowDataProvider = this.createRowDataProvider();
        this.columnLabelProvider = this.createColumnLabelProvider();
        this.rowLabelProvider = this.createRowLabelProvider();
        this.sortModel = this.createSortModel();
    }

    public final RDataTableInput getInput() {
        return this.input;
    }

    protected final AbstractRDataAdapter<T, T> getAdapter() {
        return this.adapter;
    }

    public final T getRObject() {
        return this.rObjectStruct;
    }

    final int getLockState() {
        return this.fragmentsLock.state;
    }

    public final void beginOperation(Object o) {
        this.fragmentsLock.lock();
        try {
            this.activeOperations.add(o);
        }
        finally {
            this.fragmentsLock.unlock();
        }
    }

    public final void endOperation(Object o) {
        this.fragmentsLock.lock();
        try {
            if (this.activeOperations.remove(o) && this.activeOperations.isEmpty()) {
                this.fragmentsLock.notifyWorker();
            }
        }
        finally {
            this.fragmentsLock.unlock();
        }
    }

    final void schedule(ToolRunnable runnable) {
        try {
            Tool tool = this.input.getTool();
            Status status = tool.getQueue().add(runnable);
            if (status.getSeverity() == 4 && !tool.isTerminated()) {
                throw new StatusException(status);
            }
        }
        catch (StatusException e) {
            this.clear(4);
            RUIPlugin.logError("An error occurred when scheduling job for data viewer.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInit(RToolService r, ProgressMonitor m) throws StatusException {
        ContentDescription description;
        if (this.disposeScheduled) {
            ToolRunnable toolRunnable = this.initRunnable;
            synchronized (toolRunnable) {
                this.initScheduled = false;
            }
            return;
        }
        try {
            if (this.rTmpItem == null) {
                this.rTmpItem = TmpUtils.newItem((String)"viewer", (RService)r, (ProgressMonitor)m);
            }
        }
        catch (Exception e) {
            ToolRunnable toolRunnable = this.initRunnable;
            synchronized (toolRunnable) {
                this.initScheduled = false;
            }
            AbstractRDataProvider.checkCancel(e);
            this.clear(4);
            RUIPlugin.logError("An error occurred when preparing tmp variables for data viewer.", e);
            this.realm.syncExec(new Runnable(){

                @Override
                public void run() {
                    for (DataProviderListener listener : AbstractRDataProvider.this.dataListeners.toList()) {
                        listener.onInputFailed(0);
                    }
                }
            });
            return;
        }
        try {
            CombinedRElement rObject;
            Object object = rObject = r instanceof ICombinedRDataAdapter ? ((ICombinedRDataAdapter)r).evalCombinedStruct(this.input.getElementName(), 0, 1, m) : r.evalData(this.input.getFullName(), null, 1, 1, m);
            this.rObjectStruct = this.rObjectStruct == null ? this.adapter.validate((RObject)rObject) : this.adapter.validate((RObject)rObject, this.rObjectStruct, 0);
        }
        catch (Exception e) {
            ToolRunnable toolRunnable = this.initRunnable;
            synchronized (toolRunnable) {
                this.initScheduled = false;
            }
            AbstractRDataProvider.checkCancel(e);
            this.clear(3);
            RUIPlugin.logError("An error occurred when initializing structure data for data viewer.", e);
            this.realm.syncExec(new Runnable(){

                @Override
                public void run() {
                    for (DataProviderListener listener : AbstractRDataProvider.this.dataListeners.toList()) {
                        listener.onInputFailed(1);
                    }
                }
            });
            return;
        }
        try {
            description = this.loadDescription(this.input.getElementName(), this.rObjectStruct, r, m);
        }
        catch (Exception e) {
            ToolRunnable toolRunnable = this.initRunnable;
            synchronized (toolRunnable) {
                this.initScheduled = false;
            }
            AbstractRDataProvider.checkCancel(e);
            this.clear(3);
            RUIPlugin.logError("An error occurred when initializing default formats for data viewer.", e);
            return;
        }
        this.realm.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractRDataProvider.this.description = description;
                long rowCount = AbstractRDataProvider.this.adapter.getRowCount(AbstractRDataProvider.this.rObjectStruct);
                boolean rowsChanged = rowCount != AbstractRDataProvider.this.getRowCount();
                AbstractRDataProvider.this.clear(0, rowCount, rowCount, true, true, true);
                ToolRunnable toolRunnable = AbstractRDataProvider.this.initRunnable;
                synchronized (toolRunnable) {
                    AbstractRDataProvider.this.initScheduled = false;
                }
                for (DataProviderListener listener : AbstractRDataProvider.this.dataListeners.toList()) {
                    listener.onInputInitialized(rowsChanged);
                }
            }
        });
    }

    final TmpUtils.Item getTmpItem() {
        return this.rTmpItem;
    }

    /*
     * Unable to fully structure code
     */
    private void runUpdate(RToolService r, ProgressMonitor m) throws StatusException {
        work = -1;
        try {
            block24: while (true) {
                this.fragmentsLock.lock();
                try {
                    switch (work) {
                        case -1: {
                            this.fragmentsLock.scheduled = false;
                            break;
                        }
                        case 0: {
                            if (!this.activeOperations.isEmpty()) {
                                try {
                                    this.fragmentsLock.worker.await();
                                }
                                catch (InterruptedException var6_8) {}
                                break;
                            }
                            return;
                        }
                    }
                    work = 0;
                    updateSorting = this.updateSorting;
                    updateFiltering = this.updateFiltering;
                }
                finally {
                    this.fragmentsLock.unlock();
                }
                elementRef = null;
                if (updateSorting) {
                    if (elementRef == null) {
                        elementRef = this.checkElementRef(this.input.getElementRef(), (RService)r, m);
                        this.adapter.check(elementRef, this.rObjectStruct, (RService)r, m);
                    }
                    this.updateSorting(r, m);
                    ++work;
                }
                if (updateFiltering) {
                    if (elementRef == null) {
                        elementRef = this.checkElementRef(this.input.getElementRef(), (RService)r, m);
                        this.adapter.check(elementRef, this.rObjectStruct, (RService)r, m);
                    }
                    this.updateFiltering(r, m);
                    ++work;
                }
                if (this.updateIdx) {
                    if (elementRef == null) {
                        elementRef = this.checkElementRef(this.input.getElementRef(), (RService)r, m);
                        this.adapter.check(elementRef, this.rObjectStruct, (RService)r, m);
                    }
                    this.updateIdx(r, m);
                    ++work;
                }
                if (work == 0 && this.rowDataProvider instanceof RowDataProvider) {
                    namesStore = ((RowDataProvider)this.rowDataProvider).rowNamesStore;
                    while (true) {
                        this.fragmentsLock.lock();
                        try {
                            fragment = namesStore.getNextScheduledFragment();
                        }
                        finally {
                            this.fragmentsLock.unlock();
                        }
                        if (fragment == null) break;
                        if (elementRef == null) {
                            elementRef = this.checkElementRef(this.input.getElementRef(), (RService)r, m);
                            this.adapter.check(elementRef, this.rObjectStruct, (RService)r, m);
                        }
                        fragmentObject = this.adapter.loadRowNames(elementRef, this.rObjectStruct, fragment, this.rCacheIdx, (RService)r, m);
                        this.fragmentsLock.lock();
                        try {
                            namesStore.updateFragment(fragment, (Object)fragmentObject);
                            this.fragmentsLock.notify(fragment);
                        }
                        finally {
                            this.fragmentsLock.unlock();
                        }
                        this.notifyListener(fragment);
                        ++work;
                    }
                }
                if (work != 0) continue;
                while (true) {
                    this.fragmentsLock.lock();
                    try {
                        fragment = this.dataStore.getNextScheduledFragment();
                    }
                    finally {
                        this.fragmentsLock.unlock();
                    }
                    if (fragment != null) ** break;
                    continue block24;
                    if (elementRef == null) {
                        elementRef = this.checkElementRef(this.input.getElementRef(), (RService)r, m);
                        this.adapter.check(elementRef, this.rObjectStruct, (RService)r, m);
                    }
                    fragmentObject = this.adapter.loadData(elementRef, this.rObjectStruct, fragment, this.rCacheIdx, (RService)r, m);
                    this.fragmentsLock.lock();
                    try {
                        this.dataStore.updateFragment(fragment, (Object)fragmentObject);
                        this.fragmentsLock.notify(fragment);
                    }
                    finally {
                        this.fragmentsLock.unlock();
                    }
                    this.notifyListener(fragment);
                    ++work;
                }
                break;
            }
        }
        catch (Exception e) {
            AbstractRDataProvider.checkCancel(e);
            this.clear(3);
            RUIPlugin.logError(NLS.bind((String)"An error occurred when loading data of ''{0}'' for data viewer.", (Object)this.input.getFullName()), e);
            return;
        }
    }

    private FQRObjectRef<? extends RTool> checkElementRef(FQRObjectRef<? extends RTool> elementRef, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RObject env = elementRef.getEnv();
        switch (env.getRObjectType()) {
            case 14: {
                return elementRef;
            }
            case 12: {
                env = RDataUtils.checkRReference((RObject)r.evalData(((RLanguage)env).getSource(), null, 0, 0, m), (byte)8);
                return new BasicFQRObjectRef((Object)((RTool)elementRef.getRHandle()), env, elementRef.getName());
            }
        }
        throw new UnexpectedRDataException("Unexpected R object type: " + RDataUtils.getObjectTypeName((byte)env.getRObjectType()));
    }

    private void updateSorting(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        SortColumn sortColumn;
        this.cleanSorting(m);
        this.fragmentsLock.lock();
        try {
            sortColumn = this.sortColumn;
            this.updateSorting = false;
        }
        finally {
            this.fragmentsLock.unlock();
        }
        if (sortColumn != null) {
            if (this.rCacheSort == null) {
                this.rCacheSort = this.rTmpItem.createSub("order");
            }
            StringBuilder cmd = this.getRCmdStringBuilder();
            this.appendOrderCmd(cmd, sortColumn);
            this.rTmpItem.set(this.rCacheSort, cmd.toString(), m);
        }
    }

    private void updateFiltering(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        long filteredRowCount;
        String filter;
        this.cleanFiltering(m);
        this.fragmentsLock.lock();
        try {
            filter = this.filter;
            this.updateFiltering = false;
        }
        finally {
            this.fragmentsLock.unlock();
        }
        if (filter == null) {
            filteredRowCount = this.getFullRowCount();
        } else {
            if (this.rCacheFilter == null) {
                this.rCacheFilter = this.rTmpItem.createSub("include");
            }
            this.rTmpItem.set(this.rCacheFilter, filter, m);
            FunctionCall call = r.createFunctionCall("rj:::tmp.getFilteredCount");
            call.addChar("filter", this.rCacheFilter);
            filteredRowCount = RDataUtils.checkSingleIntValue((RObject)call.evalData(m));
        }
        this.realm.syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractRDataProvider.this.clear(0, filteredRowCount, AbstractRDataProvider.this.getFullRowCount(), false, false, false);
                for (DataProviderListener listener : AbstractRDataProvider.this.dataListeners.toList()) {
                    listener.onRowsChanged();
                }
            }
        });
    }

    private void updateIdx(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        this.cleanIdx(m);
        String rCacheFilter = this.rCacheFilter;
        String rCacheSort = this.rCacheSort;
        if (rCacheSort != null || rCacheFilter != null) {
            String rCacheIdx = this.rCacheIdx;
            if (rCacheIdx == null) {
                this.rCacheIdx = rCacheIdx = this.rTmpItem.createSub("idx");
            }
            if (rCacheFilter == null) {
                StringBuilder cmd = this.getRCmdStringBuilder();
                cmd.append("rj::.rj.tmp$").append(rCacheSort);
                this.rTmpItem.set(rCacheIdx, cmd.toString(), m);
            } else if (rCacheSort == null) {
                FunctionCall call = r.createFunctionCall("rj:::tmp.setWhichIndex");
                call.addChar("name", rCacheIdx);
                call.addChar("filter", rCacheFilter);
                call.evalVoid(m);
            } else {
                FunctionCall call = r.createFunctionCall("rj:::tmp.setFilteredIndex");
                call.addChar("name", rCacheIdx);
                call.addChar("filter", rCacheFilter);
                call.addChar("index", rCacheSort);
                call.evalVoid(m);
            }
        }
        this.updateIdx = false;
    }

    @Nullable String checkFilter() {
        return this.rCacheFilter;
    }

    String checkRevIndex(RToolService r, ProgressMonitor m) throws StatusException {
        if (this.rCacheIdx != null) {
            if (this.rCacheIdxR == null) {
                String name = this.rTmpItem.createSub("idx.r");
                try {
                    FunctionCall call = r.createFunctionCall("rj:::tmp.setReverseIndex");
                    call.addChar("name", name);
                    call.addChar("index", this.rCacheIdx);
                    call.addNum("len", (double)this.getFullRowCount());
                    call.evalVoid(m);
                    String string = this.rCacheIdxR = name;
                    return string;
                }
                finally {
                    if (this.rCacheIdxR == null) {
                        this.rTmpItem.remove(name, m);
                    }
                }
            }
            return this.rCacheIdxR;
        }
        return null;
    }

    protected abstract ContentDescription loadDescription(RElementName var1, T var2, RToolService var3, ProgressMonitor var4) throws StatusException, UnexpectedRDataException;

    protected RDataTableColumn createColumn(RStore<?> store, String expression, @Nullable RElementName elementName, long columnIndex, @Nullable String columnName, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall call = r.createFunctionCall("class");
        call.add(expression);
        RObject rObject = call.evalData(m);
        RVector names = RDataUtils.checkRCharVector((RObject)rObject);
        ImList classNames = ImCollections.newList((Object[])((RCharacterStore)names.getData()).toArray());
        RDataFormatter format = new RDataFormatter();
        return switch (store.getStoreType()) {
            case 1 -> {
                format.setAutoWidth(5);
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 1, store, (List<String>)classNames, format);
            }
            case 3 -> {
                if (this.checkDateFormat(expression, (List<String>)classNames, format, r, m)) {
                    yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 17, store, (List<String>)classNames, format);
                }
                if (this.checkDateTimeFormat(expression, (List<String>)classNames, format, r, m)) {
                    yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 19, store, (List<String>)classNames, format);
                }
                FunctionCall call = r.createFunctionCall("rj:::.getFormatInfo");
                call.add("x", expression);
                rObject = call.evalData(m);
                RIntegerStore formatInfo = (RIntegerStore)RDataUtils.checkRIntVector((RObject)rObject).getData();
                RDataUtils.checkLengthGreaterOrEqual((RStore)formatInfo, (long)3L);
                format.setAutoWidth(Math.max(formatInfo.getInt(0), 3));
                format.initNumFormat(formatInfo.getInt(1), formatInfo.getInt(2) > 0 ? formatInfo.getInt(2) + 1 : 0);
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 3, store, (List<String>)classNames, format);
            }
            case 2 -> {
                if (this.checkDateFormat(expression, (List<String>)classNames, format, r, m)) {
                    yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 17, store, (List<String>)classNames, format);
                }
                if (this.checkDateTimeFormat(expression, (List<String>)classNames, format, r, m)) {
                    yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 19, store, (List<String>)classNames, format);
                }
                FunctionCall call = r.createFunctionCall("rj:::.getFormatInfo");
                call.add("x", expression);
                rObject = call.evalData(m);
                RIntegerStore formatInfo = (RIntegerStore)RDataUtils.checkRIntVector((RObject)rObject).getData();
                RDataUtils.checkLengthGreaterOrEqual((RStore)formatInfo, (long)1L);
                format.setAutoWidth(Math.max(formatInfo.getInt(0), 3));
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 2, store, (List<String>)classNames, format);
            }
            case 5 -> {
                FunctionCall call = r.createFunctionCall("rj:::.getFormatInfo");
                call.add("x", expression);
                rObject = call.evalData(m);
                RIntegerStore formatInfo = (RIntegerStore)RDataUtils.checkRIntVector((RObject)rObject).getData();
                RDataUtils.checkLengthGreaterOrEqual((RStore)formatInfo, (long)1L);
                format.setAutoWidth(Math.max(formatInfo.getInt(0), 3));
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 5, store, (List<String>)classNames, format);
            }
            case 4 -> {
                FunctionCall call = r.createFunctionCall("rj:::.getFormatInfo");
                call.add("x", expression);
                rObject = call.evalData(m);
                RIntegerStore formatInfo = (RIntegerStore)RDataUtils.checkRIntVector((RObject)rObject).getData();
                RDataUtils.checkLengthGreaterOrEqual((RStore)formatInfo, (long)3L);
                format.setAutoWidth(Math.max(formatInfo.getInt(0), 3));
                format.initNumFormat(formatInfo.getInt(1), formatInfo.getInt(2) > 0 ? formatInfo.getInt(2) + 1 : 0);
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 4, store, (List<String>)classNames, format);
            }
            case 6 -> {
                format.setAutoWidth(2);
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 6, store, (List<String>)classNames, format);
            }
            case 10 -> {
                FunctionCall call = r.createFunctionCall("levels");
                call.add(expression);
                rObject = call.evalData(m);
                format.setAutoWidth(3);
                RCharacterStore levels = (RCharacterStore)RDataUtils.checkRCharVector((RObject)rObject).getData();
                int l = RDataUtils.checkIntLength((RStore)levels);
                int i = 0;
                while (i < l) {
                    int length;
                    if (!levels.isNA(i) && (length = levels.getChar(i).length()) > format.getAutoWidth()) {
                        format.setAutoWidth(length);
                    }
                    ++i;
                }
                format.initFactorLevels(levels);
                yield new RDataTableColumn(columnIndex, columnName, expression, elementName, 10, (RStore<?>)RFactorStructStore.addLevels((RFactorStore)((RFactorStore)store), (RCharacterStore)levels), (List<String>)classNames, format);
            }
            default -> throw new UnexpectedRDataException("store type: " + store.getStoreType());
        };
    }

    protected boolean checkDateFormat(String expression, List<String> classNames, RDataFormatter formatter, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        if (classNames.contains("Date")) {
            formatter.initDateFormat(86400000);
            formatter.setAutoWidth(10);
            return true;
        }
        return false;
    }

    protected boolean checkDateTimeFormat(String expression, List<String> classNames, RDataFormatter formatter, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        if (classNames.contains("POSIXct")) {
            formatter.initDateTimeFormat(1000);
            formatter.setAutoWidth(27);
            FunctionCall call = r.createFunctionCall("base::attr");
            call.add(expression);
            call.addChar("tzone");
            RObject rObject = call.evalData(m);
            if (rObject.getRObjectType() != 1) {
                formatter.setDateTimeZone(TimeZone.getTimeZone((String)RDataUtils.checkSingleCharValue((RObject)rObject)));
            }
            return true;
        }
        return false;
    }

    protected RDataTableColumn createNamesColumn(String expression, long count, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RObject names = r.evalData(expression, null, 1, 1, m);
        if (names != null && names.getRObjectType() == 2 && names.getLength() == count && (names.getData().getStoreType() == 5 || names.getData().getStoreType() == 2)) {
            return this.createColumn(names.getData(), expression, null, -1L, null, r, m);
        }
        return this.createAutoNamesColumn(count);
    }

    private RDataTableColumn createAutoNamesColumn(long count) {
        RDataFormatter format = new RDataFormatter();
        format.setAutoWidth(Math.max(Long.toString(count).length(), 3));
        return new RDataTableColumn(-1L, null, null, null, 2, (RStore<?>)DefaultRObjectFactory.INT_STRUCT_DUMMY, (List<String>)ImCollections.newList((Object)"integer"), format);
    }

    protected abstract void appendOrderCmd(StringBuilder var1, SortColumn var2);

    private void runClean(RToolService r, ProgressMonitor m) throws StatusException {
        this.clear(4);
        this.cleanSorting(m);
        this.cleanFiltering(m);
        this.findManager.clean(m);
        this.rTmpItem.dispose(m);
        this.rTmpItem = null;
    }

    private void cleanSorting(ProgressMonitor m) throws StatusException {
        this.cleanIdx(m);
        if (this.rCacheSort != null) {
            this.rTmpItem.remove(this.rCacheSort, m);
            this.rCacheSort = null;
        }
    }

    private void cleanFiltering(ProgressMonitor m) throws StatusException {
        this.cleanIdx(m);
        if (this.rCacheFilter != null) {
            this.rTmpItem.remove(this.rCacheFilter, m);
            this.rCacheFilter = null;
        }
    }

    private void cleanIdx(ProgressMonitor m) throws StatusException {
        this.updateIdx = true;
        if (this.rCacheIdx != null) {
            this.rTmpItem.remove(this.rCacheIdx, m);
            this.rCacheIdx = null;
        }
        if (this.rCacheIdxR != null) {
            this.rTmpItem.remove(this.rCacheIdxR, m);
            this.rCacheIdxR = null;
        }
    }

    protected final StringBuilder getRCmdStringBuilder() {
        this.rStringBuilder.setLength(0);
        return this.rStringBuilder;
    }

    public boolean getAllColumnsEqual() {
        return false;
    }

    public ContentDescription getDescription() {
        return this.description;
    }

    public long getColumnCount() {
        return this.columnCount;
    }

    public long getFullRowCount() {
        return this.fullRowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
        try {
            LazyRStore.Fragment<T> fragment = this.fragmentsLock.getFragment(this.dataStore, rowIndex, columnIndex, flags, EStatusUtils.convert((IProgressMonitor)monitor));
            if (fragment != null) {
                return this.getDataValue(fragment, rowIndex, columnIndex);
            }
            return this.handleMissingData(flags);
        }
        catch (LoadDataException e) {
            return this.handleLoadDataException(e, flags);
        }
    }

    protected abstract Object getDataValue(LazyRStore.Fragment<T> var1, long var2, long var4);

    public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

    protected abstract Object getColumnName(LazyRStore.Fragment<T> var1, long var2);

    public boolean hasRealColumns() {
        return true;
    }

    public boolean hasRealRows() {
        return true;
    }

    public DataProvider getColumnDataProvider() {
        return this.columnDataProvider;
    }

    public DataProvider getRowDataProvider() {
        return this.rowDataProvider;
    }

    public DataProvider getColumnLabelProvider() {
        return this.columnLabelProvider;
    }

    public DataProvider getRowLabelProvider() {
        return this.rowLabelProvider;
    }

    protected DataProvider createColumnDataProvider() {
        return new ColumnDataProvider();
    }

    protected DataProvider createRowDataProvider() {
        return new RowDataProvider();
    }

    protected DataProvider createColumnLabelProvider() {
        return null;
    }

    protected DataProvider createRowLabelProvider() {
        return null;
    }

    protected SortModel createSortModel() {
        return new DataSortModel();
    }

    private Object handleMissingData(int flags) {
        return (flags & 1) != 0 ? ERROR : LOADING;
    }

    private Object handleLoadDataException(LoadDataException e, int flags) {
        if (!e.isRecoverable()) {
            return ERROR;
        }
        this.reset();
        return this.handleMissingData(flags);
    }

    public SortModel getSortModel() {
        return this.sortModel;
    }

    public SortColumn getSortColumn() {
        return this.sortColumn;
    }

    private void setSortColumn(SortColumn column) {
        this.fragmentsLock.lock();
        try {
            if (Objects.equals(this.sortColumn, column)) {
                return;
            }
            this.sortColumn = column;
            this.clear(-1, -1L, -1L, true, false, false);
            this.findManager.reset(false);
        }
        finally {
            this.fragmentsLock.unlock();
        }
    }

    public void setFilter(@Nullable String filter) {
        this.fragmentsLock.lock();
        try {
            if (Objects.equals(this.filter, filter)) {
                return;
            }
            this.filter = filter;
            this.clear(-1, -1L, -1L, false, true, false);
            this.findManager.reset(true);
            this.fragmentsLock.scheduleUpdate(null, null, null, 0, null);
        }
        finally {
            this.fragmentsLock.unlock();
        }
    }

    public @Nullable String getFilter() {
        return this.filter;
    }

    public void addFindListener(FindListener listener) {
        this.findManager.addFindListener(listener);
    }

    public void removeFindListener(FindListener listener) {
        this.findManager.removeFindListener(listener);
    }

    public void find(FindTask task) {
        this.findManager.find(task);
    }

    public long[] toDataIdxs(long columnIndex, long rowIndex) {
        if (this.getFilter() != null || this.getSortColumn() != null) {
            if (this.rowDataProvider instanceof RowDataProvider) {
                long rowIdx = ((RowDataProvider)this.rowDataProvider).getRowIdx(rowIndex);
                return new long[]{columnIndex, rowIdx};
            }
            return new long[]{columnIndex, -2L};
        }
        return new long[]{columnIndex, rowIndex};
    }

    public void addDataChangedListener(DataProviderListener listener) {
        this.dataListeners.add((Object)listener);
    }

    public void removeDataChangedListener(DataProviderListener listener) {
        this.dataListeners.remove((Object)listener);
    }

    protected void notifyListener(LazyRStore.Fragment<?> item) {
        try {
            for (DataProviderListener listener : this.dataListeners.toList()) {
                listener.onRowsChanged(item.getRowBeginIdx(), item.getRowEndIdx());
            }
        }
        catch (Exception e) {
            RUIPlugin.logError("An error occurred when notifying about row updates.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.clear(2);
        ToolRunnable toolRunnable = this.initRunnable;
        synchronized (toolRunnable) {
            if (this.initScheduled) {
                return;
            }
            this.initScheduled = true;
        }
        try {
            Status status = this.input.getTool().getQueue().add(this.initRunnable);
            if (status.getSeverity() >= 4) {
                throw new StatusException(status);
            }
        }
        catch (StatusException statusException) {
            // empty catch block
        }
    }

    private void clear(int newState) {
        this.clear(newState, -1L, -1L, true, true, true);
    }

    private void clear(int newState, long filteredRowCount, long fullRowCount, boolean updateSorting, boolean updateFiltering, boolean clearFind) {
        this.fragmentsLock.lock();
        try {
            this.dataStore.clear(filteredRowCount);
            if (this.rowDataProvider instanceof RowDataProvider) {
                ((RowDataProvider)this.rowDataProvider).rowNamesStore.clear(filteredRowCount);
            }
            this.updateSorting |= updateSorting;
            this.updateFiltering |= updateFiltering;
            if (newState >= 0 && this.fragmentsLock.state < 4) {
                this.fragmentsLock.state = newState;
            }
            this.fragmentsLock.clear();
            if (filteredRowCount >= 0L) {
                this.rowCount = filteredRowCount;
                this.fullRowCount = fullRowCount;
            }
            if (clearFind) {
                this.findManager.clear(newState);
            }
        }
        finally {
            this.fragmentsLock.unlock();
        }
    }

    public void dispose() {
        this.disposeScheduled = true;
        this.schedule(this.cleanRunnable);
    }

    protected class ColumnDataProvider
    implements DataProvider {
        public long getColumnCount() {
            return AbstractRDataProvider.this.getColumnCount();
        }

        public long getRowCount() {
            return 1L;
        }

        public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
            try {
                LazyRStore.Fragment fragment = AbstractRDataProvider.this.fragmentsLock.getFragment(AbstractRDataProvider.this.dataStore, 0L, columnIndex, flags, EStatusUtils.convert((IProgressMonitor)monitor));
                if (fragment != null) {
                    return AbstractRDataProvider.this.getColumnName(fragment, columnIndex);
                }
                return AbstractRDataProvider.this.handleMissingData(flags);
            }
            catch (LoadDataException e) {
                return AbstractRDataProvider.this.handleLoadDataException(e, flags);
            }
        }

        public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DataProviderListener {
        public static final int ERROR_STRUCT_CHANGED = 1;

        public void onInputInitialized(boolean var1);

        public void onInputFailed(int var1);

        public void onRowsChanged();

        public void onRowsChanged(long var1, long var3);
    }

    protected class DataSortModel
    implements SortModel {
        protected DataSortModel() {
        }

        public List<Long> getSortedColumnIds() {
            SortColumn sortColumn = AbstractRDataProvider.this.getSortColumn();
            if (sortColumn != null) {
                return Collections.singletonList(sortColumn.id);
            }
            return Collections.emptyList();
        }

        public void sort(long columnId, SortDirection sortDirection, boolean accumulate) {
            AbstractRDataProvider.this.setSortColumn(switch (sortDirection) {
                case SortDirection.ASC -> new SortColumn(columnId, false);
                case SortDirection.DESC -> new SortColumn(columnId, true);
                default -> null;
            });
        }

        public int getSortOrder(long columnId) {
            SortColumn sortColumn = AbstractRDataProvider.this.getSortColumn();
            if (sortColumn != null && sortColumn.id == columnId) {
                return 0;
            }
            return -1;
        }

        public boolean isSorted(long columnId) {
            SortColumn sortColumn = AbstractRDataProvider.this.getSortColumn();
            return sortColumn != null && sortColumn.id == columnId;
        }

        public SortDirection getSortDirection(long columnId) {
            SortColumn sortColumn = AbstractRDataProvider.this.getSortColumn();
            if (sortColumn != null && sortColumn.id == columnId) {
                return !sortColumn.decreasing ? SortDirection.ASC : SortDirection.DESC;
            }
            return SortDirection.NONE;
        }

        public void clear() {
            AbstractRDataProvider.this.setSortColumn(null);
        }
    }

    private class MainLock
    extends Lock
    implements LazyRStore.Updater {
        private final List<LazyRStore.Fragment> waitingFragments = new ArrayList<LazyRStore.Fragment>();

        private MainLock() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void scheduleUpdate(LazyRStore store, RDataAssignment assignment, LazyRStore.Fragment fragment, int flags, ProgressMonitor m) {
            long waitNanos;
            if (!this.scheduled) {
                this.scheduled = true;
                AbstractRDataProvider.this.schedule(AbstractRDataProvider.this.updateRunnable);
                waitNanos = (flags & 1) != 0 ? 0L : 25000000L;
            } else {
                waitNanos = (flags & 1) != 0 ? 0 : -1;
            }
            if (waitNanos < 0L || fragment == null) return;
            this.waitingFragments.add(fragment);
            this.worker.signalAll();
            try {
                try {
                    if (waitNanos == 0L) {
                        do {
                            waitNanos = this.requestor.awaitNanos(200000000L);
                            if (!this.waitingFragments.contains(fragment) || this.state != 0) return;
                        } while (m == null || !m.isCanceled());
                        return;
                    }
                    do {
                        waitNanos = this.requestor.awaitNanos(waitNanos);
                        if (!this.waitingFragments.contains(fragment) || this.state != 0 || m != null && m.isCanceled()) return;
                    } while (waitNanos > 0L);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    this.waitingFragments.remove(fragment);
                }
                return;
            }
            finally {
                this.waitingFragments.remove(fragment);
            }
        }

        void notify(Object obj) {
            if (this.waitingFragments.remove(obj)) {
                this.requestor.signalAll();
            }
        }

        @Override
        void clear() {
            this.waitingFragments.clear();
            super.clear();
        }
    }

    protected class RowDataProvider
    implements DataProvider {
        private final LazyRStore<RVector<?>> rowNamesStore;

        public RowDataProvider() {
            this.rowNamesStore = new LazyRStore(AbstractRDataProvider.this.rowCount, 1L, 10, (LazyRStore.Updater)AbstractRDataProvider.this.fragmentsLock);
        }

        public long getColumnCount() {
            return 1L;
        }

        public long getRowCount() {
            return AbstractRDataProvider.this.getRowCount();
        }

        public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
            try {
                LazyRStore.Fragment<RVector<?>> fragment = AbstractRDataProvider.this.fragmentsLock.getFragment(this.rowNamesStore, rowIndex, 0L, flags, EStatusUtils.convert((IProgressMonitor)monitor));
                if (fragment != null) {
                    RVector vector = (RVector)fragment.getRObject();
                    if (vector != null) {
                        RStore names = vector.getNames();
                        if (names == null) {
                            names = vector.getData();
                        }
                        return names.get(rowIndex - fragment.getRowBeginIdx());
                    }
                    return Long.toString(rowIndex + 1L);
                }
                return AbstractRDataProvider.this.handleMissingData(flags);
            }
            catch (LoadDataException e) {
                return AbstractRDataProvider.this.handleLoadDataException(e, flags);
            }
        }

        public long getRowIdx(long rowIndex) {
            try {
                LazyRStore.Fragment<RVector<?>> fragment = AbstractRDataProvider.this.fragmentsLock.getFragment(this.rowNamesStore, rowIndex, 0L, 0, null);
                if (fragment != null) {
                    RVector vector = (RVector)fragment.getRObject();
                    if (vector != null) {
                        RStore idxs = vector.getData();
                        return (idxs.getStoreType() == 2 ? (long)idxs.getInt(rowIndex - fragment.getRowBeginIdx()) : (long)idxs.getNum(rowIndex - fragment.getRowBeginIdx())) - 1L;
                    }
                    return rowIndex;
                }
                return -1L;
            }
            catch (LoadDataException e) {
                return -2L;
            }
        }

        public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SortColumn {
        private final long id;
        public final boolean decreasing;

        public SortColumn(long columnId, boolean decreasing) {
            this.id = columnId;
            this.decreasing = decreasing;
        }

        public long getId() {
            return this.id;
        }

        public long getIdx() {
            return this.id & 0xFFFFFFFFFFFFFL;
        }

        public int hashCode() {
            int h = (int)(this.id ^ this.id >>> 32);
            return this.decreasing ? -h : h;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (object instanceof SortColumn) {
                void other;
                SortColumn sortColumn = (SortColumn)object;
                SortColumn cfr_ignored_0 = (SortColumn)object;
                return this.id == other.id && this.decreasing == other.decreasing;
            }
            return false;
        }
    }
}

